/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.keying;

import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableEnum;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IAnimatableVec2d;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Resolution;
import ch.kuramo.javie.api.Vec2d;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.annotations.ShaderSource;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import com.google.inject.Inject;
import java.nio.FloatBuffer;
import java.util.HashSet;
import javax.media.opengl.GLUniformData;

@Effect(id="ch.kuramo.javie.ColorChart", category="ch.kuramo.javie.api.effectCategory.keying")
public class ColorChart {
    @Property(value="HSL")
    private IAnimatableEnum<ChartType> chartType;
    @Property(value="0.5", min="0", max="1.0")
    private IAnimatableDouble luma;
    @Property
    private IAnimatableVec2d location;
    @Property(value="100", min="0")
    private IAnimatableDouble size;
    private final IVideoEffectContext context;
    private final IVideoRenderSupport support;
    private final IShaderProgram yuvProgram;
    private final IShaderProgram hslProgram;
    @ShaderSource
    public static final String[] YUV_CHART = new String[]{"uniform vec2 location;", "uniform float size;", "uniform float luma;", "", "", "const vec3 rVec = vec3(1.0,  0.0    , -1.13983);", "const vec3 gVec = vec3(1.0, -0.39465,  0.58060);", "const vec3 bVec = vec3(1.0,  2.03211,  0.0);", "", "const vec3 vec3_000 = vec3(0.0);", "const vec3 vec3_111 = vec3(1.0);", "", "void main(void)", "{", "\tvec3 yuv = vec3(luma, (gl_FragCoord.xy-location)/size-0.5);", "\tvec3 rgb = vec3(dot(yuv, rVec), dot(yuv, gVec), dot(yuv, bVec));", "", "\tif (all(greaterThanEqual(rgb, vec3_000)) && all(lessThanEqual(rgb, vec3_111))) {", "\t\tgl_FragColor = vec4(rgb, 1.0);", "\t} else {", "\t\tgl_FragColor = vec4(0.5, 0.5, 0.5, 1.0);", "\t}", "}"};
    @ShaderSource(attach={"ch.kuramo.javie.effects.noiseGrain.FractalNoise.hsl2rgb"})
    public static final String[] HSL_CHART = new String[]{"uniform vec2 center;", "uniform float radius;", "uniform float luma;", "", "const float PI2 = 2.0*3.14159265358979323846264;", "vec3 hsl2rgb(vec3 hsl);", "", "void main(void)", "{", "\tvec2 xy = gl_FragCoord.xy-center;", "\tfloat h = -0.25-atan(xy.y, xy.x)/PI2;", "\tfloat s = distance(gl_FragCoord.xy, center)/radius;", "\tif (s <= 1.0) {", "\t\tvec3 hsl = vec3(h-floor(h), s, luma);", "\t\tvec3 rgb = hsl2rgb(hsl);", "\t\tgl_FragColor = vec4(rgb, 1.0);", "\t} else {", "\t\tgl_FragColor = vec4(0.5, 0.5, 0.5, 1.0);", "\t}", "}"};

    @Inject
    public ColorChart(IVideoEffectContext context, IVideoRenderSupport support, IShaderRegistry shaders) {
        this.context = context;
        this.support = support;
        this.yuvProgram = shaders.getProgram(ColorChart.class, "YUV_CHART");
        this.hslProgram = shaders.getProgram(ColorChart.class, "HSL_CHART");
    }

    public IVideoBuffer doVideoEffect() {
        IVideoBuffer input = this.context.doPreviousEffect();
        VideoBounds bounds = input.getBounds();
        if (bounds.isEmpty()) {
            return input;
        }
        Resolution resolution = this.context.getVideoResolution();
        Vec2d location = resolution.scale((Vec2d)this.context.value((IAnimatableValue)this.location));
        double size = resolution.scale(((Double)this.context.value((IAnimatableValue)this.size)).doubleValue());
        if (size == 0.0 || location.x >= bounds.x + (double)bounds.width || location.x + size <= bounds.x || location.y >= bounds.y + (double)bounds.height || location.y + size <= bounds.y) {
            return input;
        }
        ChartType chartType = (ChartType)((Object)this.context.value(this.chartType));
        double luma = (Double)this.context.value((IAnimatableValue)this.luma);
        try {
            switch (chartType) {
                case YUV: {
                    this.drawYUVChart(input, location, size, luma);
                    break;
                }
                case HSL: {
                    this.drawHSLChart(input, location, size, luma);
                }
            }
            IVideoBuffer result = input;
            input = null;
            IVideoBuffer iVideoBuffer = result;
            return iVideoBuffer;
        }
        finally {
            if (input != null) {
                input.dispose();
            }
        }
    }

    private void drawYUVChart(IVideoBuffer buffer, Vec2d location, double size, double luma) {
        final VideoBounds bounds = buffer.getBounds();
        final double left = location.x;
        final double top = location.y;
        final double right = left + size;
        final double bottom = top + size;
        HashSet<GLUniformData> uniforms = new HashSet<GLUniformData>();
        uniforms.add(new GLUniformData("location", 2, FloatBuffer.wrap(new float[]{(float)left, (float)top})));
        uniforms.add(new GLUniformData("size", (float)size));
        uniforms.add(new GLUniformData("luma", (float)luma));
        Runnable operation = new Runnable(){

            public void run() {
                ColorChart.this.support.ortho2D(bounds);
                ColorChart.this.support.quad2D(left, top, right, bottom, (double[][][])new double[0][][]);
            }
        };
        this.support.useShaderProgram(this.yuvProgram, uniforms, operation, 0, buffer, new IVideoBuffer[0]);
    }

    private void drawHSLChart(IVideoBuffer buffer, Vec2d location, double size, double luma) {
        final VideoBounds bounds = buffer.getBounds();
        final double left = location.x;
        final double top = location.y;
        final double right = left + size;
        final double bottom = top + size;
        double radius = size * 0.5;
        HashSet<GLUniformData> uniforms = new HashSet<GLUniformData>();
        uniforms.add(new GLUniformData("center", 2, FloatBuffer.wrap(new float[]{(float)(left + radius), (float)(top + radius)})));
        uniforms.add(new GLUniformData("radius", (float)radius));
        uniforms.add(new GLUniformData("luma", (float)luma));
        Runnable operation = new Runnable(){

            public void run() {
                ColorChart.this.support.ortho2D(bounds);
                ColorChart.this.support.quad2D(left, top, right, bottom, (double[][][])new double[0][][]);
            }
        };
        this.support.useShaderProgram(this.hslProgram, uniforms, operation, 0, buffer, new IVideoBuffer[0]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ChartType {
        HSL,
        YUV;

    }
}

