/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.perspective;

import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.IAnimatableBoolean;
import ch.kuramo.javie.api.IAnimatableColor;
import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Resolution;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.annotations.ShaderSource;
import ch.kuramo.javie.api.services.IBlurSupport;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import com.google.inject.Inject;
import java.nio.FloatBuffer;
import java.util.HashSet;
import javax.media.opengl.GLUniformData;

@Effect(id="ch.kuramo.javie.DropShadow", category="ch.kuramo.javie.api.effectCategory.perspective")
public class DropShadow {
    @Property(value="0,0,0")
    private IAnimatableColor shadowColor;
    @Property(value="50", min="0", max="100")
    private IAnimatableDouble opacity;
    @Property(value="135")
    private IAnimatableDouble direction;
    @Property(value="5", min="0", max="4000")
    private IAnimatableDouble distance;
    @Property(value="0", min="0", max="500")
    private IAnimatableDouble softness;
    @Property(value="true")
    private IAnimatableBoolean fast;
    @Property
    private IAnimatableBoolean shadowOnly;
    private final IVideoEffectContext context;
    private final IVideoRenderSupport support;
    private final IBlurSupport blurSupport;
    private final IShaderProgram normalProgram;
    private final IShaderProgram shadowOnlyProgram;
    @ShaderSource
    public static final String[] NORMAL = new String[]{"uniform sampler2DRect shadow;", "uniform sampler2DRect source;", "uniform vec4 shadowColor;", "uniform vec2 shadowOffset;", "", "void main(void)", "{", "\tfloat shadowAlpha = texture2DRect(shadow, gl_TexCoord[0].st + shadowOffset).a;", "\tvec4 sourceColor = texture2DRect(source, gl_TexCoord[1].st);", "\tgl_FragColor = sourceColor + shadowColor*shadowAlpha*(1.0-sourceColor.a);", "}"};
    @ShaderSource
    public static final String[] SHADOW_ONLY = new String[]{"uniform sampler2DRect shadow;", "uniform vec4 shadowColor;", "uniform vec2 shadowOffset;", "", "void main(void)", "{", "\tfloat shadowAlpha = texture2DRect(shadow, gl_TexCoord[0].st + shadowOffset).a;", "\tgl_FragColor = shadowColor*shadowAlpha;", "}"};

    @Inject
    public DropShadow(IVideoEffectContext context, IVideoRenderSupport support, IBlurSupport blurSupport, IShaderRegistry shaders) {
        this.context = context;
        this.support = support;
        this.blurSupport = blurSupport;
        this.normalProgram = shaders.getProgram(DropShadow.class, "NORMAL");
        this.shadowOnlyProgram = shaders.getProgram(DropShadow.class, "SHADOW_ONLY");
    }

    public VideoBounds getVideoBounds() {
        VideoBounds bounds = this.context.getPreviousBounds();
        if (bounds.isEmpty()) {
            return bounds;
        }
        double direction = (Double)this.context.value((IAnimatableValue)this.direction);
        double distance = (Double)this.context.value((IAnimatableValue)this.distance);
        double softness = (Double)this.context.value((IAnimatableValue)this.softness);
        boolean fast = softness > 50.0 || (Boolean)this.context.value((IAnimatableValue)this.fast) != false;
        Resolution resolution = this.context.getVideoResolution();
        distance = resolution.scale(distance);
        softness = resolution.scale(softness);
        double radians = Math.toRadians(direction);
        double distanceX = Math.sin(radians) * distance;
        double distanceY = -Math.cos(radians) * distance;
        VideoBounds shadowBounds = softness > 0.0 ? this.blurSupport.calcGaussianBlurredBounds(bounds, softness, IBlurSupport.BlurDimensions.BOTH, fast) : bounds;
        shadowBounds = new VideoBounds(shadowBounds.x + distanceX, shadowBounds.y + distanceY, shadowBounds.width, shadowBounds.height);
        double x1 = bounds.x + Math.floor(Math.min(bounds.x, shadowBounds.x) - bounds.x);
        double y1 = bounds.y + Math.floor(Math.min(bounds.y, shadowBounds.y) - bounds.y);
        double x2 = Math.max(bounds.x + (double)bounds.width, shadowBounds.x + (double)shadowBounds.width);
        double y2 = Math.max(bounds.y + (double)bounds.height, shadowBounds.y + (double)shadowBounds.height);
        return new VideoBounds(x1, y1, (int)Math.ceil(x2 - x1), (int)Math.ceil(y2 - y1));
    }

    public IVideoBuffer doVideoEffect() {
        IVideoBuffer source = this.context.doPreviousEffect();
        VideoBounds bounds = source.getBounds();
        if (bounds.isEmpty()) {
            return source;
        }
        Color shadowColor = (Color)this.context.value((IAnimatableValue)this.shadowColor);
        double opacity = (Double)this.context.value((IAnimatableValue)this.opacity) / 100.0;
        double direction = (Double)this.context.value((IAnimatableValue)this.direction);
        double distance = (Double)this.context.value((IAnimatableValue)this.distance);
        double softness = (Double)this.context.value((IAnimatableValue)this.softness);
        boolean fast = softness > 50.0 || (Boolean)this.context.value((IAnimatableValue)this.fast) != false;
        boolean shadowOnly = (Boolean)this.context.value((IAnimatableValue)this.shadowOnly);
        Resolution resolution = this.context.getVideoResolution();
        distance = resolution.scale(distance);
        softness = resolution.scale(softness);
        double radians = Math.toRadians(direction);
        double distanceX = Math.sin(radians) * distance;
        double distanceY = -Math.cos(radians) * distance;
        IVideoBuffer shadow = null;
        IVideoBuffer buffer = null;
        try {
            if (softness > 0.0) {
                shadow = this.blurSupport.gaussianBlur(source, softness, IBlurSupport.BlurDimensions.BOTH, false, fast);
                shadow.setTextureFilter(IVideoBuffer.TextureFilter.LINEAR);
            } else {
                shadow = source;
                shadow.setTextureFilter(IVideoBuffer.TextureFilter.LINEAR);
            }
            VideoBounds shadowBounds = shadow.getBounds();
            shadowBounds = new VideoBounds(shadowBounds.x + distanceX, shadowBounds.y + distanceY, shadowBounds.width, shadowBounds.height);
            double x1 = bounds.x + Math.floor(Math.min(bounds.x, shadowBounds.x) - bounds.x);
            double y1 = bounds.y + Math.floor(Math.min(bounds.y, shadowBounds.y) - bounds.y);
            double x2 = Math.max(bounds.x + (double)bounds.width, shadowBounds.x + (double)shadowBounds.width);
            double y2 = Math.max(bounds.y + (double)bounds.height, shadowBounds.y + (double)shadowBounds.height);
            buffer = this.context.createVideoBuffer(new VideoBounds(x1, y1, (int)Math.ceil(x2 - x1), (int)Math.ceil(y2 - y1)));
            HashSet<GLUniformData> uniforms = new HashSet<GLUniformData>();
            uniforms.add(new GLUniformData("shadow", 0));
            uniforms.add(new GLUniformData("shadowColor", 4, this.toFloatBuffer(shadowColor.r * opacity, shadowColor.g * opacity, shadowColor.b * opacity, opacity)));
            uniforms.add(new GLUniformData("shadowOffset", 2, this.toFloatBuffer(-distanceX, -distanceY)));
            if (shadowOnly) {
                this.support.useShaderProgram(this.shadowOnlyProgram, uniforms, buffer, new IVideoBuffer[]{shadow});
            } else {
                uniforms.add(new GLUniformData("source", 1));
                this.support.useShaderProgram(this.normalProgram, uniforms, buffer, new IVideoBuffer[]{shadow, source});
            }
            IVideoBuffer result = buffer;
            buffer = null;
            IVideoBuffer iVideoBuffer = result;
            return iVideoBuffer;
        }
        finally {
            if (buffer != null) {
                buffer.dispose();
            }
            if (shadow != null && shadow != source) {
                shadow.dispose();
            }
            source.dispose();
        }
    }

    private FloatBuffer toFloatBuffer(double ... values) {
        float[] array = new float[values.length];
        int i = 0;
        while (i < values.length) {
            array[i] = (float)values[i];
            ++i;
        }
        return FloatBuffer.wrap(array);
    }
}

