/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.stylize;

import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.IAnimatableColor;
import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.annotations.ShaderSource;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import com.google.inject.Inject;
import java.nio.FloatBuffer;
import java.util.HashSet;
import javax.media.opengl.GLUniformData;

@Effect(id="ch.kuramo.javie.FindEdges", category="ch.kuramo.javie.api.effectCategory.stylize")
public class FindEdges {
    @Property(value="0", min="0", max="100")
    private IAnimatableDouble threshold;
    @Property(value="100", min="0")
    private IAnimatableDouble strength;
    @Property(value="0", min="0", max="1")
    private IAnimatableDouble thickness;
    @Property(value="0,0,0")
    private IAnimatableColor edgeColor;
    @Property(value="1,1,1")
    private IAnimatableColor backgroundColor;
    @Property(value="100", min="0", max="100")
    private IAnimatableDouble backgroundOpacity;
    @Property(value="0", min="0", max="100")
    private IAnimatableDouble blendWithOriginal;
    private final IVideoEffectContext context;
    private final IVideoRenderSupport support;
    private final IShaderProgram luminosityProgram;
    private final IShaderProgram gradientProgram;
    private final IShaderProgram findEdgesProgram;
    @ShaderSource
    public static final String[] LUMINOSITY = new String[]{"uniform sampler2DRect source;", "", "const vec3 yvec = vec3(0.299, 0.587, 0.114);", "", "void main(void)", "{", "\tvec4 src = texture2DRect(source, gl_TexCoord[0].st);", "\tfloat y = (src.a != 0.0) ? dot(src.rgb/src.a, yvec) : 0.0;", "\tgl_FragColor = vec4(y, y, y, src.a);", "}"};
    @ShaderSource
    public static final String[] GRADIENT = new String[]{"uniform sampler2DRect luminosity;", "", "void main(void)", "{", "\tvec2 coord = gl_TexCoord[0].st;", "", "\tvec4 luma0 = texture2DRect(luminosity, coord);", "\tvec4 luma1 = texture2DRect(luminosity, coord + vec2( 0.0, -1.0));", "\tvec4 luma2 = texture2DRect(luminosity, coord + vec2(-1.0,  0.0));", "\tvec4 luma3 = texture2DRect(luminosity, coord + vec2( 1.0,  0.0));", "\tvec4 luma4 = texture2DRect(luminosity, coord + vec2( 0.0,  1.0));", "", "\tfloat tmp;", "\tfloat grad = 0.0;", "\tfloat alpha = 0.0;", "", "\ttmp = abs(luma1.r - luma0.r);", "\tif (tmp > grad) {", "\t\tgrad = tmp;", "\t\talpha = luma1.a;", "\t}", "", "\ttmp = abs(luma2.r - luma0.r);", "\tif (tmp > grad) {", "\t\tgrad = tmp;", "\t\talpha = luma2.a;", "\t}", "", "\ttmp = abs(luma3.r - luma0.r);", "\tif (tmp > grad) {", "\t\tgrad = tmp;", "\t\talpha = luma3.a;", "\t}", "", "\ttmp = abs(luma4.r - luma0.r);", "\tif (tmp > grad) {", "\t\tgrad = tmp;", "\t\talpha = luma4.a;", "\t}", "", "\talpha = max(alpha, luma0.a);", "", "\tfloat sum = texture2DRect(luminosity, coord + vec2(-1.0, -1.0)).r", "\t\t\t  + luma1.r", "\t\t\t  + texture2DRect(luminosity, coord + vec2( 1.0, -1.0)).r", "\t\t\t  + luma2.r", "\t\t\t  - 8.0*luma0.r", "\t\t\t  + luma3.r", "\t\t\t  + texture2DRect(luminosity, coord + vec2(-1.0,  1.0)).r", "\t\t\t  + luma4.r", "\t\t\t  + texture2DRect(luminosity, coord + vec2( 1.0,  1.0)).r;", "", "\tgl_FragColor = (sum > 0.0) ? vec4(grad, 0.0, 0.0, alpha) : vec4(0.0, grad, 0.0, alpha);", "}"};
    @ShaderSource
    public static final String[] FIND_EDGES = new String[]{"uniform sampler2DRect gradient;", "uniform sampler2DRect source;", "uniform float threshold;", "uniform float strength;", "uniform float thickness;", "uniform vec4 edgeColor;", "uniform vec4 bgColor;", "uniform float blend;", "", "void main(void)", "{", "\tvec2 coord = gl_TexCoord[0].st;", "\tvec4 grad = texture2DRect(gradient, coord);", "\tfloat edge = 0.0;", "", "\tif (grad.r != 0.0 && (", "\t\t\t   texture2DRect(gradient, coord + vec2(-1.0, -1.0)).g != 0.0", "\t\t\t|| texture2DRect(gradient, coord + vec2(-1.0,  0.0)).g != 0.0", "\t\t\t|| texture2DRect(gradient, coord + vec2(-1.0,  1.0)).g != 0.0", "\t\t\t|| texture2DRect(gradient, coord + vec2( 0.0, -1.0)).g != 0.0", "\t\t\t|| texture2DRect(gradient, coord + vec2( 0.0,  1.0)).g != 0.0", "\t\t\t|| texture2DRect(gradient, coord + vec2( 1.0, -1.0)).g != 0.0", "\t\t\t|| texture2DRect(gradient, coord + vec2( 1.0,  0.0)).g != 0.0", "\t\t\t|| texture2DRect(gradient, coord + vec2( 1.0,  1.0)).g != 0.0)) {", "", "\t\tedge = (grad.r > threshold) ? grad.r : 0.0;", "\t} else {", "\t\tedge = (grad.g > threshold) ? grad.g*thickness : 0.0;", "\t}", "", "\tedge = min(edge*strength, 1.0);", "\tvec4 color = edgeColor*edge + bgColor*(1.0-edge);", "", "\tvec4 src = texture2DRect(source, coord);", "\tgl_FragColor = color*grad.a*(1.0-blend) + src*blend;", "}"};

    @Inject
    public FindEdges(IVideoEffectContext context, IVideoRenderSupport support, IShaderRegistry shaders) {
        this.context = context;
        this.support = support;
        this.luminosityProgram = shaders.getProgram(FindEdges.class, "LUMINOSITY");
        this.gradientProgram = shaders.getProgram(FindEdges.class, "GRADIENT");
        this.findEdgesProgram = shaders.getProgram(FindEdges.class, "FIND_EDGES");
    }

    public IVideoBuffer doVideoEffect() {
        IVideoBuffer source = this.context.doPreviousEffect();
        if (source.getBounds().isEmpty()) {
            return source;
        }
        double threshold = (Double)this.context.value((IAnimatableValue)this.threshold) / 100.0;
        double strength = (Double)this.context.value((IAnimatableValue)this.strength) / 100.0;
        double thickness = (Double)this.context.value((IAnimatableValue)this.thickness);
        Color edgeColor = (Color)this.context.value((IAnimatableValue)this.edgeColor);
        Color bgColor = (Color)this.context.value((IAnimatableValue)this.backgroundColor);
        double bgOpacity = (Double)this.context.value((IAnimatableValue)this.backgroundOpacity) / 100.0;
        double blend = (Double)this.context.value((IAnimatableValue)this.blendWithOriginal) / 100.0;
        IVideoBuffer luminosity = null;
        IVideoBuffer gradient = null;
        try {
            HashSet<GLUniformData> uniforms = new HashSet<GLUniformData>();
            uniforms.add(new GLUniformData("source", 0));
            luminosity = this.support.useShaderProgram(this.luminosityProgram, uniforms, null, new IVideoBuffer[]{source});
            uniforms.clear();
            uniforms.add(new GLUniformData("luminosity", 0));
            gradient = this.support.useShaderProgram(this.gradientProgram, uniforms, null, new IVideoBuffer[]{luminosity});
            uniforms.clear();
            uniforms.add(new GLUniformData("gradient", 0));
            uniforms.add(new GLUniformData("source", 1));
            uniforms.add(new GLUniformData("threshold", (float)threshold));
            uniforms.add(new GLUniformData("strength", (float)strength));
            uniforms.add(new GLUniformData("thickness", (float)thickness));
            uniforms.add(new GLUniformData("edgeColor", 4, this.toFloatBuffer(edgeColor.r, edgeColor.g, edgeColor.b, 1.0)));
            uniforms.add(new GLUniformData("bgColor", 4, this.toFloatBuffer(bgColor.r * bgOpacity, bgColor.g * bgOpacity, bgColor.b * bgOpacity, bgOpacity)));
            uniforms.add(new GLUniformData("blend", (float)blend));
            IVideoBuffer iVideoBuffer = this.support.useShaderProgram(this.findEdgesProgram, uniforms, null, new IVideoBuffer[]{gradient, source});
            return iVideoBuffer;
        }
        finally {
            if (gradient != null) {
                gradient.dispose();
            }
            if (luminosity != null) {
                luminosity.dispose();
            }
            source.dispose();
        }
    }

    private FloatBuffer toFloatBuffer(double ... values) {
        float[] array = new float[values.length];
        int i = 0;
        while (i < values.length) {
            array[i] = (float)values[i];
            ++i;
        }
        return FloatBuffer.wrap(array);
    }
}

