/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.stylize;

import ch.kuramo.javie.api.BlendMode;
import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.IAnimatableBoolean;
import ch.kuramo.javie.api.IAnimatableColor;
import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableEnum;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.annotations.ShaderSource;
import ch.kuramo.javie.api.services.IBlendSupport;
import ch.kuramo.javie.api.services.IBlurSupport;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import com.google.inject.Inject;
import java.nio.FloatBuffer;
import java.util.HashSet;
import javax.media.opengl.GLUniformData;

@Effect(id="ch.kuramo.javie.Glow", category="ch.kuramo.javie.api.effectCategory.stylize")
public class Glow {
    @Property(value="ORIGINAL_COLORS")
    private IAnimatableEnum<GlowColors> colors;
    @Property(value="60", min="0", max="100")
    private IAnimatableDouble threshold;
    @Property(value="10", min="0", max="500")
    private IAnimatableDouble radius;
    @Property(value="1", min="0", max="255")
    private IAnimatableDouble intensity;
    @Property(value="NONE")
    private IAnimatableEnum<GlowComposite> composite;
    @Property(value="ADD")
    private IAnimatableEnum<BlendMode> operation;
    @Property(value="TRIANGLE_ABA")
    private IAnimatableEnum<GlowLooping> colorLooping;
    @Property(value="1", min="1", max="127")
    private IAnimatableDouble colorLoops;
    @Property
    private IAnimatableDouble colorPhase;
    @Property(value="50", min="0", max="100")
    private IAnimatableDouble abMidpoint;
    @Property(value="1,1,1")
    private IAnimatableColor colorA;
    @Property(value="0,0,0")
    private IAnimatableColor colorB;
    @Property
    private IAnimatableEnum<IBlurSupport.BlurDimensions> dimensions;
    @Property(value="true")
    private IAnimatableBoolean fast;
    private final IVideoEffectContext context;
    private final IVideoRenderSupport support;
    private final IBlurSupport blurSupport;
    private final IShaderProgram oColorsThresholdProgram;
    private final IShaderProgram abColorsThresholdProgram;
    private final IShaderProgram alphaBaseThresholdProgram;
    private final IShaderProgram sawtoothProgram;
    private final IShaderProgram triangleProgram;
    private final IShaderProgram oColorsIntensityProgram;
    private final IShaderProgram oColorsIntensityFloatProgram;
    private final IShaderProgram abColorsIntensityProgram;
    private final IBlendSupport[] blendSupports;
    @ShaderSource
    public static final String[] OCOLORS_THRESHOLD = new String[]{"uniform sampler2DRect texture;", "uniform float upper;", "uniform float lower;", "", "void main(void)", "{", "\tvec4 color = texture2DRect(texture, gl_TexCoord[0].st);", "\tfloat a = color.a;", "\tvec3 rgb = (a != 0.0) ? color.rgb/a : vec3(0.0);", "", "\trgb = clamp((rgb - lower) / (upper - lower), 0.0, 1.0);", "", "\tgl_FragColor = vec4(rgb*a, a);", "}"};
    @ShaderSource
    public static final String[] ABCOLORS_THRESHOLD = new String[]{"uniform sampler2DRect texture;", "uniform float upper;", "uniform float lower;", "", "const vec3 lumaVec = vec3(0.299, 0.587, 0.114);", "", "void main(void)", "{", "\tvec4 color = texture2DRect(texture, gl_TexCoord[0].st);", "", "\tfloat luma = dot(color.rgb, lumaVec);", "\tluma = clamp((luma - lower) / (upper - lower), 0.0, 1.0);", "", "\tgl_FragColor = vec4(luma);", "}"};
    @ShaderSource
    public static final String[] ALPHA_BASE_THRESHOLD = new String[]{"uniform sampler2DRect texture;", "uniform float upper;", "uniform float lower;", "", "void main(void)", "{", "\tfloat a = texture2DRect(texture, gl_TexCoord[0].st).a;", "", "\ta = clamp((a - lower) / (upper - lower), 0.0, 1.0);", "", "\tgl_FragColor = vec4(a);", "}"};
    @ShaderSource
    public static final String[] SAWTOOTH = new String[]{"uniform sampler2DRect texture;", "uniform float loops;", "uniform float phase;", "uniform float midpoint;", "uniform vec3 colorA;", "uniform vec3 colorM;", "uniform vec3 colorB;", "", "void main(void)", "{", "\tvec4 color = texture2DRect(texture, gl_TexCoord[0].st);", "\tfloat a = color.a;", "\tfloat t = phase + a * loops;", "", "\tif (t > 1.0) {", "\t\tt -= floor(t);", "\t}", "", "\tvec3 rgb;", "\tif (t > midpoint) {", "\t\tt = (t-midpoint)/(1.0-midpoint);", "\t\trgb = colorA*t + colorM*(1.0-t);", "\t} else {", "\t\tt = t/midpoint;", "\t\trgb = colorB*(1.0-t) + colorM*t;", "\t}", "", "\tgl_FragColor = vec4(rgb, 1.0)*a;", "}"};
    @ShaderSource
    public static final String[] TRIANGLE = new String[]{"uniform sampler2DRect texture;", "uniform float loops;", "uniform float phase;", "uniform float midpoint;", "uniform vec3 colorA;", "uniform vec3 colorM;", "uniform vec3 colorB;", "", "void main(void)", "{", "\tvec4 color = texture2DRect(texture, gl_TexCoord[0].st);", "\tfloat a = color.a;", "\tfloat t = phase + a * loops;", "", "\tt = 1.0 - 2.0 * abs(t - floor(t) - 0.5);", "", "\tvec3 rgb;", "\tif (t > midpoint) {", "\t\tt = (t-midpoint)/(1.0-midpoint);", "\t\trgb = colorA*t + colorM*(1.0-t);", "\t} else {", "\t\tt = t/midpoint;", "\t\trgb = colorB*(1.0-t) + colorM*t;", "\t}", "", "\tgl_FragColor = vec4(rgb, 1.0)*a;", "}"};
    @ShaderSource
    public static final String[] OCOLORS_INTENSITY = new String[]{"uniform sampler2DRect texture;", "uniform float intensity;", "", "void main(void)", "{", "\tvec4 color = texture2DRect(texture, gl_TexCoord[0].st);", "\tgl_FragColor = vec4(min(color.rgb*intensity, color.a), color.a);", "}"};
    @ShaderSource
    public static final String[] OCOLORS_INTENSITY_FLOAT = new String[]{"uniform sampler2DRect texture;", "uniform float intensity;", "", "void main(void)", "{", "\tvec4 color = texture2DRect(texture, gl_TexCoord[0].st);", "\tgl_FragColor = vec4(color.rgb*intensity, color.a);", "}"};
    @ShaderSource
    public static final String[] ABCOLORS_INTENSITY = new String[]{"uniform sampler2DRect texture;", "uniform float intensity;", "", "void main(void)", "{", "\tvec4 color = texture2DRect(texture, gl_TexCoord[0].st);", "\tgl_FragColor = vec4(color.rgb*intensity, min(color.a*intensity, 1.0));", "}"};
    private static final String BLEND_FUNCTIONS = "ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions";

    @Inject
    public Glow(IVideoEffectContext context, IVideoRenderSupport support, IBlurSupport blurSupport, IShaderRegistry shaders, IBlendSupport blendSupport0, IBlendSupport blendSupport1, IBlendSupport blendSupport2) {
        this.context = context;
        this.support = support;
        this.blurSupport = blurSupport;
        this.oColorsThresholdProgram = shaders.getProgram(Glow.class, "OCOLORS_THRESHOLD");
        this.abColorsThresholdProgram = shaders.getProgram(Glow.class, "ABCOLORS_THRESHOLD");
        this.alphaBaseThresholdProgram = shaders.getProgram(Glow.class, "ALPHA_BASE_THRESHOLD");
        this.sawtoothProgram = shaders.getProgram(Glow.class, "SAWTOOTH");
        this.triangleProgram = shaders.getProgram(Glow.class, "TRIANGLE");
        this.oColorsIntensityProgram = shaders.getProgram(Glow.class, "OCOLORS_INTENSITY");
        this.oColorsIntensityFloatProgram = shaders.getProgram(Glow.class, "OCOLORS_INTENSITY_FLOAT");
        this.abColorsIntensityProgram = shaders.getProgram(Glow.class, "ABCOLORS_INTENSITY");
        this.blendSupports = new IBlendSupport[]{blendSupport0, blendSupport1, blendSupport2};
        blendSupport0.setProgramsClass(CompositeOnTop.class);
        blendSupport1.setProgramsClass(CompositeBehind.class);
    }

    public VideoBounds getVideoBounds() {
        VideoBounds bounds = this.context.getPreviousBounds();
        if (bounds.isEmpty()) {
            return bounds;
        }
        double radius = (Double)this.context.value((IAnimatableValue)this.radius);
        if (radius == 0.0) {
            return bounds;
        }
        boolean fast = radius > 50.0 || (Boolean)this.context.value((IAnimatableValue)this.fast) != false;
        radius = this.context.getVideoResolution().scale(radius);
        IBlurSupport.BlurDimensions dimensions = (IBlurSupport.BlurDimensions)this.context.value(this.dimensions);
        return this.blurSupport.calcGaussianBlurredBounds(bounds, radius, dimensions, fast);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IVideoBuffer doVideoEffect() {
        input = this.context.doPreviousEffect();
        if (input.getBounds().isEmpty()) {
            return input;
        }
        tmpBuffers = new HashSet<IVideoBuffer>();
        tmpBuffers.add(input);
        try {
            colors = (GlowColors)this.context.value(this.colors);
            buffer = this.threshold(input, colors);
            tmpBuffers.add(buffer);
            buffer = this.blur(buffer);
            tmpBuffers.add(buffer);
            if (colors != GlowColors.ORIGINAL_COLORS) {
                buffer = this.abColors(buffer);
                tmpBuffers.add(buffer);
            }
            buffer = this.intensity(buffer, colors);
            tmpBuffers.add(buffer);
            buffer = this.composite(buffer, input);
            tmpBuffers.remove(buffer);
            var6_5 = buffer;
            return var6_5;
        }
        finally {
            ** for (vb : tmpBuffers)
        }
lbl-1000:
        // 1 sources

        {
            vb.dispose();
            continue;
        }
lbl31:
        // 1 sources

        return var6_5;
    }

    private IVideoBuffer threshold(IVideoBuffer input, GlowColors colors) {
        IShaderProgram program = colors == GlowColors.ORIGINAL_COLORS ? this.oColorsThresholdProgram : (colors == GlowColors.A_AND_B_COLORS ? this.abColorsThresholdProgram : this.alphaBaseThresholdProgram);
        double threshold = (Double)this.context.value((IAnimatableValue)this.threshold) / 100.0;
        double upper = Math.min(threshold + 0.0625, 1.0);
        double lower = Math.max(threshold - 0.0625, 0.0);
        HashSet<GLUniformData> uniforms = new HashSet<GLUniformData>();
        uniforms.add(new GLUniformData("texture", 0));
        uniforms.add(new GLUniformData("upper", (float)upper));
        uniforms.add(new GLUniformData("lower", (float)lower));
        return this.support.useShaderProgram(program, uniforms, null, new IVideoBuffer[]{input});
    }

    private IVideoBuffer blur(IVideoBuffer input) {
        double radius = (Double)this.context.value((IAnimatableValue)this.radius);
        if (radius == 0.0) {
            return input;
        }
        boolean fast = radius > 50.0 || (Boolean)this.context.value((IAnimatableValue)this.fast) != false;
        radius = this.context.getVideoResolution().scale(radius);
        IBlurSupport.BlurDimensions dimensions = (IBlurSupport.BlurDimensions)this.context.value(this.dimensions);
        return this.blurSupport.gaussianBlur(input, radius, dimensions, false, fast);
    }

    private IVideoBuffer abColors(IVideoBuffer input) {
        Color colorB;
        Color colorA;
        GlowLooping looping = (GlowLooping)((Object)this.context.value(this.colorLooping));
        double loops = (Double)this.context.value((IAnimatableValue)this.colorLoops);
        double phase = (Double)this.context.value((IAnimatableValue)this.colorPhase) / 360.0;
        double midpoint = 1.0 - (Double)this.context.value((IAnimatableValue)this.abMidpoint) / 100.0;
        if (looping == GlowLooping.SAWTOOTH_AB || looping == GlowLooping.TRIANGLE_ABA) {
            colorA = ((Color)this.context.value((IAnimatableValue)this.colorA)).clamp();
            colorB = ((Color)this.context.value((IAnimatableValue)this.colorB)).clamp();
        } else {
            colorA = ((Color)this.context.value((IAnimatableValue)this.colorB)).clamp();
            colorB = ((Color)this.context.value((IAnimatableValue)this.colorA)).clamp();
        }
        Color colorM = new Color((colorA.r + colorB.r) / 2.0, (colorA.g + colorB.g) / 2.0, (colorA.b + colorB.b) / 2.0);
        IShaderProgram program = looping == GlowLooping.SAWTOOTH_AB || looping == GlowLooping.SAWTOOTH_BA ? this.sawtoothProgram : this.triangleProgram;
        HashSet<GLUniformData> uniforms = new HashSet<GLUniformData>();
        uniforms.add(new GLUniformData("texture", 0));
        uniforms.add(new GLUniformData("loops", (float)loops));
        uniforms.add(new GLUniformData("phase", (float)phase));
        uniforms.add(new GLUniformData("midpoint", (float)midpoint));
        uniforms.add(new GLUniformData("colorA", 3, FloatBuffer.wrap(this.colorToFloat3(colorA))));
        uniforms.add(new GLUniformData("colorM", 3, FloatBuffer.wrap(this.colorToFloat3(colorM))));
        uniforms.add(new GLUniformData("colorB", 3, FloatBuffer.wrap(this.colorToFloat3(colorB))));
        return this.support.useShaderProgram(program, uniforms, null, new IVideoBuffer[]{input});
    }

    private float[] colorToFloat3(Color color) {
        return new float[]{(float)color.r, (float)color.g, (float)color.b};
    }

    private IVideoBuffer intensity(IVideoBuffer input, GlowColors colors) {
        double intensity = (Double)this.context.value((IAnimatableValue)this.intensity);
        if (intensity == 1.0) {
            return input;
        }
        IShaderProgram program = colors != GlowColors.ORIGINAL_COLORS ? this.abColorsIntensityProgram : (input.getColorMode().isFloat() ? this.oColorsIntensityFloatProgram : this.oColorsIntensityProgram);
        HashSet<GLUniformData> uniforms = new HashSet<GLUniformData>();
        uniforms.add(new GLUniformData("texture", 0));
        uniforms.add(new GLUniformData("intensity", (float)intensity));
        return this.support.useShaderProgram(program, uniforms, null, new IVideoBuffer[]{input});
    }

    private IVideoBuffer composite(IVideoBuffer glow, IVideoBuffer orig) {
        GlowComposite composite = (GlowComposite)((Object)this.context.value(this.composite));
        BlendMode operation = (BlendMode)this.context.value(this.operation);
        if (composite == GlowComposite.NONE && operation == BlendMode.NONE) {
            return glow;
        }
        return this.blendSupports[composite.ordinal()].blend(orig, glow, null, operation, 1.0, this.context);
    }

    private static String[] createCompositeSource(boolean onTop, String name, boolean dissolve) {
        boolean normal = name.equals("normal");
        return new String[]{"uniform sampler2DRect texDst;", "uniform sampler2DRect texSrc;", "uniform float opacity;", dissolve ? "uniform float dissolveSeed;" : "", "", String.format("vec4 blend_%s(vec4 pDst, vec4 pSrc, float opacity%s);", name, dissolve ? ", float dissolveSeed" : ""), !normal ? "vec4 blend_normal(vec4 pDst, vec4 pSrc, float opacity);" : "", "", "void main(void)", "{", "\tvec4 glow = texture2DRect(texDst, gl_TexCoord[0].st);", "\tvec4 orig = texture2DRect(texSrc, gl_TexCoord[1].st);", String.format("\tglow = blend_%s(glow, orig, opacity%s);", name, dissolve ? ", dissolveSeed" : ""), String.format("\tgl_FragColor = blend_normal(%s, 1.0);", onTop ? "glow, orig" : "orig, glow"), "}"};
    }

    public static class CompositeBehind {
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] NONE = CompositeBehind.createCompositeSource("none");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] NORMAL = CompositeBehind.createCompositeSource("normal");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] DISSOLVE = CompositeBehind.createCompositeSource("dissolve", true);
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] DARKEN = CompositeBehind.createCompositeSource("darken");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] MULTIPLY = CompositeBehind.createCompositeSource("multiply");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] COLOR_BURN = CompositeBehind.createCompositeSource("color_burn");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] LINEAR_BURN = CompositeBehind.createCompositeSource("linear_burn");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] DARKER_COLOR = CompositeBehind.createCompositeSource("darker_color");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] ADD = CompositeBehind.createCompositeSource("add");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] LIGHTEN = CompositeBehind.createCompositeSource("lighten");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] SCREEN = CompositeBehind.createCompositeSource("screen");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] COLOR_DODGE = CompositeBehind.createCompositeSource("color_dodge");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] LINEAR_DODGE = CompositeBehind.createCompositeSource("linear_dodge");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] LIGHTER_COLOR = CompositeBehind.createCompositeSource("lighter_color");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] OVERLAY = CompositeBehind.createCompositeSource("overlay");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] SOFT_LIGHT = CompositeBehind.createCompositeSource("soft_light");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] HARD_LIGHT = CompositeBehind.createCompositeSource("hard_light");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] LINEAR_LIGHT = CompositeBehind.createCompositeSource("linear_light");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] VIVID_LIGHT = CompositeBehind.createCompositeSource("vivid_light");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] PIN_LIGHT = CompositeBehind.createCompositeSource("pin_light");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] HARD_MIX = CompositeBehind.createCompositeSource("hard_mix");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] DIFFERENCE = CompositeBehind.createCompositeSource("difference");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] EXCLUSION = CompositeBehind.createCompositeSource("exclusion");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] HUE = CompositeBehind.createCompositeSource("hue");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] SATURATION = CompositeBehind.createCompositeSource("saturation");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] COLOR = CompositeBehind.createCompositeSource("color");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] LUMINOSITY = CompositeBehind.createCompositeSource("luminosity");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] STENCIL_ALPHA = CompositeBehind.createCompositeSource("stencil_alpha");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] STENCIL_LUMA = CompositeBehind.createCompositeSource("stencil_luma");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] SILHOUETTE_ALPHA = CompositeBehind.createCompositeSource("silhouette_alpha");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] SILHOUETTE_LUMA = CompositeBehind.createCompositeSource("silhouette_luma");

        private static String[] createCompositeSource(String name, boolean dissolve) {
            return Glow.createCompositeSource(false, name, dissolve);
        }

        private static String[] createCompositeSource(String name) {
            return Glow.createCompositeSource(false, name, false);
        }
    }

    public static class CompositeOnTop {
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] NONE = CompositeOnTop.createCompositeSource("none");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] NORMAL = CompositeOnTop.createCompositeSource("normal");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] DISSOLVE = CompositeOnTop.createCompositeSource("dissolve", true);
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] DARKEN = CompositeOnTop.createCompositeSource("darken");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] MULTIPLY = CompositeOnTop.createCompositeSource("multiply");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] COLOR_BURN = CompositeOnTop.createCompositeSource("color_burn");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] LINEAR_BURN = CompositeOnTop.createCompositeSource("linear_burn");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] DARKER_COLOR = CompositeOnTop.createCompositeSource("darker_color");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] ADD = CompositeOnTop.createCompositeSource("add");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] LIGHTEN = CompositeOnTop.createCompositeSource("lighten");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] SCREEN = CompositeOnTop.createCompositeSource("screen");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] COLOR_DODGE = CompositeOnTop.createCompositeSource("color_dodge");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] LINEAR_DODGE = CompositeOnTop.createCompositeSource("linear_dodge");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] LIGHTER_COLOR = CompositeOnTop.createCompositeSource("lighter_color");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] OVERLAY = CompositeOnTop.createCompositeSource("overlay");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] SOFT_LIGHT = CompositeOnTop.createCompositeSource("soft_light");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] HARD_LIGHT = CompositeOnTop.createCompositeSource("hard_light");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] LINEAR_LIGHT = CompositeOnTop.createCompositeSource("linear_light");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] VIVID_LIGHT = CompositeOnTop.createCompositeSource("vivid_light");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] PIN_LIGHT = CompositeOnTop.createCompositeSource("pin_light");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] HARD_MIX = CompositeOnTop.createCompositeSource("hard_mix");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] DIFFERENCE = CompositeOnTop.createCompositeSource("difference");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] EXCLUSION = CompositeOnTop.createCompositeSource("exclusion");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] HUE = CompositeOnTop.createCompositeSource("hue");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] SATURATION = CompositeOnTop.createCompositeSource("saturation");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] COLOR = CompositeOnTop.createCompositeSource("color");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] LUMINOSITY = CompositeOnTop.createCompositeSource("luminosity");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] STENCIL_ALPHA = CompositeOnTop.createCompositeSource("stencil_alpha");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] STENCIL_LUMA = CompositeOnTop.createCompositeSource("stencil_luma");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] SILHOUETTE_ALPHA = CompositeOnTop.createCompositeSource("silhouette_alpha");
        @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
        public static final String[] SILHOUETTE_LUMA = CompositeOnTop.createCompositeSource("silhouette_luma");

        private static String[] createCompositeSource(String name, boolean dissolve) {
            return Glow.createCompositeSource(true, name, dissolve);
        }

        private static String[] createCompositeSource(String name) {
            return Glow.createCompositeSource(true, name, false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GlowColors {
        ORIGINAL_COLORS,
        A_AND_B_COLORS,
        A_AND_B_COLORS_ALPHA_BASE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GlowComposite {
        ON_TOP,
        BEHIND,
        NONE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GlowLooping {
        SAWTOOTH_AB,
        SAWTOOTH_BA,
        TRIANGLE_ABA,
        TRIANGLE_BAB;

    }
}

