/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.stylize;

import ch.kuramo.javie.api.IAnimatableBoolean;
import ch.kuramo.javie.api.IAnimatableInteger;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.annotations.ShaderSource;
import ch.kuramo.javie.api.services.IConvolutionSupport;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import com.google.inject.Inject;
import java.util.HashSet;
import javax.media.opengl.GLUniformData;

@Effect(id="ch.kuramo.javie.Mosaic", category="ch.kuramo.javie.api.effectCategory.stylize")
public class Mosaic {
    @ShaderSource
    public static final String[] MOSAIC_SHARP_COLORS = new String[]{"uniform sampler2DRect texture;", "uniform float hSize;", "uniform float vSize;", "", "void main(void)", "{", "\tfloat s = (floor(gl_TexCoord[0].s/hSize)+0.5)*hSize;", "\tfloat t = (floor(gl_TexCoord[0].t/vSize)+0.5)*vSize;", "\tgl_FragColor = texture2DRect(texture, vec2(s, t));", "}"};
    @Property(value="10", min="1")
    private IAnimatableInteger horizontalBlocks;
    @Property(value="10", min="1")
    private IAnimatableInteger verticalBlocks;
    @Property
    private IAnimatableBoolean sharpColors;
    private final IVideoEffectContext context;
    private final IVideoRenderSupport support;
    private final IConvolutionSupport convolution;
    private final IShaderProgram sharpColorsProgram;

    @Inject
    public Mosaic(IVideoEffectContext context, IVideoRenderSupport support, IConvolutionSupport convolution, IShaderRegistry shaders) {
        this.context = context;
        this.support = support;
        this.convolution = convolution;
        this.sharpColorsProgram = shaders.getProgram(Mosaic.class, "MOSAIC_SHARP_COLORS");
    }

    public IVideoBuffer doVideoEffect() {
        IVideoBuffer input = this.context.doPreviousEffect();
        VideoBounds bounds = input.getBounds();
        if (bounds.isEmpty()) {
            return input;
        }
        int hBlocks = (Integer)this.context.value((IAnimatableValue)this.horizontalBlocks);
        int vBlocks = (Integer)this.context.value((IAnimatableValue)this.verticalBlocks);
        int w = bounds.width;
        int h = bounds.height;
        hBlocks = Math.min(hBlocks, w);
        vBlocks = Math.min(vBlocks, h);
        if (hBlocks == w && vBlocks == h) {
            return input;
        }
        boolean sharpColors = (Boolean)this.context.value((IAnimatableValue)this.sharpColors);
        IVideoBuffer output = null;
        try {
            output = sharpColors ? this.doSharpColorsMosaic(input, hBlocks, vBlocks) : this.doAverageColorsMosaic(input, hBlocks, vBlocks);
            IVideoBuffer iVideoBuffer = output;
            return iVideoBuffer;
        }
        finally {
            if (input != output) {
                input.dispose();
            }
        }
    }

    private IVideoBuffer doSharpColorsMosaic(IVideoBuffer input, int hBlocks, int vBlocks) {
        VideoBounds bounds = input.getBounds();
        double hSize = (double)bounds.width / (double)hBlocks;
        double vSize = (double)bounds.height / (double)vBlocks;
        HashSet<GLUniformData> uniforms = new HashSet<GLUniformData>();
        uniforms.add(new GLUniformData("texture", 0));
        uniforms.add(new GLUniformData("hSize", (float)hSize));
        uniforms.add(new GLUniformData("vSize", (float)vSize));
        return this.support.useShaderProgram(this.sharpColorsProgram, uniforms, null, new IVideoBuffer[]{input});
    }

    private IVideoBuffer doAverageColorsMosaic(IVideoBuffer input, int hBlocks, int vBlocks) {
        IVideoBuffer.TextureWrapMode wrapMode = input.getTextureWrapMode();
        IVideoBuffer buffer = null;
        try {
            buffer = this.context.createVideoBuffer(new VideoBounds(hBlocks, vBlocks));
            this.average(input, buffer);
            this.scale(buffer, input);
            IVideoBuffer iVideoBuffer = input;
            return iVideoBuffer;
        }
        finally {
            if (buffer != null) {
                buffer.dispose();
            }
            input.setTextureWrapMode(wrapMode);
        }
    }

    private void average(IVideoBuffer src, IVideoBuffer dst) {
        IVideoBuffer tmpBuf = null;
        try {
            VideoBounds srcBounds = src.getBounds();
            VideoBounds dstBounds = dst.getBounds();
            int hBlocks = dstBounds.width;
            int vBlocks = dstBounds.height;
            int hSize = srcBounds.width / hBlocks;
            int vSize = srcBounds.height / vBlocks;
            if (hSize > 7 || vSize > 7) {
                tmpBuf = this.context.createVideoBuffer(new VideoBounds(hSize > 7 ? hBlocks * 7 : hBlocks, vSize > 7 ? vBlocks * 7 : vBlocks));
                this.average(src, tmpBuf);
                src = tmpBuf;
                srcBounds = src.getBounds();
                hSize = srcBounds.width / hBlocks;
                vSize = srcBounds.height / vBlocks;
            }
            int ksize = hSize * vSize;
            float[] kernel = new float[ksize];
            float[] offset = new float[ksize * 2];
            int j = 0;
            while (j < vSize) {
                int i = 0;
                while (i < hSize) {
                    int k = j * hSize + i;
                    kernel[k] = 1.0f / (float)ksize;
                    offset[k * 2] = i - hSize / 2;
                    offset[k * 2 + 1] = j - vSize / 2;
                    ++i;
                }
                ++j;
            }
            int sw = srcBounds.width;
            int sh = srcBounds.height;
            final VideoBounds bounds = dstBounds;
            final double[][] texCoords = new double[][]{{0.0, 0.0}, {sw, 0.0}, {sw, sh}, {0.0, sh}};
            Runnable operation = new Runnable(){

                public void run() {
                    Mosaic.this.support.ortho2D(bounds);
                    Mosaic.this.support.quad2D(bounds, (double[][][])new double[][][]{texCoords});
                }
            };
            src.setTextureWrapMode(IVideoBuffer.TextureWrapMode.CLAMP_TO_EDGE);
            this.convolution.convolve(src, dst, kernel, offset, operation, 0);
        }
        finally {
            if (tmpBuf != null) {
                tmpBuf.dispose();
            }
        }
    }

    private void scale(IVideoBuffer src, IVideoBuffer dst) {
        final VideoBounds dstBounds = dst.getBounds();
        VideoBounds srcBounds = src.getBounds();
        int sw = srcBounds.width;
        int sh = srcBounds.height;
        final double[][] texCoords = new double[][]{{0.0, 0.0}, {sw, 0.0}, {sw, sh}, {0.0, sh}};
        Runnable operation = new Runnable(){

            public void run() {
                Mosaic.this.support.ortho2D(dstBounds);
                Mosaic.this.support.quad2D(dstBounds, (double[][][])new double[][][]{texCoords});
            }
        };
        this.support.useFramebuffer(operation, 0, dst, new IVideoBuffer[]{src});
    }
}

