/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.query;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.equinox.internal.p2.core.helpers.QueryHelpers;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.IMatchQuery;
import org.eclipse.equinox.internal.provisional.p2.query.Query;

public abstract class CompoundQuery
implements Query {
    protected Query[] queries;
    protected boolean and;

    public static CompoundQuery createCompoundQuery(Query[] queries, boolean and) {
        if (CompoundQuery.isMatchQueries(queries)) {
            return new MatchCompoundQuery(queries, and);
        }
        return new ContextCompoundQuery(queries, and);
    }

    public Query[] getQueries() {
        return this.queries;
    }

    public boolean isAnd() {
        return this.and;
    }

    protected CompoundQuery(Query[] queries, boolean and) {
        this.queries = queries;
        this.and = and;
    }

    private static boolean isMatchQueries(Query[] queries) {
        int i = 0;
        while (i < queries.length) {
            if (!(queries[i] instanceof IMatchQuery)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String getId() {
        return QueryHelpers.getId(this);
    }

    public Object getProperty(String property) {
        return QueryHelpers.getProperty(this, property);
    }

    private static class ContextCompoundQuery
    extends CompoundQuery {
        protected ContextCompoundQuery(Query[] queries, boolean and) {
            super(queries, and);
        }

        public Collector perform(Iterator iterator, Collector result) {
            if (this.queries.length < 1) {
                return result;
            }
            LinkedList data = new LinkedList();
            while (iterator.hasNext()) {
                data.add(iterator.next());
            }
            Set[] resultSets = new Set[this.queries.length];
            int i = 0;
            while (i < this.queries.length) {
                resultSets[i] = new HashSet();
                this.queries[i].perform(data.iterator(), new SetCollector(resultSets[i]));
                ++i;
            }
            Set set = resultSets[0];
            int i2 = 1;
            while (i2 < resultSets.length) {
                if (this.isAnd()) {
                    set.retainAll(resultSets[i2]);
                } else {
                    set.addAll(resultSets[i2]);
                }
                ++i2;
            }
            Iterator resultIterator = set.iterator();
            boolean gatherResults = true;
            while (resultIterator.hasNext() && gatherResults) {
                gatherResults = result.accept(resultIterator.next());
            }
            return result;
        }

        class SetCollector
        extends Collector {
            Set s = null;

            public SetCollector(Set s) {
                this.s = s;
            }

            public boolean accept(Object object) {
                this.s.add(object);
                return true;
            }
        }
    }

    private static class MatchCompoundQuery
    extends CompoundQuery
    implements IMatchQuery {
        protected MatchCompoundQuery(Query[] queries, boolean and) {
            super(queries, and);
        }

        public boolean isMatch(Object candidate) {
            int i = 0;
            while (i < this.queries.length) {
                boolean valid = ((IMatchQuery)this.queries[i]).isMatch(candidate);
                if (valid && !this.and) {
                    return true;
                }
                if (!valid && this.and) {
                    return false;
                }
                ++i;
            }
            return this.and;
        }

        public final Collector perform(Iterator iterator, Collector result) {
            this.prePerform();
            try {
                while (iterator.hasNext()) {
                    Object candidate = iterator.next();
                    if (!this.isMatch(candidate) || result.accept(candidate)) continue;
                    break;
                }
            }
            finally {
                this.postPerform();
            }
            return result;
        }

        public void prePerform() {
            int i = 0;
            while (i < this.queries.length) {
                ((IMatchQuery)this.queries[i]).prePerform();
                ++i;
            }
        }

        public void postPerform() {
            int i = 0;
            while (i < this.queries.length) {
                ((IMatchQuery)this.queries[i]).postPerform();
                ++i;
            }
        }
    }
}

