/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.app.InjectorHolder;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.ProjectDecodeException;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.services.ProjectDecoder;
import ch.kuramo.javie.core.services.ProjectEncoder;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveLayersOperation
extends ProjectOperation {
    private final String _compId;
    private final List<Entry> _entries = Util.newList();
    private final Map<String, String> _parents = Util.newMap();
    @Inject
    private ProjectEncoder _encoder;
    @Inject
    private ProjectDecoder _decoder;

    public RemoveLayersOperation(ProjectManager pm, Collection<Layer> layers) {
        super(pm, "\u30ec\u30a4\u30e4\u30fc\u306e\u6d88\u53bb");
        InjectorHolder.getInjector().injectMembers((Object)this);
        LayerComposition comp = pm.checkLayer(layers.iterator().next());
        this._compId = comp.getId();
        Set set = Util.newSet();
        for (Layer layer : layers) {
            int layerIndex = comp.getLayers().indexOf(layer);
            if (layerIndex == -1) {
                throw new IllegalArgumentException();
            }
            String data = this._encoder.encodeElement((Object)layer);
            this._entries.add(new Entry(data, layer.getId(), layerIndex));
            set.add(layer);
        }
        Collections.sort(this._entries, new Comparator<Entry>(){

            @Override
            public int compare(Entry o1, Entry o2) {
                return o1.layerIndex - o2.layerIndex;
            }
        });
        for (Layer layer : comp.getLayers()) {
            Layer parent = comp.getParentLayer(layer);
            if (parent == null || !set.contains(parent)) continue;
            this._parents.put(layer.getId(), parent.getId());
        }
    }

    @Override
    protected IStatus executeOrRedo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        LayerComposition comp = (LayerComposition)project.getComposition(this._compId);
        for (Map.Entry<String, String> e : this._parents.entrySet()) {
            Layer layer = comp.getLayer(e.getKey());
            comp.setParentLayer(layer, null);
            if (pm == null) continue;
            pm.fireLayerPropertyChange(layer, "parentId");
        }
        List layers = Util.newList();
        for (Entry e : this._entries) {
            layers.add(comp.getLayer(e.layerId));
        }
        comp.getLayers().removeAll(layers);
        if (pm != null) {
            pm.fireLayersRemove(comp, layers);
        }
        return Status.OK_STATUS;
    }

    @Override
    protected IStatus undo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        Layer layer;
        LayerComposition comp = (LayerComposition)project.getComposition(this._compId);
        List layers = null;
        if (pm != null) {
            layers = Util.newList();
        }
        for (Entry entry : this._entries) {
            try {
                layer = (Layer)this._decoder.decodeElement((CharSequence)entry.data, Layer.class);
                if (this._parents.containsKey(layer.getId())) {
                    comp.setParentLayer(layer, null);
                }
                layer.afterDecode(project, comp);
            }
            catch (ProjectDecodeException e1) {
                throw new ExecutionException("error decoding layer data", (Throwable)e1);
            }
            comp.getLayers().add(entry.layerIndex, layer);
            if (pm == null) continue;
            layers.add(layer);
        }
        for (Map.Entry entry : this._parents.entrySet()) {
            layer = comp.getLayer((String)entry.getKey());
            comp.setParentLayer(layer, comp.getLayer((String)entry.getValue()));
            if (pm == null) continue;
            pm.fireLayerPropertyChange(layer, "parentId");
        }
        if (pm != null) {
            pm.fireLayersAdd(comp, layers);
        }
        return Status.OK_STATUS;
    }

    private static class Entry {
        private String data;
        private String layerId;
        private int layerIndex;

        private Entry(String data, String layerId, int layerIndex) {
            this.data = data;
            this.layerId = layerId;
            this.layerIndex = layerIndex;
        }
    }
}

