/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.wizards;

import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.app.widgets.GridBuilder;
import ch.kuramo.javie.app.wizards.SolidColorItemSettings;
import java.util.Arrays;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class SolidColorItemWizardPage
extends WizardPage {
    private static final int MAX_SIZE = 4096;
    private SolidColorItemSettings _settings;
    private Color _color;
    private Text _nameText;
    private Text _widthText;
    private Text _heightText;
    private Button _freezeRatio;
    private ModifyListener _modifyListener;
    private Image _colorImage;
    private int _widthRatio;
    private int _heightRatio;

    public SolidColorItemWizardPage(SolidColorItemSettings settings) {
        super("SolidColorItemWizardPage", "\u5e73\u9762", null);
        this.setDescription("\u5e73\u9762\u3092\u4f5c\u6210\u3057\u307e\u3059\u3002");
        this._settings = settings;
        this._color = settings.color;
    }

    public void createControl(Composite parent) {
        GridBuilder gb = new GridBuilder(parent, 6, true);
        gb.hSpan(1).hAlign(131072).hGrab().label(0, "\u540d\u524d:");
        this._nameText = gb.hSpan(5).hAlign(4).hGrab().text(2048, this._settings.name);
        gb.hSpan(6).size(10, 10).composite(0);
        gb.hSpan(1).hAlign(131072).hGrab().label(0, "\u5e45:");
        this._widthText = gb.hSpan(1).hAlign(4).hGrab().text(2048, String.valueOf(this._settings.width));
        this._freezeRatio = gb.span(4, 2).hAlign(4).hGrab().button(32, "\u7e26\u6a2a\u6bd4\u3092\u56fa\u5b9a");
        gb.hSpan(1).hAlign(131072).hGrab().label(0, "\u9ad8\u3055:");
        this._heightText = gb.hSpan(1).hAlign(4).hGrab().tabAfter((Control)this._widthText).text(2048, String.valueOf(this._settings.height));
        gb.hSpan(6).size(10, 10).composite(0);
        gb.hSpan(1).hAlign(131072).hGrab().label(0, "\u30ab\u30e9\u30fc:");
        Button colorBtn = gb.hSpan(1).button(0x800008, "");
        gb.hSpan(4).size(10, 10).composite(0);
        this._modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SolidColorItemWizardPage.this.doValidate((Control)e.getSource());
            }
        };
        this._nameText.addModifyListener(this._modifyListener);
        this._widthText.addModifyListener(this._modifyListener);
        this._heightText.addModifyListener(this._modifyListener);
        this._freezeRatio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SolidColorItemWizardPage.this.doValidate((Control)SolidColorItemWizardPage.this._freezeRatio);
            }
        });
        colorBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColorDialog dialog = new ColorDialog(SolidColorItemWizardPage.this.getShell());
                dialog.setRGB(SolidColorItemWizardPage.this.getRGB());
                RGB rgb = dialog.open();
                if (rgb != null) {
                    SolidColorItemWizardPage.this.setRGB(rgb);
                    SolidColorItemWizardPage.this.updateColorButtonImage((Button)e.getSource(), rgb);
                }
            }
        });
        this.updateColorButtonImage(colorBtn, this.getRGB());
        Composite grid = gb.getComposite();
        grid.setTabList(gb.getTabList());
        this.doValidate(null);
        this.setControl((Control)grid);
    }

    public void dispose() {
        if (this._colorImage != null) {
            this._colorImage.dispose();
            this._colorImage = null;
        }
        super.dispose();
    }

    private RGB getRGB() {
        Color color = this._color.clamp();
        return new RGB((int)(color.r * 255.0), (int)(color.g * 255.0), (int)(color.b * 255.0));
    }

    private void setRGB(RGB rgb) {
        this._color = new Color((double)rgb.red / 255.0, (double)rgb.green / 255.0, (double)rgb.blue / 255.0, 1.0);
    }

    private void updateColorButtonImage(Button button, RGB rgb) {
        PaletteData palette = new PaletteData(new RGB[]{new RGB(0, 0, 0), rgb});
        byte[] data = new byte[192];
        Arrays.fill(data, (byte)-1);
        ImageData imageData = new ImageData(64, 24, 1, palette, 1, data);
        Image image = new Image((Device)button.getDisplay(), imageData);
        button.setImage(image);
        if (this._colorImage != null) {
            this._colorImage.dispose();
        }
        this._colorImage = image;
    }

    private void doValidate(Control control) {
        int height;
        int width;
        this.setPageComplete(false);
        String wStr = this._widthText.getText().trim();
        try {
            width = Integer.parseInt(wStr);
        }
        catch (NumberFormatException numberFormatException) {
            width = 0;
        }
        String hStr = this._heightText.getText().trim();
        try {
            height = Integer.parseInt(hStr);
        }
        catch (NumberFormatException numberFormatException) {
            height = 0;
        }
        boolean frozen = this._freezeRatio.getSelection();
        if (frozen) {
            if (control == this._widthText && width > 0) {
                height = Math.max(1, width * this._heightRatio / this._widthRatio);
                this._heightText.removeModifyListener(this._modifyListener);
                this._heightText.setText(String.valueOf(height));
                this._heightText.addModifyListener(this._modifyListener);
            } else if (control == this._heightText && height > 0) {
                width = Math.max(1, height * this._widthRatio / this._heightRatio);
                this._widthText.removeModifyListener(this._modifyListener);
                this._widthText.setText(String.valueOf(width));
                this._widthText.addModifyListener(this._modifyListener);
            }
        } else if ((control == null || control == this._widthText || control == this._heightText) && width > 0 && height > 0) {
            int gcd = this.gcd(width, height);
            this._widthRatio = width / gcd;
            this._heightRatio = height / gcd;
            this._freezeRatio.setText(String.format("\u7e26\u6a2a\u6bd4\u3092%d:%d\u306b\u56fa\u5b9a", this._widthRatio, this._heightRatio));
        }
        if (this._nameText.getText().trim().length() == 0) {
            this.setErrorMessage("\u540d\u524d\u304c\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            return;
        }
        if (wStr.length() == 0) {
            this.setErrorMessage("\u5e45\u304c\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            return;
        }
        if (width < 1 || width > 4096) {
            this.setErrorMessage(String.format("\u5e45\u306b\u306f1\u304b\u3089%d\u307e\u3067\u306e\u5024\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002", 4096));
            return;
        }
        if (hStr.length() == 0) {
            this.setErrorMessage("\u9ad8\u3055\u304c\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            return;
        }
        if (height < 1 || height > 4096) {
            this.setErrorMessage(String.format("\u9ad8\u3055\u306b\u306f1\u304b\u3089%d\u307e\u3067\u306e\u5024\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002", 4096));
            return;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    private int gcd(int x, int y) {
        while (y != 0) {
            int t = x % y;
            x = y;
            y = t;
        }
        return x;
    }

    public SolidColorItemSettings getResult() {
        if (!this.isPageComplete()) {
            return null;
        }
        SolidColorItemSettings result = new SolidColorItemSettings();
        result.name = this._nameText.getText().trim();
        result.width = Integer.parseInt(this._widthText.getText().trim());
        result.height = Integer.parseInt(this._heightText.getText().trim());
        result.color = this._color;
        return result;
    }
}

