/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.publisher.eclipse;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.equinox.p2.publisher.eclipse.Feature;
import org.eclipse.equinox.p2.publisher.eclipse.FeatureEntry;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FeatureManifestParser
extends DefaultHandler {
    private static final SAXParserFactory parserFactory = SAXParserFactory.newInstance();
    private SAXParser parser;
    protected Feature result;
    private URL url;
    private StringBuffer characters = null;
    private List messageKeys = new ArrayList();

    public FeatureManifestParser() {
        this(true);
    }

    public FeatureManifestParser(boolean createParser) {
        if (!createParser) {
            return;
        }
        try {
            parserFactory.setNamespaceAware(true);
            this.parser = parserFactory.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            System.out.println(e);
        }
        catch (SAXException e) {
            System.out.println(e);
        }
    }

    public void characters(char[] ch, int start, int length) {
        if (this.characters == null) {
            return;
        }
        this.characters.append(ch, start, length);
    }

    protected Feature createFeature(String id, String version) {
        return new Feature(id, version);
    }

    public void endElement(String uri, String localName, String qName) {
        if (this.characters == null) {
            return;
        }
        if ("description".equals(localName)) {
            this.result.setDescription(this.localize(this.characters.toString().trim()));
        } else if ("license".equals(localName)) {
            this.result.setLicense(this.localize(this.characters.toString().trim()));
        } else if ("copyright".equals(localName)) {
            this.result.setCopyright(this.localize(this.characters.toString().trim()));
        }
        this.characters = null;
    }

    public Feature getResult() {
        return this.result;
    }

    private String localize(String value) {
        if (value != null && value.startsWith("%")) {
            String key = value.substring(1);
            this.messageKeys.add(key);
        }
        return value;
    }

    public Feature parse(InputStream in) {
        this.result = null;
        try {
            this.parser.parse(new InputSource(in), (DefaultHandler)this);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.result;
    }

    public List getMessageKeys() {
        return this.messageKeys;
    }

    private void processCopyright(Attributes attributes) {
        this.result.setCopyrightURL(attributes.getValue("url"));
        this.characters = new StringBuffer();
    }

    private void processDescription(Attributes attributes) {
        this.result.setDescriptionURL(attributes.getValue("url"));
        this.characters = new StringBuffer();
    }

    private void processDiscoverySite(Attributes attributes) {
        if ("web".equals(attributes.getValue("type"))) {
            return;
        }
        this.result.addDiscoverySite(attributes.getValue("label"), attributes.getValue("url"));
    }

    protected void processFeature(Attributes attributes) {
        String id = attributes.getValue("id");
        String ver = attributes.getValue("version");
        if (id != null && !id.trim().equals("") && ver != null && !ver.trim().equals("")) {
            this.result = this.createFeature(id, ver);
            String os = attributes.getValue("os");
            String ws = attributes.getValue("ws");
            String nl = attributes.getValue("nl");
            String arch = attributes.getValue("arch");
            this.result.setEnvironment(os, ws, arch, nl);
            this.result.setApplication(attributes.getValue("application"));
            this.result.setPlugin(attributes.getValue("plugin"));
            this.result.setExclusive(Boolean.valueOf(attributes.getValue("exclusive")));
            this.result.setPrimary(Boolean.valueOf(attributes.getValue("primary")));
            this.result.setColocationAffinity(attributes.getValue("colocation-affinity"));
            if (this.url != null && "file".equals(this.url.getProtocol())) {
                File f = new File(this.url.getFile().replace('/', File.separatorChar));
                this.result.setURL("features/" + f.getParentFile().getName() + "/");
            }
            this.result.setProviderName(this.localize(attributes.getValue("provider-name")));
            this.result.setLabel(this.localize(attributes.getValue("label")));
            this.result.setImage(attributes.getValue("image"));
        }
    }

    private void processImport(Attributes attributes) {
        String id = attributes.getValue("feature");
        FeatureEntry entry = null;
        if (id != null) {
            if ("true".equalsIgnoreCase(attributes.getValue("patch"))) {
                entry = FeatureEntry.createRequires(id, attributes.getValue("version"), "perfect", attributes.getValue("filter"), false);
                entry.setPatch(true);
            } else {
                entry = FeatureEntry.createRequires(id, attributes.getValue("version"), attributes.getValue("match"), attributes.getValue("filter"), false);
            }
        } else {
            id = attributes.getValue("plugin");
            entry = FeatureEntry.createRequires(id, attributes.getValue("version"), attributes.getValue("match"), attributes.getValue("filter"), true);
        }
        this.result.addEntry(entry);
    }

    private void processIncludes(Attributes attributes) {
        FeatureEntry entry = new FeatureEntry(attributes.getValue("id"), attributes.getValue("version"), false);
        String flag = attributes.getValue("optional");
        if (flag != null) {
            entry.setOptional(Boolean.valueOf(flag));
        }
        this.setEnvironment(attributes, entry);
        this.result.addEntry(entry);
    }

    private void processInstallHandler(Attributes attributes) {
        this.result.setInstallHandler(attributes.getValue("handler"));
        this.result.setInstallHandlerLibrary(attributes.getValue("library"));
        this.result.setInstallHandlerURL(attributes.getValue("url"));
    }

    private void processLicense(Attributes attributes) {
        this.result.setLicenseURL(attributes.getValue("url"));
        this.characters = new StringBuffer();
    }

    private void processPlugin(Attributes attributes) {
        String id = attributes.getValue("id");
        String version = attributes.getValue("version");
        if (id == null || id.trim().equals("") || version == null || version.trim().equals("")) {
            System.out.println(NLS.bind((String)"FeatureParser#processPlugin, ID {0} or version {1} invalid", (Object[])new String[]{id, version}));
        } else {
            String filter;
            String fragment;
            FeatureEntry plugin = new FeatureEntry(id, version, true);
            this.setEnvironment(attributes, plugin);
            String unpack = attributes.getValue("unpack");
            if (unpack != null) {
                plugin.setUnpack(Boolean.valueOf(unpack));
            }
            if ((fragment = attributes.getValue("fragment")) != null) {
                plugin.setFragment(Boolean.valueOf(fragment));
            }
            if ((filter = attributes.getValue("filter")) != null) {
                plugin.setFilter(filter);
            }
            this.result.addEntry(plugin);
        }
    }

    private void processUpdateSite(Attributes attributes) {
        this.result.setUpdateSiteLabel(attributes.getValue("label"));
        this.result.setUpdateSiteURL(attributes.getValue("url"));
    }

    private void setEnvironment(Attributes attributes, FeatureEntry entry) {
        String os = attributes.getValue("os");
        String ws = attributes.getValue("ws");
        String nl = attributes.getValue("nl");
        String arch = attributes.getValue("arch");
        entry.setEnvironment(os, ws, arch, nl);
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if ("plugin".equals(localName)) {
            this.processPlugin(attributes);
        } else if ("description".equals(localName)) {
            this.processDescription(attributes);
        } else if ("license".equals(localName)) {
            this.processLicense(attributes);
        } else if ("copyright".equals(localName)) {
            this.processCopyright(attributes);
        } else if ("feature".equals(localName)) {
            this.processFeature(attributes);
        } else if ("import".equals(localName)) {
            this.processImport(attributes);
        } else if ("includes".equals(localName)) {
            this.processIncludes(attributes);
        } else if ("install-handler".equals(localName)) {
            this.processInstallHandler(attributes);
        } else if ("update".equals(localName)) {
            this.processUpdateSite(attributes);
        } else if ("discovery".equals(localName)) {
            this.processDiscoverySite(attributes);
        }
    }
}

