/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal;

import ch.kuramo.javie.core.AbstractTransformableLayer;
import ch.kuramo.javie.core.CoreContext;
import ch.kuramo.javie.core.Effect;
import ch.kuramo.javie.core.ExpressionScope;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.NullLayer;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.ProjectDecodeException;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.annotations.ProjectElement;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ProjectElement(value="nullLayer")
public class NullLayerImpl
extends AbstractTransformableLayer
implements NullLayer {
    private boolean _videoEnabled = true;
    private boolean _effectsEnabled = true;
    private List<Effect> _effects = Util.newList();

    @Override
    public boolean isVideoEnabled() {
        return this._videoEnabled;
    }

    @Override
    public void setVideoEnabled(boolean enabled) {
        this._videoEnabled = enabled;
    }

    @Override
    public boolean isEffectsEnabled() {
        return this._effectsEnabled;
    }

    @Override
    public void setEffectsEnabled(boolean effectsEnabled) {
        this._effectsEnabled = effectsEnabled;
    }

    @Override
    public List<Effect> getEffects() {
        return this._effects;
    }

    public void setEffects(List<Effect> effects) {
        this._effects = effects;
    }

    @Override
    public void afterDecode(Project p, LayerComposition c) throws ProjectDecodeException {
        super.afterDecode(p, c);
        for (Effect effect : this._effects) {
            effect.afterDecode(p);
        }
    }

    @Override
    public void prepareExpression(ExpressionScope scope) {
        super.prepareExpression(scope);
        for (Effect effect : this._effects) {
            effect.prepareExpression(scope.clone());
        }
    }

    @Override
    public Object createExpressionElement(CoreContext context) {
        return new NullLayerExpressionElement(context);
    }

    public class NullLayerExpressionElement
    extends AbstractTransformableLayer.TransformableLayerExpressionElement {
        public NullLayerExpressionElement(CoreContext context) {
            super(context);
        }

        public Object effect(int index) {
            Effect effect = (Effect)NullLayerImpl.this._effects.get(index - 1);
            return this.context.getExpressionElement(effect);
        }

        public Object effect(String name) {
            for (Effect e : NullLayerImpl.this._effects) {
                if (!e.getName().equals(name)) continue;
                return this.context.getExpressionElement(e);
            }
            return null;
        }
    }
}

