/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.ui.dialogs;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.dialogs.IResolutionErrorReportingPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.ISelectableIUsPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.InstallWizardPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.ResolutionResultsWizardPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.SelectableIUsPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.WizardWithLicenses;
import org.eclipse.equinox.internal.p2.ui.model.AvailableIUElement;
import org.eclipse.equinox.internal.p2.ui.model.ElementUtils;
import org.eclipse.equinox.internal.provisional.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUIImages;
import org.eclipse.equinox.internal.provisional.p2.ui.QueryableMetadataRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.ui.actions.InstallAction;
import org.eclipse.equinox.internal.provisional.p2.ui.model.IUElementListRoot;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.PlannerResolutionOperation;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.Policy;

public class PreselectedIUInstallWizard
extends WizardWithLicenses {
    SelectableIUsPage mainPage;
    QueryableMetadataRepositoryManager manager;

    static IUElementListRoot makeElementRoot(IInstallableUnit[] ius, String profileId) {
        IUElementListRoot elementRoot = new IUElementListRoot();
        Object[] elements = new Object[ius.length];
        int i = 0;
        while (i < ius.length) {
            if (ius[i] != null) {
                elements[i] = new AvailableIUElement(elementRoot, ius[i], profileId, false);
            }
            ++i;
        }
        elementRoot.setChildren(elements);
        return elementRoot;
    }

    public PreselectedIUInstallWizard(Policy policy, String profileId, IInstallableUnit[] initialSelections, PlannerResolutionOperation initialResolution, QueryableMetadataRepositoryManager manager) {
        super(policy, profileId, PreselectedIUInstallWizard.makeElementRoot(initialSelections, profileId), initialSelections, initialResolution);
        this.manager = manager;
        this.setWindowTitle(ProvUIMessages.InstallIUOperationLabel);
        this.setDefaultPageImageDescriptor(ProvUIImages.getImageDescriptor("wizban/install_wiz.gif"));
    }

    protected ISelectableIUsPage createMainPage(IUElementListRoot input, Object[] selections) {
        this.mainPage = new SelectableIUsPage(this.policy, input, selections, this.profileId);
        this.mainPage.setTitle(ProvUIMessages.PreselectedIUInstallWizard_Title);
        this.mainPage.setDescription(ProvUIMessages.PreselectedIUInstallWizard_Description);
        this.mainPage.updateStatus(input, this.resolutionOperation);
        return this.mainPage;
    }

    protected ResolutionResultsWizardPage createResolutionPage() {
        return new InstallWizardPage(this.policy, this.profileId, this.root, this.resolutionOperation);
    }

    protected IUElementListRoot makeResolutionElementRoot(Object[] selectedElements) {
        IUElementListRoot elementRoot = new IUElementListRoot();
        ArrayList<AvailableIUElement> list = new ArrayList<AvailableIUElement>(selectedElements.length);
        int i = 0;
        while (i < selectedElements.length) {
            IInstallableUnit iu = ElementUtils.getIU(selectedElements[i]);
            if (iu != null) {
                list.add(new AvailableIUElement(elementRoot, iu, this.profileId, this.policy.getQueryContext().getShowProvisioningPlanChildren()));
            }
            ++i;
        }
        elementRoot.setChildren(list.toArray());
        return elementRoot;
    }

    protected ProfileChangeRequest computeProfileChangeRequest(Object[] selectedElements, MultiStatus additionalStatus, IProgressMonitor monitor) {
        IInstallableUnit[] selected = ElementUtils.elementsToIUs(selectedElements);
        return InstallAction.computeProfileChangeRequest(selected, this.profileId, additionalStatus, monitor);
    }

    protected IResolutionErrorReportingPage getErrorReportingPage() {
        return this.mainPage;
    }
}

