/*
 * Decompiled with CFR 0.152.
 */
package ca.uol.aig.fftpack;

import ca.uol.aig.fftpack.Complex1D;
import ca.uol.aig.fftpack.ComplexDoubleFFT_Mixed;

public class ComplexDoubleFFT
extends ComplexDoubleFFT_Mixed {
    public double norm_factor;
    private double[] wavetable;
    private int ndim;

    public ComplexDoubleFFT(int n) {
        this.ndim = n;
        this.norm_factor = n;
        if (this.wavetable == null || this.wavetable.length != 4 * this.ndim + 15) {
            this.wavetable = new double[4 * this.ndim + 15];
        }
        this.cffti(this.ndim, this.wavetable);
    }

    public void ft(double[] x) {
        if (x.length != 2 * this.ndim) {
            throw new IllegalArgumentException("The length of data can not match that of the wavetable");
        }
        this.cfftf(this.ndim, x, this.wavetable);
    }

    public void ft(Complex1D x) {
        if (x.x.length != this.ndim) {
            throw new IllegalArgumentException("The length of data can not match that of the wavetable");
        }
        double[] y = new double[2 * this.ndim];
        int i = 0;
        while (i < this.ndim) {
            y[2 * i] = x.x[i];
            y[2 * i + 1] = x.y[i];
            ++i;
        }
        this.cfftf(this.ndim, y, this.wavetable);
        i = 0;
        while (i < this.ndim) {
            x.x[i] = y[2 * i];
            x.y[i] = y[2 * i + 1];
            ++i;
        }
    }

    public void bt(double[] x) {
        if (x.length != 2 * this.ndim) {
            throw new IllegalArgumentException("The length of data can not match that of the wavetable");
        }
        this.cfftb(this.ndim, x, this.wavetable);
    }

    public void bt(Complex1D x) {
        if (x.x.length != this.ndim) {
            throw new IllegalArgumentException("The length of data can not match that of the wavetable");
        }
        double[] y = new double[2 * this.ndim];
        int i = 0;
        while (i < this.ndim) {
            y[2 * i] = x.x[i];
            y[2 * i + 1] = x.y[i];
            ++i;
        }
        this.cfftb(this.ndim, y, this.wavetable);
        i = 0;
        while (i < this.ndim) {
            x.x[i] = y[2 * i];
            x.y[i] = y[2 * i + 1];
            ++i;
        }
    }
}

