/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.stylize;

import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.ColorMode;
import ch.kuramo.javie.api.IAnimatableBoolean;
import ch.kuramo.javie.api.IAnimatableColor;
import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableEnum;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Resolution;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.annotations.ShaderSource;
import ch.kuramo.javie.api.services.IBlurSupport;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import com.google.inject.Inject;
import java.nio.FloatBuffer;
import java.util.HashSet;
import javax.media.opengl.GLUniformData;

@Effect(id="ch.kuramo.javie.Border", category="ch.kuramo.javie.api.effectCategory.stylize")
public class Border {
    @Property(value="50", min="0", max="100")
    private IAnimatableDouble threshold;
    @Property
    private IAnimatableEnum<Style> style;
    @Property
    private IAnimatableEnum<Position> position;
    @Property(value="3", min="0", max="50")
    private IAnimatableDouble size;
    @Property
    private IAnimatableBoolean accuracy;
    @Property(value="1,0,0")
    private IAnimatableColor color;
    @Property(value="100", min="0", max="100")
    private IAnimatableDouble opacity;
    @Property
    private IAnimatableBoolean borderOnly;
    private final IVideoEffectContext context;
    private final IVideoRenderSupport support;
    private final IBlurSupport blurSupport;
    private final IShaderProgram binarizationProgram;
    private final IShaderProgram outsideProgram;
    private final IShaderProgram outsideBOProgram;
    private final IShaderProgram insideProgram;
    private final IShaderProgram insideBOProgram;
    private final IShaderProgram bothProgram;
    private final IShaderProgram bothBOProgram;
    @ShaderSource
    public static final String[] BINARIZATION = new String[]{"uniform sampler2D texture;", "uniform float threshold;", "", "void main(void)", "{", "\tfloat alpha = texture2D(texture, gl_TexCoord[0].st).a;", "\tgl_FragColor = (alpha <= threshold) ? vec4(0.0) : vec4(1.0);", "}"};
    @ShaderSource
    public static final String[] OUTSIDE = new String[]{"uniform sampler2D texBlurred;", "uniform sampler2D texSource;", "uniform float threshold;", "uniform float size;", "uniform vec4 color;", "", "void main(void)", "{", "\tvec4 source = texture2D(texSource, gl_TexCoord[1].st);", "\tif (source.a > threshold) {", "\t\tgl_FragColor = source + color*(1.0-source.a);", "\t} else {", "\t\tfloat a = texture2D(texBlurred, gl_TexCoord[0].st).a;", "\t\tif (a > 0.00621) {", "\t\t\ta = 1.0+asin(2.0*(a-0.00621)-1.0)*2.0/3.14159265358979323846264;", "\t\t\ta = clamp(a*size*(1.0-size*0.016), 0.0, 1.0);", "\t\t\tgl_FragColor = source + color*(1.0-source.a)*a;", "\t\t} else {", "\t\t\tgl_FragColor = source;", "\t\t}", "\t}", "}"};
    @ShaderSource
    public static final String[] OUTSIDE_BORDER_ONLY = new String[]{"uniform sampler2D texBlurred;", "uniform sampler2D texSource;", "uniform float threshold;", "uniform float size;", "uniform vec4 color;", "", "void main(void)", "{", "\tvec4 source = texture2D(texSource, gl_TexCoord[1].st);", "\tif (source.a > threshold) {", "\t\tgl_FragColor = color*(1.0-source.a);", "\t} else {", "\t\tfloat a = texture2D(texBlurred, gl_TexCoord[0].st).a;", "\t\tif (a > 0.00621) {", "\t\t\ta = 1.0+asin(2.0*(a-0.00621)-1.0)*2.0/3.14159265358979323846264;", "\t\t\ta = clamp(a*size*(1.0-size*0.016), 0.0, 1.0);", "\t\t\tgl_FragColor = color*(1.0-source.a)*a;", "\t\t} else {", "\t\t\tgl_FragColor = vec4(0.0);", "\t\t}", "\t}", "}"};
    @ShaderSource
    public static final String[] INSIDE = new String[]{"uniform sampler2D texBlurred;", "uniform sampler2D texSource;", "uniform float threshold;", "uniform float size;", "uniform vec4 color;", "", "void main(void)", "{", "\tvec4 source = texture2D(texSource, gl_TexCoord[1].st);", "\tif (source.a <= threshold) {", "\t\tgl_FragColor = color*(source.a/threshold) + source*(1.0-color.a);", "\t} else {", "\t\tfloat a = texture2D(texBlurred, gl_TexCoord[0].st).a;", "\t\tif (a < 0.99379) {", "\t\t\ta = 1.0-asin(2.0*(a+0.00621)-1.0)*2.0/3.14159265358979323846264;", "\t\t\ta = clamp(a*size*(1.0-size*0.016), 0.0, 1.0);", "\t\t\tgl_FragColor = color*a + source*(1.0-color.a*a);", "\t\t} else {", "\t\t\tgl_FragColor = source;", "\t\t}", "\t}", "}"};
    @ShaderSource
    public static final String[] INSIDE_BORDER_ONLY = new String[]{"uniform sampler2D texBlurred;", "uniform sampler2D texSource;", "uniform float threshold;", "uniform float size;", "uniform vec4 color;", "", "void main(void)", "{", "\tvec4 source = texture2D(texSource, gl_TexCoord[1].st);", "\tif (source.a <= threshold) {", "\t\tgl_FragColor = color*(source.a/threshold);", "\t} else {", "\t\tfloat a = texture2D(texBlurred, gl_TexCoord[0].st).a;", "\t\tif (a < 0.99379) {", "\t\t\ta = 1.0-asin(2.0*(a+0.00621)-1.0)*2.0/3.14159265358979323846264;", "\t\t\ta = clamp(a*size*(1.0-size*0.016), 0.0, 1.0);", "\t\t\tgl_FragColor = color*a;", "\t\t} else {", "\t\t\tgl_FragColor = vec4(0.0);", "\t\t}", "\t}", "}"};
    @ShaderSource
    public static final String[] BOTH = new String[]{"uniform sampler2D texBlurred;", "uniform sampler2D texSource;", "uniform float threshold;", "uniform float size;", "uniform vec4 color;", "", "void main(void)", "{", "\tvec4 source = texture2D(texSource, gl_TexCoord[1].st);", "\tfloat a = texture2D(texBlurred, gl_TexCoord[0].st).a;", "\tif (a > 0.00621 && a < 0.99379) {", "\t\tif (a < 0.5) {", "\t\t\ta = 1.0+asin(2.0*(a-0.00621)-1.0)*2.0/3.14159265358979323846264;", "\t\t} else {", "\t\t\ta = 1.0-asin(2.0*(a+0.00621)-1.0)*2.0/3.14159265358979323846264;", "\t\t}", "\t\ta = clamp(a*size*(1.0-size*0.016), 0.0, 1.0);", "\t\tgl_FragColor = color*a + source*(1.0-color.a*a);", "\t} else {", "\t\tgl_FragColor = source;", "\t}", "}"};
    @ShaderSource
    public static final String[] BOTH_BORDER_ONLY = new String[]{"uniform sampler2D texBlurred;", "uniform sampler2D texSource;", "uniform float threshold;", "uniform float size;", "uniform vec4 color;", "", "void main(void)", "{", "\tvec4 source = texture2D(texSource, gl_TexCoord[1].st);", "\tfloat a = texture2D(texBlurred, gl_TexCoord[0].st).a;", "\tif (a > 0.00621 && a < 0.99379) {", "\t\tif (a < 0.5) {", "\t\t\ta = 1.0+asin(2.0*(a-0.00621)-1.0)*2.0/3.14159265358979323846264;", "\t\t} else {", "\t\t\ta = 1.0-asin(2.0*(a+0.00621)-1.0)*2.0/3.14159265358979323846264;", "\t\t}", "\t\ta = clamp(a*size*(1.0-size*0.016), 0.0, 1.0);", "\t\tgl_FragColor = color*a;", "\t} else {", "\t\tgl_FragColor = vec4(0.0);", "\t}", "}"};

    @Inject
    public Border(IVideoEffectContext context, IVideoRenderSupport support, IBlurSupport blurSupport, IShaderRegistry shaders) {
        this.context = context;
        this.support = support;
        this.blurSupport = blurSupport;
        this.binarizationProgram = shaders.getProgram(Border.class, "BINARIZATION");
        this.outsideProgram = shaders.getProgram(Border.class, "OUTSIDE");
        this.outsideBOProgram = shaders.getProgram(Border.class, "OUTSIDE_BORDER_ONLY");
        this.insideProgram = shaders.getProgram(Border.class, "INSIDE");
        this.insideBOProgram = shaders.getProgram(Border.class, "INSIDE_BORDER_ONLY");
        this.bothProgram = shaders.getProgram(Border.class, "BOTH");
        this.bothBOProgram = shaders.getProgram(Border.class, "BOTH_BORDER_ONLY");
    }

    public VideoBounds getVideoBounds() {
        VideoBounds bounds = this.context.getPreviousBounds();
        if (bounds.isEmpty()) {
            return bounds;
        }
        Resolution resolution = this.context.getVideoResolution();
        double size = resolution.scale(((Double)this.context.value((IAnimatableValue)this.size)).doubleValue());
        Style style = (Style)((Object)this.context.value(this.style));
        if (size > 0.0) {
            switch (style) {
                case SMOOTH: {
                    return this.blurSupport.calcGaussianBlurredBounds(bounds, size, IBlurSupport.BlurDimensions.BOTH, false);
                }
                case BOX: {
                    return this.blurSupport.calcBoxBlurredBounds(bounds, size, IBlurSupport.BlurDimensions.BOTH, false, 1);
                }
            }
            throw new RuntimeException("unknown Style: " + (Object)((Object)style));
        }
        return bounds;
    }

    public IVideoBuffer doVideoEffect() {
        IShaderProgram program;
        IVideoBuffer source = this.context.doPreviousEffect();
        if (source.getBounds().isEmpty()) {
            return source;
        }
        Resolution resolution = this.context.getVideoResolution();
        double threshold = (Double)this.context.value((IAnimatableValue)this.threshold) / 100.0;
        Style style = (Style)((Object)this.context.value(this.style));
        Position position = (Position)((Object)this.context.value(this.position));
        double size = resolution.scale(((Double)this.context.value((IAnimatableValue)this.size)).doubleValue());
        boolean accuracy = (Boolean)this.context.value((IAnimatableValue)this.accuracy);
        Color color = (Color)this.context.value((IAnimatableValue)this.color);
        double opacity = (Double)this.context.value((IAnimatableValue)this.opacity) / 100.0;
        boolean borderOnly = (Boolean)this.context.value((IAnimatableValue)this.borderOnly);
        switch (position) {
            case OUTSIDE: {
                program = borderOnly ? this.outsideBOProgram : this.outsideProgram;
                break;
            }
            case INSIDE: {
                program = borderOnly ? this.insideBOProgram : this.insideProgram;
                break;
            }
            case BOTH: {
                program = borderOnly ? this.bothBOProgram : this.bothProgram;
                break;
            }
            default: {
                throw new RuntimeException("unknown Position: " + (Object)((Object)position));
            }
        }
        IVideoBuffer binary = null;
        IVideoBuffer blurred = null;
        try {
            HashSet<GLUniformData> uniforms;
            block16: {
                block15: {
                    uniforms = new HashSet<GLUniformData>();
                    uniforms.add(new GLUniformData("texture", 0));
                    uniforms.add(new GLUniformData("threshold", (float)threshold));
                    binary = accuracy && !this.context.getColorMode().isFloat() ? this.support.createVideoBuffer(source.getBounds(), ColorMode.RGBA16_FLOAT) : this.support.createVideoBuffer(source.getBounds());
                    this.support.useShaderProgram(this.binarizationProgram, uniforms, binary, new IVideoBuffer[]{source});
                    if (!(size > 0.0)) break block15;
                    switch (style) {
                        case SMOOTH: {
                            blurred = this.blurSupport.gaussianBlur(binary, size, IBlurSupport.BlurDimensions.BOTH, false, false);
                            break block16;
                        }
                        case BOX: {
                            blurred = this.blurSupport.boxBlur(binary, size, IBlurSupport.BlurDimensions.BOTH, false, false, 1);
                            break block16;
                        }
                        default: {
                            throw new RuntimeException("unknown Style: " + (Object)((Object)style));
                        }
                    }
                }
                blurred = binary;
            }
            uniforms.clear();
            uniforms.add(new GLUniformData("texBlurred", 0));
            uniforms.add(new GLUniformData("texSource", 1));
            uniforms.add(new GLUniformData("threshold", (float)threshold));
            uniforms.add(new GLUniformData("size", (float)size));
            uniforms.add(new GLUniformData("color", 4, this.toFloatBuffer(color.r * opacity, color.g * opacity, color.b * opacity, opacity)));
            IVideoBuffer iVideoBuffer = this.support.useShaderProgram(program, uniforms, null, new IVideoBuffer[]{blurred, source});
            return iVideoBuffer;
        }
        finally {
            if (blurred != null && blurred != binary) {
                blurred.dispose();
            }
            if (binary != null) {
                binary.dispose();
            }
            source.dispose();
        }
    }

    private FloatBuffer toFloatBuffer(double ... values) {
        float[] array = new float[values.length];
        int i = 0;
        while (i < values.length) {
            array[i] = (float)values[i];
            ++i;
        }
        return FloatBuffer.wrap(array);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Position {
        OUTSIDE,
        INSIDE,
        BOTH;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Style {
        SMOOTH,
        BOX;

    }
}

