/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl.windows.wgl;

import com.sun.opengl.impl.Debug;
import com.sun.opengl.impl.GLContextImpl;
import com.sun.opengl.impl.GLDrawableImpl;
import com.sun.opengl.impl.windows.wgl.PIXELFORMATDESCRIPTOR;
import com.sun.opengl.impl.windows.wgl.WGL;
import com.sun.opengl.impl.windows.wgl.WGLExt;
import com.sun.opengl.impl.windows.wgl.WindowsDummyWGLDrawable;
import com.sun.opengl.impl.windows.wgl.WindowsWGLGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.Capabilities;
import javax.media.nativewindow.CapabilitiesChooser;
import javax.media.nativewindow.DefaultGraphicsScreen;
import javax.media.nativewindow.GraphicsConfigurationFactory;
import javax.media.nativewindow.NativeWindow;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.windows.WindowsGraphicsDevice;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;

public class WindowsWGLGraphicsConfigurationFactory
extends GraphicsConfigurationFactory {
    protected static final boolean DEBUG = Debug.debug("GraphicsConfiguration");

    public WindowsWGLGraphicsConfigurationFactory() {
        GraphicsConfigurationFactory.registerFactory((Class)WindowsGraphicsDevice.class, (GraphicsConfigurationFactory)this);
    }

    public AbstractGraphicsConfiguration chooseGraphicsConfiguration(Capabilities capabilities, CapabilitiesChooser capabilitiesChooser, AbstractGraphicsScreen abstractGraphicsScreen) {
        GLCapabilities gLCapabilities = (GLCapabilities)capabilities;
        return WindowsWGLGraphicsConfigurationFactory.chooseGraphicsConfigurationStatic(gLCapabilities, capabilitiesChooser, abstractGraphicsScreen, gLCapabilities.isOnscreen(), gLCapabilities.isPBuffer());
    }

    protected static WindowsWGLGraphicsConfiguration createDefaultGraphicsConfiguration(AbstractGraphicsScreen abstractGraphicsScreen, boolean bl, boolean bl2) {
        GLCapabilities gLCapabilities = new GLCapabilities(null);
        gLCapabilities.setOnscreen(bl);
        gLCapabilities.setPBuffer(bl2);
        if (!bl) {
            gLCapabilities.setDoubleBuffered(false);
        }
        if (null == abstractGraphicsScreen) {
            abstractGraphicsScreen = DefaultGraphicsScreen.createScreenDevice((int)0);
        }
        return new WindowsWGLGraphicsConfiguration(abstractGraphicsScreen, gLCapabilities, gLCapabilities, WindowsWGLGraphicsConfiguration.GLCapabilities2PFD(gLCapabilities), -1, null);
    }

    protected static WindowsWGLGraphicsConfiguration chooseGraphicsConfigurationStatic(GLCapabilities gLCapabilities, CapabilitiesChooser capabilitiesChooser, AbstractGraphicsScreen abstractGraphicsScreen, boolean bl, boolean bl2) {
        if (null == abstractGraphicsScreen) {
            abstractGraphicsScreen = DefaultGraphicsScreen.createScreenDevice((int)0);
        }
        gLCapabilities.setOnscreen(bl);
        gLCapabilities.setPBuffer(bl2);
        if (!bl) {
            gLCapabilities.setDoubleBuffered(false);
        }
        return new WindowsWGLGraphicsConfiguration(abstractGraphicsScreen, gLCapabilities, gLCapabilities, WindowsWGLGraphicsConfiguration.GLCapabilities2PFD(gLCapabilities), -1, (GLCapabilitiesChooser)capabilitiesChooser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void updateGraphicsConfiguration(CapabilitiesChooser capabilitiesChooser, GLDrawableFactory gLDrawableFactory, NativeWindow nativeWindow) {
        Object object;
        if (nativeWindow == null) {
            throw new IllegalArgumentException("NativeWindow is null");
        }
        if (capabilitiesChooser != null && !(capabilitiesChooser instanceof GLCapabilitiesChooser)) {
            throw new IllegalArgumentException("This NativeWindowFactory accepts only GLCapabilitiesChooser objects");
        }
        boolean bl = false;
        WindowsWGLGraphicsConfiguration windowsWGLGraphicsConfiguration = (WindowsWGLGraphicsConfiguration)nativeWindow.getGraphicsConfiguration().getNativeGraphicsConfiguration();
        GLCapabilities gLCapabilities = (GLCapabilities)windowsWGLGraphicsConfiguration.getRequestedCapabilities();
        boolean bl2 = gLCapabilities.isOnscreen();
        boolean bl3 = gLCapabilities.isPBuffer();
        GLProfile gLProfile = gLCapabilities.getGLProfile();
        long l = nativeWindow.getSurfaceHandle();
        if (DEBUG) {
            object = new Exception("WindowsWGLGraphicsConfigurationFactory got HDC 0x" + Long.toHexString(l));
            ((Throwable)object).printStackTrace();
            System.err.println("WindowsWGLGraphicsConfigurationFactory got NW    " + nativeWindow);
        }
        object = null;
        int n = -1;
        boolean bl4 = false;
        Object var14_13 = null;
        if (bl2) {
            n = WGL.GetPixelFormat(l);
            if (n != 0) {
                if (DEBUG) {
                    System.err.println("!!!! NOTE: pixel format already chosen for HDC: 0x" + Long.toHexString(l) + ", pixelformat " + n);
                }
                bl4 = true;
            }
            GLCapabilities[] gLCapabilitiesArray = null;
            int n2 = 0;
            object = WindowsWGLGraphicsConfiguration.createPixelFormatDescriptor();
            WindowsDummyWGLDrawable windowsDummyWGLDrawable = null;
            GLContextImpl gLContextImpl = null;
            WGLExt wGLExt = null;
            if (gLCapabilities.getSampleBuffers() && (gLContextImpl = (GLContextImpl)(windowsDummyWGLDrawable = new WindowsDummyWGLDrawable(gLDrawableFactory)).createContext(null)) != null) {
                gLContextImpl.makeCurrent();
                wGLExt = (WGLExt)gLContextImpl.getPlatformGLExtensions();
            }
            int n3 = n;
            boolean bl5 = false;
            boolean bl6 = false;
            if (wGLExt != null) {
                try {
                    bl5 = wGLExt.isExtensionAvailable("WGL_ARB_pixel_format");
                    if (bl5) {
                        if (n <= 0) {
                            int[] nArray = new int[512];
                            float[] fArray = new float[1];
                            if (WindowsWGLGraphicsConfiguration.GLCapabilities2AttribList(gLCapabilities, nArray, wGLExt, false, null)) {
                                int[] nArray2 = new int[256];
                                int[] nArray3 = new int[1];
                                if (wGLExt.wglChoosePixelFormatARB(l, nArray, 0, fArray, 0, 256, nArray2, 0, nArray3, 0)) {
                                    n2 = nArray3[0];
                                    if (n3 <= 0 && n2 > 0) {
                                        n3 = nArray2[0];
                                        if (DEBUG) {
                                            System.err.println(WindowsWGLGraphicsConfigurationFactory.getThreadName() + ": Used wglChoosePixelFormatARB to recommend pixel format " + n3);
                                        }
                                    }
                                } else if (DEBUG) {
                                    System.err.println(WindowsWGLGraphicsConfigurationFactory.getThreadName() + ": wglChoosePixelFormatARB failed: " + WGL.GetLastError());
                                    Thread.dumpStack();
                                }
                                if (DEBUG && n3 <= 0) {
                                    System.err.print(WindowsWGLGraphicsConfigurationFactory.getThreadName() + ": wglChoosePixelFormatARB didn't recommend a pixel format");
                                    if (gLCapabilities.getSampleBuffers()) {
                                        System.err.print(" for multisampled GLCapabilities");
                                    }
                                    System.err.println();
                                }
                            }
                        }
                        bl = bl6 = null != (gLCapabilitiesArray = WindowsWGLGraphicsConfiguration.HDC2GLCapabilities(wGLExt, l, -1, gLProfile, bl4, bl2, bl3));
                    }
                }
                finally {
                    gLContextImpl.release();
                    gLContextImpl.destroy();
                    ((GLDrawableImpl)windowsDummyWGLDrawable).destroy();
                }
            }
            if (!bl6) {
                if (DEBUG) {
                    if (!gLCapabilities.getSampleBuffers()) {
                        System.err.println(WindowsWGLGraphicsConfigurationFactory.getThreadName() + ": Using ChoosePixelFormat because multisampling not requested");
                    } else {
                        System.err.println(WindowsWGLGraphicsConfigurationFactory.getThreadName() + ": Using ChoosePixelFormat because no wglChoosePixelFormatARB");
                    }
                }
                object = WindowsWGLGraphicsConfiguration.GLCapabilities2PFD(gLCapabilities);
                n3 = WGL.ChoosePixelFormat(l, (PIXELFORMATDESCRIPTOR)object);
                if (DEBUG) {
                    System.err.println(WindowsWGLGraphicsConfigurationFactory.getThreadName() + ": Recommended pixel format = " + n3);
                }
                if ((n2 = WGL.DescribePixelFormat(l, 1, 0, null)) == 0) {
                    throw new GLException("Unable to enumerate pixel formats of window " + WindowsWGLGraphicsConfigurationFactory.toHexString(l) + " for GLCapabilitiesChooser");
                }
                gLCapabilitiesArray = new GLCapabilities[n2];
                for (int i = 0; i < n2; ++i) {
                    if (WGL.DescribePixelFormat(l, 1 + i, PIXELFORMATDESCRIPTOR.size(), (PIXELFORMATDESCRIPTOR)object) == 0) {
                        throw new GLException("Error describing pixel format " + (1 + i) + " of device context");
                    }
                    gLCapabilitiesArray[i] = WindowsWGLGraphicsConfiguration.PFD2GLCapabilities(gLProfile, (PIXELFORMATDESCRIPTOR)object, bl2, bl3);
                }
            }
            if (n <= 0) {
                if (null != capabilitiesChooser) {
                    try {
                        n = capabilitiesChooser.chooseCapabilities((Capabilities)gLCapabilities, gLCapabilitiesArray, n3) + 1;
                    }
                    catch (NativeWindowException nativeWindowException) {
                        if (DEBUG) {
                            nativeWindowException.printStackTrace();
                        }
                        n = -1;
                    }
                } else {
                    n = n3;
                }
                if (n <= 0) {
                    if (DEBUG) {
                        System.err.println("WindowsWGLGraphicsConfigurationFactory.updateGraphicsConfiguration .. unable to choose config, using first");
                    }
                    n = 1;
                } else if (n > n2) {
                    throw new GLException("Invalid result " + n + " from GLCapabilitiesChooser (should be between 1 and " + n2 + ")");
                }
            }
            var14_13 = gLCapabilitiesArray[n - 1];
            if (DEBUG) {
                System.err.println(WindowsWGLGraphicsConfigurationFactory.getThreadName() + ": Chosen pixel format (" + n + "):");
                System.err.println((Object)var14_13);
            }
            if (WGL.DescribePixelFormat(l, n, PIXELFORMATDESCRIPTOR.size(), (PIXELFORMATDESCRIPTOR)object) == 0) {
                throw new GLException("Error re-describing the chosen pixel format: " + WGL.GetLastError());
            }
        } else {
            object = WindowsWGLGraphicsConfiguration.GLCapabilities2PFD(gLCapabilities);
            n = WGL.ChoosePixelFormat(l, (PIXELFORMATDESCRIPTOR)object);
        }
        if (!bl4) {
            if (!WGL.SetPixelFormat(l, n, (PIXELFORMATDESCRIPTOR)object)) {
                long l2 = WGL.GetLastError();
                if (DEBUG) {
                    System.err.println(WindowsWGLGraphicsConfigurationFactory.getThreadName() + ": SetPixelFormat failed: current context = " + WGL.wglGetCurrentContext() + ", current DC = " + WGL.wglGetCurrentDC());
                    System.err.println(WindowsWGLGraphicsConfigurationFactory.getThreadName() + ": GetPixelFormat(hdc " + WindowsWGLGraphicsConfigurationFactory.toHexString(l) + ") returns " + WGL.GetPixelFormat(l));
                }
                throw new GLException("Unable to set pixel format " + n + " for device context " + WindowsWGLGraphicsConfigurationFactory.toHexString(l) + ": error code " + l2);
            }
            bl4 = true;
        }
        gLCapabilities = var14_13 != null ? var14_13 : WindowsWGLGraphicsConfiguration.PFD2GLCapabilities(gLProfile, (PIXELFORMATDESCRIPTOR)object, bl2, bl3);
        windowsWGLGraphicsConfiguration.setCapsPFD(gLCapabilities, (PIXELFORMATDESCRIPTOR)object, n, bl);
    }

    protected static String getThreadName() {
        return Thread.currentThread().getName();
    }

    public static String toHexString(long l) {
        return "0x" + Long.toHexString(l);
    }
}

