/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.impl.egl;

import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.opengl.impl.Debug;
import com.jogamp.opengl.impl.GLGraphicsConfigurationFactoryImpl;
import com.jogamp.opengl.impl.egl.EGL;
import com.jogamp.opengl.impl.egl.EGLGraphicsConfiguration;
import java.io.PrintStream;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.CapabilitiesChooser;
import javax.media.nativewindow.CapabilitiesImmutable;
import javax.media.nativewindow.DefaultGraphicsScreen;
import javax.media.nativewindow.GraphicsConfigurationFactory;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.egl.EGLGraphicsDevice;
import javax.media.opengl.DefaultGLCapabilitiesChooser;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;

public class EGLGraphicsConfigurationFactory
extends GLGraphicsConfigurationFactoryImpl {
    protected static final boolean DEBUG = GraphicsConfigurationFactory.DEBUG || Debug.debug("EGL");

    EGLGraphicsConfigurationFactory() {
        GraphicsConfigurationFactory.registerFactory((Class)EGLGraphicsDevice.class, (GraphicsConfigurationFactory)this);
    }

    protected AbstractGraphicsConfiguration chooseGraphicsConfigurationImpl(CapabilitiesImmutable capabilitiesImmutable, CapabilitiesImmutable capabilitiesImmutable2, CapabilitiesChooser capabilitiesChooser, AbstractGraphicsScreen abstractGraphicsScreen) {
        if (abstractGraphicsScreen == null) {
            throw new IllegalArgumentException("This NativeWindowFactory accepts only AbstractGraphicsDevice objects");
        }
        if (!(capabilitiesImmutable instanceof GLCapabilitiesImmutable)) {
            throw new IllegalArgumentException("This NativeWindowFactory accepts only GLCapabilities objects - chosen");
        }
        if (!(capabilitiesImmutable2 instanceof GLCapabilitiesImmutable)) {
            throw new IllegalArgumentException("This NativeWindowFactory accepts only GLCapabilities objects - requested");
        }
        if (capabilitiesChooser != null && !(capabilitiesChooser instanceof GLCapabilitiesChooser)) {
            throw new IllegalArgumentException("This NativeWindowFactory accepts only GLCapabilitiesChooser objects");
        }
        return EGLGraphicsConfigurationFactory.chooseGraphicsConfigurationStatic((GLCapabilitiesImmutable)capabilitiesImmutable, (GLCapabilitiesImmutable)capabilitiesImmutable2, (GLCapabilitiesChooser)capabilitiesChooser, abstractGraphicsScreen);
    }

    private static EGLGraphicsConfiguration chooseGraphicsConfigurationStatic(GLCapabilitiesImmutable object, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesChooser gLCapabilitiesChooser, AbstractGraphicsScreen abstractGraphicsScreen) {
        Cloneable cloneable;
        if (object == null) {
            object = new GLCapabilities(null);
        }
        GLProfile gLProfile = object.getGLProfile();
        if (null == abstractGraphicsScreen) {
            throw new GLException("Null AbstractGraphicsScreen");
        }
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsScreen.getDevice();
        if (null == abstractGraphicsDevice || !(abstractGraphicsDevice instanceof EGLGraphicsDevice)) {
            throw new GLException("GraphicsDevice must be a valid EGLGraphicsDevice");
        }
        long l = abstractGraphicsDevice.getHandle();
        if (l == 0L) {
            throw new GLException("Invalid EGL display: " + abstractGraphicsDevice);
        }
        if (!object.isOnscreen() && object.getDoubleBuffered()) {
            cloneable = (GLCapabilities)object.cloneMutable();
            ((GLCapabilities)cloneable).setDoubleBuffered(false);
            object = cloneable;
        }
        if (null != (cloneable = EGLGraphicsConfigurationFactory.eglChooseConfig(l, (GLCapabilitiesImmutable)object, gLCapabilitiesImmutable, gLCapabilitiesChooser, abstractGraphicsScreen))) {
            return cloneable;
        }
        if (DEBUG) {
            System.err.println("eglChooseConfig failed with given capabilities " + object);
        }
        if (gLCapabilitiesChooser == null) {
            gLCapabilitiesChooser = new DefaultGLCapabilitiesChooser();
        }
        PointerBuffer pointerBuffer = PointerBuffer.allocateDirect((int)10);
        int[] nArray = new int[1];
        if (!EGL.eglGetConfigs(l, pointerBuffer, pointerBuffer.capacity(), nArray, 0)) {
            throw new GLException("Graphics configuration fetch (eglGetConfigs) failed");
        }
        if (nArray[0] == 0) {
            throw new GLException("Graphics configuration fetch (eglGetConfigs) - no EGLConfig found");
        }
        CapabilitiesImmutable[] capabilitiesImmutableArray = EGLGraphicsConfigurationFactory.eglConfigs2GLCaps(gLProfile, l, pointerBuffer, nArray[0], object.isOnscreen(), object.isPBuffer());
        if (DEBUG) {
            System.err.println("EGL Get Configs: " + nArray[0] + ", Caps " + capabilitiesImmutableArray.length);
            EGLGraphicsConfigurationFactory.printCaps("eglGetConfigs", (GLCapabilitiesImmutable[])capabilitiesImmutableArray, System.err);
        }
        int n = -1;
        try {
            n = gLCapabilitiesChooser.chooseCapabilities((CapabilitiesImmutable)object, capabilitiesImmutableArray, -1);
        }
        catch (NativeWindowException nativeWindowException) {
            throw new GLException(nativeWindowException);
        }
        if (n < 0) {
            throw new GLException("Graphics configuration chooser failed");
        }
        if (DEBUG) {
            System.err.println("Chosen " + capabilitiesImmutableArray[n]);
        }
        if (null != (cloneable = EGLGraphicsConfigurationFactory.eglChooseConfig(l, (GLCapabilitiesImmutable)capabilitiesImmutableArray[n], gLCapabilitiesImmutable, gLCapabilitiesChooser, abstractGraphicsScreen))) {
            return cloneable;
        }
        if (DEBUG) {
            System.err.println("eglChooseConfig failed with eglGetConfig/choosen capabilities " + capabilitiesImmutableArray[n]);
        }
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setRedBits(8);
        gLCapabilities.setGreenBits(8);
        gLCapabilities.setBlueBits(8);
        gLCapabilities.setDepthBits(16);
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setNumSamples(4);
        if (DEBUG) {
            System.err.println("trying fixed caps (1): " + gLCapabilities);
        }
        if (null != (cloneable = EGLGraphicsConfigurationFactory.eglChooseConfig(l, gLCapabilities, gLCapabilitiesImmutable, gLCapabilitiesChooser, abstractGraphicsScreen))) {
            return cloneable;
        }
        gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setRedBits(5);
        gLCapabilities.setGreenBits(6);
        gLCapabilities.setBlueBits(5);
        gLCapabilities.setDepthBits(16);
        if (DEBUG) {
            System.err.println("trying fixed caps (2): " + gLCapabilities);
        }
        if (null != (cloneable = EGLGraphicsConfigurationFactory.eglChooseConfig(l, gLCapabilities, gLCapabilitiesImmutable, gLCapabilitiesChooser, abstractGraphicsScreen))) {
            return cloneable;
        }
        gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setRedBits(5);
        gLCapabilities.setGreenBits(6);
        gLCapabilities.setBlueBits(5);
        gLCapabilities.setDepthBits(16);
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setNumSamples(4);
        if (DEBUG) {
            System.err.println("trying fixed caps (3): " + gLCapabilities);
        }
        if (null != (cloneable = EGLGraphicsConfigurationFactory.eglChooseConfig(l, gLCapabilities, gLCapabilitiesImmutable, gLCapabilitiesChooser, abstractGraphicsScreen))) {
            return cloneable;
        }
        throw new GLException("Graphics configuration failed [direct caps, eglGetConfig/chooser and fixed-caps(1-3)]");
    }

    static EGLGraphicsConfiguration eglChooseConfig(long l, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesImmutable gLCapabilitiesImmutable2, GLCapabilitiesChooser gLCapabilitiesChooser, AbstractGraphicsScreen abstractGraphicsScreen) {
        GLProfile gLProfile = gLCapabilitiesImmutable.getGLProfile();
        int[] nArray = EGLGraphicsConfiguration.GLCapabilities2AttribList(gLCapabilitiesImmutable);
        PointerBuffer pointerBuffer = PointerBuffer.allocateDirect((int)1);
        int[] nArray2 = new int[1];
        if (!EGL.eglChooseConfig(l, nArray, 0, pointerBuffer, pointerBuffer.capacity(), nArray2, 0)) {
            throw new GLException("Graphics configuration selection (eglChooseConfig) failed for " + gLCapabilitiesImmutable);
        }
        if (nArray2[0] > 0) {
            Object[] objectArray;
            if (DEBUG) {
                objectArray = EGLGraphicsConfigurationFactory.eglConfigs2GLCaps(gLProfile, l, pointerBuffer, nArray2[0], gLCapabilitiesImmutable.isOnscreen(), gLCapabilitiesImmutable.isPBuffer());
                System.err.println("EGL Choose Configs: " + nArray2[0] + ", Caps " + objectArray.length);
                EGLGraphicsConfigurationFactory.printCaps("eglChooseConfig", (GLCapabilitiesImmutable[])objectArray, System.err);
            }
            objectArray = new int[1];
            if (!EGL.eglGetConfigAttrib(l, pointerBuffer.get(0), 12328, objectArray, 0)) {
                if (DEBUG) {
                    System.err.println("EGL couldn't retrieve ConfigID for already chosen eglConfig " + gLCapabilitiesImmutable + ", error 0x" + Integer.toHexString(EGL.eglGetError()));
                }
                return null;
            }
            GLCapabilitiesImmutable gLCapabilitiesImmutable3 = EGLGraphicsConfiguration.EGLConfig2Capabilities(gLProfile, l, pointerBuffer.get(0), true, gLCapabilitiesImmutable.isOnscreen(), gLCapabilitiesImmutable.isPBuffer());
            if (null != gLCapabilitiesImmutable3) {
                if (DEBUG) {
                    System.err.println("eglChooseConfig found: eglDisplay 0x" + Long.toHexString(l) + ", eglConfig ID 0x" + Integer.toHexString(objectArray[0]) + ", " + gLCapabilitiesImmutable + " -> " + gLCapabilitiesImmutable3);
                }
                return new EGLGraphicsConfiguration(abstractGraphicsScreen, gLCapabilitiesImmutable3, gLCapabilitiesImmutable2, gLCapabilitiesChooser, pointerBuffer.get(0), objectArray[0]);
            }
            if (DEBUG) {
                System.err.println("eglChooseConfig couldn't verify: eglDisplay 0x" + Long.toHexString(l) + ", eglConfig ID 0x" + Integer.toHexString(objectArray[0]) + ", for " + gLCapabilitiesImmutable);
            }
        } else if (DEBUG) {
            System.err.println("EGL Choose Configs: None using eglDisplay 0x" + Long.toHexString(l) + ", " + gLCapabilitiesImmutable);
        }
        return null;
    }

    static GLCapabilitiesImmutable[] eglConfigs2GLCaps(GLProfile gLProfile, long l, PointerBuffer pointerBuffer, int n, boolean bl, boolean bl2) {
        GLCapabilitiesImmutable[] gLCapabilitiesImmutableArray = new GLCapabilitiesImmutable[n];
        for (int i = 0; i < n; ++i) {
            gLCapabilitiesImmutableArray[i] = EGLGraphicsConfiguration.EGLConfig2Capabilities(gLProfile, l, pointerBuffer.get(i), true, bl, bl2);
        }
        return gLCapabilitiesImmutableArray;
    }

    static void printCaps(String string, GLCapabilitiesImmutable[] gLCapabilitiesImmutableArray, PrintStream printStream) {
        for (int i = 0; i < gLCapabilitiesImmutableArray.length; ++i) {
            printStream.println(string + "[" + i + "] " + gLCapabilitiesImmutableArray[i]);
        }
    }

    static EGLGraphicsConfiguration createOffscreenGraphicsConfiguration(AbstractGraphicsDevice abstractGraphicsDevice, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesImmutable gLCapabilitiesImmutable2, GLCapabilitiesChooser gLCapabilitiesChooser) {
        EGLGraphicsConfiguration eGLGraphicsConfiguration;
        GLCapabilities gLCapabilities;
        if (gLCapabilitiesImmutable.isOnscreen()) {
            throw new GLException("Error: Onscreen set: " + gLCapabilitiesImmutable);
        }
        if (gLCapabilitiesImmutable.getDoubleBuffered()) {
            gLCapabilities = (GLCapabilities)gLCapabilitiesImmutable.cloneMutable();
            gLCapabilities.setDoubleBuffered(false);
            gLCapabilitiesImmutable = gLCapabilities;
        }
        if (null == (eGLGraphicsConfiguration = EGLGraphicsConfigurationFactory.chooseGraphicsConfigurationStatic(gLCapabilitiesImmutable, gLCapabilitiesImmutable2, gLCapabilitiesChooser, (AbstractGraphicsScreen)(gLCapabilities = new DefaultGraphicsScreen(abstractGraphicsDevice, 0))))) {
            throw new GLException("Couldn't create EGLGraphicsConfiguration from " + gLCapabilities);
        }
        if (DEBUG) {
            System.err.println("Chosen eglConfig: " + eGLGraphicsConfiguration);
        }
        return eGLGraphicsConfiguration;
    }
}

