/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.impl.windows.wgl;

import com.jogamp.nativewindow.impl.windows.BITMAPINFO;
import com.jogamp.nativewindow.impl.windows.BITMAPINFOHEADER;
import com.jogamp.nativewindow.impl.windows.GDI;
import com.jogamp.opengl.impl.windows.wgl.WindowsBitmapWGLContext;
import com.jogamp.opengl.impl.windows.wgl.WindowsWGLDrawable;
import com.jogamp.opengl.impl.windows.wgl.WindowsWGLGraphicsConfiguration;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.SurfaceChangeable;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;

public class WindowsBitmapWGLDrawable
extends WindowsWGLDrawable {
    private long origbitmap;
    private long hbitmap;

    protected WindowsBitmapWGLDrawable(GLDrawableFactory gLDrawableFactory, NativeSurface nativeSurface) {
        super(gLDrawableFactory, nativeSurface, true);
        this.create();
    }

    protected void setRealizedImpl() {
        if (this.realized) {
            this.create();
        } else {
            this.destroyImpl();
        }
    }

    public GLContext createContext(GLContext gLContext) {
        return new WindowsBitmapWGLContext(this, gLContext);
    }

    private void create() {
        NativeSurface nativeSurface = this.getNativeSurface();
        WindowsWGLGraphicsConfiguration windowsWGLGraphicsConfiguration = (WindowsWGLGraphicsConfiguration)nativeSurface.getGraphicsConfiguration().getNativeGraphicsConfiguration();
        GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)windowsWGLGraphicsConfiguration.getRequestedCapabilities();
        int n = this.getWidth();
        int n2 = this.getHeight();
        BITMAPINFO bITMAPINFO = BITMAPINFO.create();
        BITMAPINFOHEADER bITMAPINFOHEADER = bITMAPINFO.getBmiHeader();
        int n3 = gLCapabilitiesImmutable.getRedBits() + gLCapabilitiesImmutable.getGreenBits() + gLCapabilitiesImmutable.getBlueBits() + gLCapabilitiesImmutable.getAlphaBits();
        bITMAPINFOHEADER.setBiSize(bITMAPINFOHEADER.size());
        bITMAPINFOHEADER.setBiWidth((long)n);
        bITMAPINFOHEADER.setBiHeight((long)(-1 * n2));
        bITMAPINFOHEADER.setBiPlanes((short)1);
        bITMAPINFOHEADER.setBiBitCount((short)n3);
        bITMAPINFOHEADER.setBiXPelsPerMeter(0L);
        bITMAPINFOHEADER.setBiYPelsPerMeter(0L);
        bITMAPINFOHEADER.setBiClrUsed(0);
        bITMAPINFOHEADER.setBiClrImportant(0);
        bITMAPINFOHEADER.setBiCompression(0);
        bITMAPINFOHEADER.setBiSizeImage(n * n2 * n3 / 8);
        long l = GDI.CreateCompatibleDC((long)0L);
        if (l == 0L) {
            System.out.println("LastError: " + GDI.GetLastError());
            throw new GLException("Error creating device context for offscreen OpenGL context");
        }
        ((SurfaceChangeable)nativeSurface).setSurfaceHandle(l);
        this.hbitmap = GDI.CreateDIBSection((long)l, (BITMAPINFO)bITMAPINFO, (int)0, null, (long)0L, (int)0);
        if (this.hbitmap == 0L) {
            GDI.DeleteDC((long)l);
            l = 0L;
            throw new GLException("Error creating offscreen bitmap of width " + n + ", height " + n2);
        }
        this.origbitmap = GDI.SelectObject((long)l, (long)this.hbitmap);
        if (this.origbitmap == 0L) {
            GDI.DeleteObject((long)this.hbitmap);
            this.hbitmap = 0L;
            GDI.DeleteDC((long)l);
            l = 0L;
            throw new GLException("Error selecting bitmap into new device context");
        }
        windowsWGLGraphicsConfiguration.updateGraphicsConfiguration(this.getFactory(), nativeSurface, null);
    }

    protected void destroyImpl() {
        NativeSurface nativeSurface = this.getNativeSurface();
        if (nativeSurface.getSurfaceHandle() != 0L) {
            GDI.SelectObject((long)nativeSurface.getSurfaceHandle(), (long)this.origbitmap);
            GDI.DeleteObject((long)this.hbitmap);
            GDI.DeleteDC((long)nativeSurface.getSurfaceHandle());
            this.origbitmap = 0L;
            this.hbitmap = 0L;
            ((SurfaceChangeable)nativeSurface).setSurfaceHandle(0L);
        }
    }

    protected void swapBuffersImpl() {
        if (DEBUG) {
            System.err.println("unhandled swapBuffersImpl() called for: " + this);
        }
    }
}

