/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.generate;

import ch.kuramo.javie.api.BlendMode;
import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.IAnimatableColor;
import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableEnum;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IAnimatableVec2d;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Resolution;
import ch.kuramo.javie.api.Vec2d;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.annotations.ShaderSource;
import ch.kuramo.javie.api.services.IArrayPools;
import ch.kuramo.javie.api.services.IBlendSupport;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.ITexture1DSupport;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import ch.kuramo.javie.effects.generate.GradientBase;
import com.google.inject.Inject;
import java.nio.FloatBuffer;
import java.util.HashSet;
import javax.media.opengl.GL2;
import javax.media.opengl.GLUniformData;

@Effect(id="ch.kuramo.javie.RadialGradient2", category="ch.kuramo.javie.api.effectCategory.generate")
public class RadialGradient2
extends GradientBase {
    @Property
    private IAnimatableVec2d center;
    @Property(value="0", min="0", max="4000")
    private IAnimatableDouble radiusA;
    @Property(value="100", min="0", max="4000")
    private IAnimatableDouble radiusB;
    @Property(value="1,1,1")
    private IAnimatableColor colorA;
    @Property(value="0,0,0")
    private IAnimatableColor colorB;
    @Property(value="RGB")
    private IAnimatableEnum<GradientBase.ColorSpace> colorSpace;
    @Property(value="CLAMP_TO_EDGE")
    private IAnimatableEnum<GradientBase.RepeatMode> repeatMode;
    @Property(value="100", min="0", max="100")
    private IAnimatableDouble opacity;
    @Property
    private IAnimatableEnum<BlendMode> blendMode;
    private final IVideoRenderSupport support;
    private final IShaderProgram program;
    @ShaderSource
    public static final String[] RADIAL_SAMPLER = new String[]{"uniform sampler1D texture;", "uniform vec2 center;", "uniform float innerRadius;", "uniform float radiusDiff;", "", "void main(void)", "{", "\tfloat d = distance(center, gl_FragCoord.st);", "\tgl_FragColor = texture1D(texture, (d-innerRadius)/radiusDiff);", "}"};

    @Inject
    public RadialGradient2(IVideoEffectContext context, IBlendSupport blendSupport, ITexture1DSupport tex1DSupport, IArrayPools arrayPools, IVideoRenderSupport support, IShaderRegistry shaders) {
        super(context, blendSupport, tex1DSupport, arrayPools);
        this.support = support;
        this.program = shaders.getProgram(RadialGradient2.class, "RADIAL_SAMPLER");
    }

    public IVideoBuffer doVideoEffect() {
        return this.doGradientEffect((BlendMode)this.context.value(this.blendMode), (Double)this.context.value((IAnimatableValue)this.opacity) / 100.0);
    }

    protected IVideoBuffer createGradient(final VideoBounds bounds) {
        IVideoBuffer iVideoBuffer;
        int texture;
        block14: {
            double radiusDiff;
            double innerRadius;
            Resolution resolution = this.context.getVideoResolution();
            Vec2d center = resolution.scale((Vec2d)this.context.value((IAnimatableValue)this.center));
            double radiusA = resolution.scale(((Double)this.context.value((IAnimatableValue)this.radiusA)).doubleValue());
            double radiusB = resolution.scale(((Double)this.context.value((IAnimatableValue)this.radiusB)).doubleValue());
            Color colorA = (Color)this.context.value((IAnimatableValue)this.colorA);
            Color colorB = (Color)this.context.value((IAnimatableValue)this.colorB);
            GradientBase.ColorSpace colorSpace = (GradientBase.ColorSpace)((Object)this.context.value(this.colorSpace));
            GradientBase.RepeatMode repeatMode = (GradientBase.RepeatMode)((Object)this.context.value(this.repeatMode));
            if (radiusA <= radiusB) {
                innerRadius = radiusA;
                radiusDiff = radiusB - radiusA;
            } else {
                innerRadius = radiusB;
                radiusDiff = radiusA - radiusB;
                Color tmp = colorA;
                colorA = colorB;
                colorB = tmp;
                switch (colorSpace) {
                    case HSL: {
                        colorSpace = GradientBase.ColorSpace.HSL_REVERSE_HUE;
                        break;
                    }
                    case HSL_REVERSE_HUE: {
                        colorSpace = GradientBase.ColorSpace.HSL;
                    }
                }
            }
            int texSize = Math.min(Math.max((int)Math.ceil(radiusDiff), 2), 4000);
            switch (colorSpace) {
                case RGB: {
                    texture = this.createRGBGradientTexture(colorA, colorB, texSize, repeatMode);
                    break;
                }
                case HSL: {
                    texture = this.createHSLGradientTexture(colorA, colorB, false, texSize, repeatMode);
                    break;
                }
                case HSL_REVERSE_HUE: {
                    texture = this.createHSLGradientTexture(colorA, colorB, true, texSize, repeatMode);
                    break;
                }
                default: {
                    throw new Error();
                }
            }
            IVideoBuffer gradient = null;
            try {
                HashSet<GLUniformData> uniforms = new HashSet<GLUniformData>();
                uniforms.add(new GLUniformData("texture", 0));
                uniforms.add(new GLUniformData("center", 2, FloatBuffer.wrap(new float[]{(float)(center.x - bounds.x), (float)(center.y - bounds.y)})));
                uniforms.add(new GLUniformData("innerRadius", (float)innerRadius));
                uniforms.add(new GLUniformData("radiusDiff", (float)radiusDiff));
                Runnable operation = new Runnable(){

                    public void run() {
                        GL2 gl = RadialGradient2.this.context.getGL().getGL2();
                        gl.glActiveTexture(33984);
                        gl.glBindTexture(3552, texture);
                        RadialGradient2.this.support.ortho2D(bounds);
                        RadialGradient2.this.support.quad2D(bounds, (double[][][])new double[0][][]);
                    }
                };
                gradient = this.context.createVideoBuffer(bounds);
                gradient.clear();
                this.support.useShaderProgram(this.program, uniforms, operation, 262144, gradient, new IVideoBuffer[0]);
                IVideoBuffer result = gradient;
                gradient = null;
                iVideoBuffer = result;
                if (gradient == null) break block14;
            }
            catch (Throwable throwable) {
                if (gradient != null) {
                    gradient.dispose();
                }
                this.deleteTextures(texture);
                throw throwable;
            }
            gradient.dispose();
        }
        this.deleteTextures(texture);
        return iVideoBuffer;
    }
}

