/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.noiseGrain;

import ch.kuramo.javie.api.BlendMode;
import ch.kuramo.javie.api.IAnimatableBoolean;
import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableEnum;
import ch.kuramo.javie.api.IAnimatableInteger;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IAnimatableVec2d;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Resolution;
import ch.kuramo.javie.api.Vec2d;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.annotations.ShaderSource;
import ch.kuramo.javie.api.services.IBlendSupport;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import ch.kuramo.javie.effects.noiseGrain.NoiseTexture;
import com.google.inject.Inject;
import java.nio.FloatBuffer;
import java.util.HashSet;
import javax.media.opengl.GL2;
import javax.media.opengl.GLUniformData;
import javax.vecmath.Matrix3d;

@Effect(id="ch.kuramo.javie.FractalNoise", category="ch.kuramo.javie.api.effectCategory.noiseGrain")
public class FractalNoise {
    @ShaderSource(program=false)
    public static final String noise = "noise.frag";
    @ShaderSource(attach={"noise"})
    public static final String[] FRACTAL_NOISE = new String[]{"uniform int fractalType;", "uniform float contrast;", "uniform float brightness;", "uniform int overflow;", "uniform int complexity;", "uniform float influences[20];", "uniform mat3 matrices[20];", "uniform float evolution;", "uniform float cycle;", "", "float noise(vec3 P);", "", "void main(void)", "{", "\tfloat sum = 0.0;", "\tvec3 pt = vec3(gl_FragCoord.st/128.0, 1.0);", "", "\tif (fractalType == 0) {", "\t\tif (cycle == 0.0) {", "\t\t\tfor (int i = 0; i < complexity; ++i) {", "\t\t\t\tsum += influences[i]*noise(vec3((matrices[i]*pt).xy, evolution));", "\t\t\t}", "\t\t} else {", "\t\t\tfor (int i = 0; i < complexity; ++i) {", "\t\t\t\tsum += influences[i]/cycle*(", "\t\t\t\t\t\t(cycle-evolution)*noise(vec3((matrices[i]*pt).xy, evolution))", "\t\t\t\t\t  + evolution*noise(vec3((matrices[i]*pt).xy, evolution-cycle)));", "\t\t\t}", "\t\t}", "\t\tsum *= 2.0;", "\t} else if (fractalType == 1) {", "\t\tif (cycle == 0.0) {", "\t\t\tfor (int i = 0; i < complexity; ++i) {", "\t\t\t\tsum += influences[i]*abs(noise(vec3((matrices[i]*pt).xy, evolution)));", "\t\t\t}", "\t\t} else {", "\t\t\tfor (int i = 0; i < complexity; ++i) {", "\t\t\t\tsum += influences[i]/cycle*(", "\t\t\t\t\t\t(cycle-evolution)*abs(noise(vec3((matrices[i]*pt).xy, evolution)))", "\t\t\t\t\t  + evolution*abs(noise(vec3((matrices[i]*pt).xy, evolution-cycle))));", "\t\t\t}", "\t\t}", "\t\tsum = sum * 2.0 - 1.0;", "\t}", "", "\tfloat t = sum * contrast + brightness;", "", "\tif (overflow == 0) {", "\t\tt = clamp(0.5+0.5*t, 0.0, 1.0);", "\t} else if (overflow == 1) {", "\t\tt = 0.5+0.3183099*atan(t);", "\t} else if (overflow == 2) {", "\t\tt = abs(0.5+0.5*t);", "\t\tt = 1.0 - abs(t - 2.0*float(int(t*0.5)) - 1.0);", "\t} else {", "\t\tt = 0.5+0.5*t;", "\t}", "\t", "\tgl_FragColor = vec4(t, t, t, 1.0);", "}"};
    @Property
    private IAnimatableEnum<FractalType> fractalType;
    @Property
    private IAnimatableBoolean invert;
    @Property(value="100", min="0", max="10000")
    private IAnimatableDouble contrast;
    @Property(value="0", min="-10000", max="10000")
    private IAnimatableDouble brightness;
    @Property(value="HDR")
    private IAnimatableEnum<Overflow> overflow;
    @Property
    private IAnimatableDouble rotation;
    @Property(value="100", min="1", max="10000")
    private IAnimatableVec2d scale;
    @Property
    private IAnimatableVec2d offset;
    @Property(value="6", min="1", max="20")
    private IAnimatableDouble complexity;
    @Property(value="70", min="0", max="10000")
    private IAnimatableDouble subInfluence;
    @Property(value="56", min="10", max="10000")
    private IAnimatableDouble subScale;
    @Property
    private IAnimatableDouble subRotation;
    @Property
    private IAnimatableVec2d subOffset;
    @Property
    private IAnimatableBoolean centerSubscale;
    @Property
    private IAnimatableDouble evolution;
    @Property(value="0", min="0", max="100")
    private IAnimatableInteger cycle;
    @Property(value="0", min="0", max="100000")
    private IAnimatableInteger randomSeed;
    @Property(value="100", min="0", max="100")
    private IAnimatableDouble opacity;
    @Property(value="NORMAL")
    private IAnimatableEnum<BlendMode> blendMode;
    private final IVideoEffectContext context;
    private final IVideoRenderSupport support;
    private final IShaderProgram program;
    private final IBlendSupport blendSupport;
    @ShaderSource(program=false)
    public static final String[] hsl2rgb = new String[]{"float hue2rgb(float t1, float t2, float hue)", "{", "\tif (hue < 0.0) hue += 1.0;", "\telse if (hue > 1.0) hue -= 1.0;", "", "\treturn (hue*6.0 < 1.0) ? t1 + (t2-t1)*6.0*hue :", "\t\t   (hue*2.0 < 1.0) ? t2 :", "\t\t   (hue*3.0 < 2.0) ? t1 + (t2-t1)*(2.0/3.0-hue)*6.0 :", "\t\t                     t1;", "}", "", "vec3 hsl2rgb(vec3 hsl)", "{", "\tfloat hue = hsl.x;", "\tfloat sat = hsl.y;", "\tfloat luma = hsl.z;", "\tvec3 rgb;", "", "\tif (sat == 0.0) {", "\t\trgb = vec3(luma);", "\t} else {", "\t\tfloat t2 = (luma < 0.5) ? luma*(1.0+sat) : luma+sat-luma*sat;", "\t\tfloat t1 = luma*2.0 - t2;", "", "\t\trgb = vec3(", "\t\t\t\thue2rgb(t1, t2, hue+1.0/3.0),", "\t\t\t\thue2rgb(t1, t2, hue),", "\t\t\t\thue2rgb(t1, t2, hue-1.0/3.0));", "\t}", "\treturn rgb;", "}"};
    @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions", "hsl2rgb"})
    public static final String[] HUE = FractalNoise.createHueOrSaturationBlendSource(true);
    @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
    public static final String[] SATURATION = FractalNoise.createHueOrSaturationBlendSource(false);

    @Inject
    public FractalNoise(IVideoEffectContext context, IVideoRenderSupport support, IShaderRegistry shaders, IBlendSupport blendSupport) {
        this.context = context;
        this.support = support;
        this.program = shaders.getProgram(FractalNoise.class, "FRACTAL_NOISE");
        this.blendSupport = blendSupport;
        blendSupport.replace(BlendMode.HUE, shaders.getProgram(FractalNoise.class, "HUE"));
        blendSupport.replace(BlendMode.SATURATION, shaders.getProgram(FractalNoise.class, "SATURATION"));
    }

    public IVideoBuffer doVideoEffect() {
        IVideoBuffer original;
        VideoBounds bounds;
        boolean noBlend;
        BlendMode blendMode = (BlendMode)this.context.value(this.blendMode);
        double opacity = (Double)this.context.value((IAnimatableValue)this.opacity) / 100.0;
        boolean bl = noBlend = (blendMode == BlendMode.NONE || blendMode == BlendMode.NORMAL) && opacity == 1.0;
        if (noBlend) {
            bounds = this.context.getPreviousBounds();
            original = this.context.createVideoBuffer(bounds);
        } else {
            original = this.context.doPreviousEffect();
            bounds = original.getBounds();
        }
        if (bounds.isEmpty()) {
            return original;
        }
        IVideoBuffer fractal = null;
        try {
            if (noBlend) {
                IVideoBuffer iVideoBuffer = this.doFractalNoise(bounds);
                return iVideoBuffer;
            }
            fractal = this.doFractalNoise(bounds);
            IVideoBuffer iVideoBuffer = this.blendSupport.blend(fractal, original, null, blendMode, opacity, this.context);
            return iVideoBuffer;
        }
        finally {
            if (original != null) {
                original.dispose();
            }
            if (fractal != null) {
                fractal.dispose();
            }
        }
    }

    private IVideoBuffer doFractalNoise(VideoBounds bounds) {
        Resolution resolution = this.context.getVideoResolution();
        FractalType fractalType = (FractalType)((Object)this.context.value(this.fractalType));
        boolean invert = (Boolean)this.context.value((IAnimatableValue)this.invert);
        double contrast = (Double)this.context.value((IAnimatableValue)this.contrast) / (double)(invert ? -100 : 100);
        double brightness = (Double)this.context.value((IAnimatableValue)this.brightness) / 100.0;
        Overflow overflow = (Overflow)((Object)this.context.value(this.overflow));
        double rotation = Math.toRadians((Double)this.context.value((IAnimatableValue)this.rotation));
        Vec2d scale = resolution.scale((Vec2d)this.context.value((IAnimatableValue)this.scale));
        Vec2d offset = resolution.scale((Vec2d)this.context.value((IAnimatableValue)this.offset));
        double complexity = (Double)this.context.value((IAnimatableValue)this.complexity);
        double subInfluence = (Double)this.context.value((IAnimatableValue)this.subInfluence) / 100.0;
        double subScale = (Double)this.context.value((IAnimatableValue)this.subScale);
        double subRotation = Math.toRadians((Double)this.context.value((IAnimatableValue)this.subRotation));
        Vec2d subOffset = (Vec2d)this.context.value((IAnimatableValue)this.subOffset);
        boolean centerSubscale = (Boolean)this.context.value((IAnimatableValue)this.centerSubscale);
        double evolution = (Double)this.context.value((IAnimatableValue)this.evolution);
        int cycle = (Integer)this.context.value((IAnimatableValue)this.cycle);
        int randomSeed = (Integer)this.context.value((IAnimatableValue)this.randomSeed);
        offset = new Vec2d(offset.x - bounds.x, offset.y - bounds.y);
        evolution += (double)(randomSeed * 367);
        evolution /= 180.0;
        if (cycle != 0 && (evolution %= (double)(cycle *= 2)) < 0.0) {
            evolution += (double)cycle;
        }
        double cosRot = Math.cos(rotation);
        double sinRot = Math.sin(rotation);
        Matrix3d transformMat = new Matrix3d(100.0 / scale.x, 0.0, 0.0, 0.0, 100.0 / scale.y, 0.0, 0.0, 0.0, 1.0);
        transformMat.mul(new Matrix3d(cosRot, sinRot, 0.0, -sinRot, cosRot, 0.0, 0.0, 0.0, 1.0));
        transformMat.mul(new Matrix3d(1.0, 0.0, -offset.x / 128.0, 0.0, 1.0, -offset.y / 128.0, 0.0, 0.0, 1.0));
        double cosSubRot = Math.cos(subRotation);
        double sinSubRot = Math.sin(subRotation);
        Matrix3d subScaleMat1 = new Matrix3d(100.0 / subScale, 0.0, 0.0, 0.0, 100.0 / subScale, 0.0, 0.0, 0.0, 1.0);
        Matrix3d subRotMat1 = new Matrix3d(cosSubRot, sinSubRot, 0.0, -sinSubRot, cosSubRot, 0.0, 0.0, 0.0, 1.0);
        Matrix3d subOffsetMat1 = new Matrix3d(1.0, 0.0, -subOffset.x / 128.0, 0.0, 1.0, -subOffset.y / 128.0, 0.0, 0.0, 1.0);
        Matrix3d subScaleMat = new Matrix3d();
        subScaleMat.setIdentity();
        Matrix3d subRotMat = new Matrix3d();
        subRotMat.setIdentity();
        Matrix3d subOffsetMat = new Matrix3d();
        if (centerSubscale) {
            subOffsetMat.set(subOffsetMat1);
        } else {
            subOffsetMat.setIdentity();
        }
        int ceiledComplexity = (int)Math.ceil(complexity);
        float[] influences = new float[ceiledComplexity];
        float infTotal = 0.0f;
        float[] matrices = new float[9 * ceiledComplexity];
        int i = 0;
        while (i < ceiledComplexity) {
            influences[i] = (float)Math.pow(subInfluence, i);
            if ((double)(i + 1) > complexity) {
                int n = i;
                influences[n] = (float)((double)influences[n] * (complexity - (double)i));
            }
            infTotal += influences[i];
            Matrix3d mat = new Matrix3d(subOffsetMat);
            mat.mul(subScaleMat);
            mat.mul(subRotMat);
            mat.mul(transformMat);
            int j = 0;
            while (j < 9) {
                matrices[i * 9 + j] = (float)mat.getElement(j % 3, j / 3);
                ++j;
            }
            subScaleMat.mul(subScaleMat1);
            subRotMat.mul(subRotMat1);
            if (!centerSubscale) {
                subOffsetMat.mul(new Matrix3d(1.0, 0.0, 179.0, 0.0, 1.0, 179.0, 0.0, 0.0, 1.0));
                subOffsetMat.mul(subOffsetMat1);
            }
            ++i;
        }
        i = 0;
        while (i < ceiledComplexity) {
            int n = i++;
            influences[n] = influences[n] / infTotal;
        }
        HashSet<GLUniformData> uniforms = new HashSet<GLUniformData>();
        uniforms.add(new GLUniformData("permTexture", 0));
        uniforms.add(new GLUniformData("fractalType", fractalType.ordinal()));
        uniforms.add(new GLUniformData("contrast", (float)contrast));
        uniforms.add(new GLUniformData("brightness", (float)brightness));
        uniforms.add(new GLUniformData("overflow", overflow.ordinal()));
        uniforms.add(new GLUniformData("complexity", ceiledComplexity));
        uniforms.add(new GLUniformData("influences[0]", 1, FloatBuffer.wrap(influences)));
        uniforms.add(new GLUniformData("matrices[0]", 3, 3, FloatBuffer.wrap(matrices)));
        uniforms.add(new GLUniformData("evolution", (float)evolution));
        uniforms.add(new GLUniformData("cycle", (float)cycle));
        IVideoBuffer buffer = null;
        try {
            final IVideoBuffer output = buffer = this.context.createVideoBuffer(bounds);
            Runnable operation = new Runnable(){

                public void run() {
                    GL2 gl = FractalNoise.this.context.getGL().getGL2();
                    int permTexture = NoiseTexture.getPermTexture(gl);
                    gl.glActiveTexture(33984);
                    gl.glBindTexture(3553, permTexture);
                    FractalNoise.this.support.ortho2D(output);
                    FractalNoise.this.support.quad2D(output, new IVideoBuffer[0]);
                }
            };
            this.support.useShaderProgram(this.program, uniforms, operation, 262144, output, new IVideoBuffer[0]);
            buffer = null;
            IVideoBuffer iVideoBuffer = output;
            return iVideoBuffer;
        }
        finally {
            if (buffer != null) {
                buffer.dispose();
            }
        }
    }

    private static String[] createHueOrSaturationBlendSource(boolean hue) {
        return new String[]{"uniform sampler2D texDst;", "uniform sampler2D texSrc;", "uniform float opacity;", "", "const vec3 lumaVec = vec3(0.299, 0.587, 0.114);", "", hue ? "vec3 hsl2rgb(vec3 hsl);" : "", hue ? "float sat(vec3 color);" : "", "vec3 set_sat(vec3 color, float s);", "vec3 set_lum(vec3 color, float l);", "", "void main(void)", "{", "\tvec2 texCoord = gl_TexCoord[0].st;", "\tvec4 pDst = texture2D(texDst, texCoord);", "\tvec4 pSrc = texture2D(texSrc, texCoord);", "", "\tfloat da = pDst.a;", "\tfloat sa = pSrc.a*opacity;", "\tfloat csa = 1.0 - sa;", "\tfloat a = sa + da*csa;", "", "\tvec3 pDst3 = pDst.rgb;", "\tvec3 uDst3 = (pDst.a != 0.0) ? pDst.rgb/pDst.a : vec3(0.0);", "", hue ? "\tvec3 newDst3 = set_lum(set_sat(hsl2rgb(vec3(pSrc.r, 1.0, 0.5)), sat(uDst3)), dot(uDst3, lumaVec));" : "\tvec3 newDst3 = set_lum(set_sat(uDst3, pSrc.r), dot(uDst3, lumaVec));", "", "\tgl_FragColor = vec4(newDst3*da*sa + pDst3*csa, a);", "}"};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FractalType {
        BASIC,
        TURBULENT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Overflow {
        CLIP,
        SOFT_CLAMP,
        WRAP_BACK,
        HDR;

    }
}

