/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.ui.viewers;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUI;
import org.eclipse.equinox.internal.provisional.p2.ui.actions.InstallAction;
import org.eclipse.equinox.internal.provisional.p2.ui.model.InstalledIUElement;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.Policy;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;

public class InstallIUDropAdapter
extends ViewerDropAdapter {
    static boolean DEBUG = false;
    Policy policy;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public InstallIUDropAdapter(Policy policy, StructuredViewer viewer) {
        super((Viewer)viewer);
        this.policy = policy;
    }

    IStatus error(String message) {
        return this.error(message, null);
    }

    IStatus error(String message, Throwable exception) {
        return new Status(4, "org.eclipse.equinox.p2.ui", 0, message, exception);
    }

    private String getProfileTarget(Object mouseTarget) {
        IProfile profile;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.engine.IProfile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((profile = (IProfile)ProvUI.getAdapter(mouseTarget, clazz)) != null) {
            return profile.getProfileId();
        }
        if (mouseTarget instanceof InstalledIUElement) {
            return ((InstalledIUElement)mouseTarget).getProfileId();
        }
        return null;
    }

    private IStatus ok() {
        return new Status(0, "org.eclipse.equinox.p2.ui", 0, null, null);
    }

    public boolean performDrop(Object data) {
        if (DEBUG) {
            System.out.println("Perform drop on target: " + this.getCurrentTarget() + " with data: " + data);
        }
        if (this.getCurrentTarget() == null || data == null) {
            return false;
        }
        ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
        if (!(selection instanceof IStructuredSelection) || selection.isEmpty()) {
            return false;
        }
        String profileId = this.getProfileTarget(this.getCurrentTarget());
        if (this.getCurrentOperation() == 1 && profileId != null) {
            final IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            ISelectionProvider selectionProvider = new ISelectionProvider(){

                public void addSelectionChangedListener(ISelectionChangedListener listener) {
                }

                public ISelection getSelection() {
                    if (DEBUG) {
                        System.out.println("Selection was queried by action");
                        System.out.println(structuredSelection.toString());
                    }
                    return structuredSelection;
                }

                public void removeSelectionChangedListener(ISelectionChangedListener listener) {
                }

                public void setSelection(ISelection sel) {
                    throw new UnsupportedOperationException("This ISelectionProvider is static, and cannot be modified.");
                }
            };
            InstallAction action = new InstallAction(this.policy, selectionProvider, profileId);
            if (DEBUG) {
                System.out.println("Running install action");
            }
            action.run();
            return true;
        }
        return false;
    }

    public boolean validateDrop(Object target, int dragOperation, TransferData transferType) {
        if (LocalSelectionTransfer.getTransfer().isSupportedType(transferType)) {
            IStatus status = this.validateTarget(target, transferType);
            if (DEBUG) {
                System.out.println("Validate target: " + status);
            }
            return status.isOK();
        }
        return false;
    }

    public void dragEnter(DropTargetEvent event) {
        event.detail = 1;
        super.dragEnter(event);
    }

    private IStatus validateTarget(Object target, TransferData transferType) {
        if (LocalSelectionTransfer.getTransfer().isSupportedType(transferType)) {
            IInstallableUnit[] ius = this.getSelectedIUs();
            if (ius.length == 0) {
                return this.error(ProvUIMessages.ProvDropAdapter_NoIUsToDrop);
            }
            if (this.getProfileTarget(target) != null) {
                return this.ok();
            }
            return this.error(ProvUIMessages.ProvDropAdapter_InvalidDropTarget);
        }
        return this.error(ProvUIMessages.ProvDropAdapter_UnsupportedDropOperation);
    }

    private IInstallableUnit[] getSelectedIUs() {
        ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
        ArrayList<IInstallableUnit> ius = new ArrayList<IInstallableUnit>();
        if (!(selection instanceof IStructuredSelection) || selection.isEmpty()) {
            return null;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        Iterator iter = structuredSelection.iterator();
        while (iter.hasNext()) {
            IInstallableUnit iu;
            Object e = iter.next();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iu = (IInstallableUnit)ProvUI.getAdapter(e, clazz)) == null) continue;
            ius.add(iu);
        }
        return ius.toArray(new IInstallableUnit[ius.size()]);
    }
}

