/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal;

import ch.kuramo.javie.api.AudioMode;
import ch.kuramo.javie.api.BlendMode;
import ch.kuramo.javie.api.ColorMode;
import ch.kuramo.javie.api.IAudioBuffer;
import ch.kuramo.javie.api.IObjectArray;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Quality;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.api.Vec2d;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.services.IAccumulationSupport;
import ch.kuramo.javie.api.services.IArrayPools;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import ch.kuramo.javie.core.AbstractAnimatableEnum;
import ch.kuramo.javie.core.AbstractTransformableLayer;
import ch.kuramo.javie.core.AnimatableDouble;
import ch.kuramo.javie.core.AnimatableInteger;
import ch.kuramo.javie.core.AnimatableVec2d;
import ch.kuramo.javie.core.CastsShadows;
import ch.kuramo.javie.core.CoreContext;
import ch.kuramo.javie.core.Effect;
import ch.kuramo.javie.core.ExpressionScope;
import ch.kuramo.javie.core.FrameBlend;
import ch.kuramo.javie.core.Keyframe;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.LayerNature;
import ch.kuramo.javie.core.MediaInput;
import ch.kuramo.javie.core.MediaLayer;
import ch.kuramo.javie.core.MotionBlur;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.ProjectDecodeException;
import ch.kuramo.javie.core.TrackMatte;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.VectorMediaInput;
import ch.kuramo.javie.core.VideoLayerRenderer;
import ch.kuramo.javie.core.WrappedOperation;
import ch.kuramo.javie.core.internal.LayerMatrixUtil;
import ch.kuramo.javie.core.services.AudioEffectPipeline;
import ch.kuramo.javie.core.services.AudioRenderSupport;
import ch.kuramo.javie.core.services.RenderContext;
import ch.kuramo.javie.core.services.VideoEffectPipeline;
import ch.kuramo.javie.core.services.VideoRenderSupport;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.arnx.jsonic.JSONHint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMediaLayer
extends AbstractTransformableLayer
implements MediaLayer {
    private boolean _effectsEnabled = true;
    private List<Effect> _effects = Util.newList();
    private Quality _quality = Quality.NORMAL;
    private MotionBlur _motionBlur = MotionBlur.NONE;
    private TrackMatte _trackMatte = TrackMatte.NONE;
    private AnimatableDouble _opacity = new AnimatableDouble((Double)100.0, 0.0, 100.0);
    private BlendMode _blendMode = BlendMode.NORMAL;
    private AnimatableVec2d _audioLevels = new AnimatableVec2d(Vec2d.ZERO, new Vec2d(-48.0, -48.0), new Vec2d(48.0, 48.0));
    private AnimatableDouble _timeRemap = new AnimatableDouble(0.0);
    private CastsShadows _castsShadows = CastsShadows.OFF;
    private AnimatableInteger _shadowExpansionLeft = new AnimatableInteger((Integer)0, 0, 1000);
    private AnimatableInteger _shadowExpansionTop = new AnimatableInteger((Integer)0, 0, 1000);
    private AnimatableInteger _shadowExpansionRight = new AnimatableInteger((Integer)0, 0, 1000);
    private AnimatableInteger _shadowExpansionBottom = new AnimatableInteger((Integer)0, 0, 1000);
    private AnimatableDouble _lightTransmission = new AnimatableDouble((Double)0.0, 0.0, 100.0);
    private boolean _acceptsShadows = true;
    private boolean _acceptsLights = true;
    private AnimatableDouble _ambient = new AnimatableDouble((Double)100.0, 0.0, 100.0);
    private AnimatableDouble _diffuse = new AnimatableDouble((Double)50.0, 0.0, 100.0);
    private AnimatableDouble _specular = new AnimatableDouble((Double)50.0, 0.0, 100.0);
    private AnimatableDouble _shininess = new AnimatableDouble((Double)5.0, 0.0, 100.0);
    private AnimatableDouble _metal = new AnimatableDouble((Double)100.0, 0.0, 100.0);
    @Inject
    private RenderContext _context;
    @Inject
    private IVideoRenderSupport _support;
    @Inject
    private VideoRenderSupport _oldSupport;
    @Inject
    private VideoEffectPipeline _vePipeline;
    @Inject
    private IAccumulationSupport _accumSuport;
    @Inject
    private AudioRenderSupport _arSupport;
    @Inject
    private AudioEffectPipeline _aePipeline;
    @Inject
    private IArrayPools _arrayPools;

    @Override
    @JSONHint(ignore=true)
    public boolean isVideoNature() {
        return this.getMediaInput().isVideoAvailable();
    }

    @Override
    @JSONHint(ignore=true)
    public boolean isAudioNature() {
        return this.getMediaInput().isAudioAvailable();
    }

    @Override
    public boolean isEffectsEnabled() {
        return this._effectsEnabled;
    }

    @Override
    public void setEffectsEnabled(boolean effectsEnabled) {
        this._effectsEnabled = effectsEnabled;
    }

    @Override
    public List<Effect> getEffects() {
        return this._effects;
    }

    public void setEffects(List<Effect> effects) {
        this._effects = effects;
    }

    @Override
    public Quality getQuality() {
        return this._quality;
    }

    @Override
    public void setQuality(Quality quality) {
        this._quality = quality;
    }

    @Override
    public MotionBlur getMotionBlur() {
        return this._motionBlur;
    }

    @Override
    public void setMotionBlur(MotionBlur motionBlur) {
        this._motionBlur = motionBlur;
    }

    @Override
    public TrackMatte getTrackMatte() {
        return this._trackMatte;
    }

    @Override
    public void setTrackMatte(TrackMatte trackMatte) {
        this._trackMatte = trackMatte;
    }

    @Override
    public AnimatableDouble getOpacity() {
        return this._opacity;
    }

    public void setOpacity(AnimatableDouble opacity) {
        opacity.copyConfigurationFrom(this._opacity);
        this._opacity = opacity;
    }

    @Override
    public BlendMode getBlendMode() {
        return this._blendMode;
    }

    @Override
    public void setBlendMode(BlendMode blendMode) {
        this._blendMode = blendMode;
    }

    @Override
    public AnimatableVec2d getAudioLevels() {
        return this._audioLevels;
    }

    public void setAudioLevels(AnimatableVec2d audioLevels) {
        audioLevels.copyConfigurationFrom(this._audioLevels);
        this._audioLevels = audioLevels;
    }

    @Override
    public AnimatableDouble getTimeRemap() {
        return this._timeRemap;
    }

    public void setTimeRemap(AnimatableDouble timeRemap) {
        timeRemap.copyConfigurationFrom(this._timeRemap);
        this._timeRemap = timeRemap;
    }

    @Override
    public CastsShadows getCastsShadows() {
        return this._castsShadows;
    }

    @Override
    public void setCastsShadows(CastsShadows castsShadows) {
        this._castsShadows = castsShadows;
    }

    @Override
    public AnimatableInteger getShadowExpansionLeft() {
        return this._shadowExpansionLeft;
    }

    public void setShadowExpansionLeft(AnimatableInteger shadowExpansionLeft) {
        shadowExpansionLeft.copyConfigurationFrom(this._shadowExpansionLeft);
        this._shadowExpansionLeft = shadowExpansionLeft;
    }

    @Override
    public AnimatableInteger getShadowExpansionTop() {
        return this._shadowExpansionTop;
    }

    public void setShadowExpansionTop(AnimatableInteger shadowExpansionTop) {
        shadowExpansionTop.copyConfigurationFrom(this._shadowExpansionTop);
        this._shadowExpansionTop = shadowExpansionTop;
    }

    @Override
    public AnimatableInteger getShadowExpansionRight() {
        return this._shadowExpansionRight;
    }

    public void setShadowExpansionRight(AnimatableInteger shadowExpansionRight) {
        shadowExpansionRight.copyConfigurationFrom(this._shadowExpansionRight);
        this._shadowExpansionRight = shadowExpansionRight;
    }

    @Override
    public AnimatableInteger getShadowExpansionBottom() {
        return this._shadowExpansionBottom;
    }

    public void setShadowExpansionBottom(AnimatableInteger shadowExpansionBottom) {
        shadowExpansionBottom.copyConfigurationFrom(this._shadowExpansionBottom);
        this._shadowExpansionBottom = shadowExpansionBottom;
    }

    @Override
    public AnimatableDouble getLightTransmission() {
        return this._lightTransmission;
    }

    public void setLightTransmission(AnimatableDouble lightTransmission) {
        lightTransmission.copyConfigurationFrom(this._lightTransmission);
        this._lightTransmission = lightTransmission;
    }

    @Override
    public boolean isAcceptsShadows() {
        return this._acceptsShadows;
    }

    @Override
    public void setAcceptsShadows(boolean acceptsShadows) {
        this._acceptsShadows = acceptsShadows;
    }

    @Override
    public boolean isAcceptsLights() {
        return this._acceptsLights;
    }

    @Override
    public void setAcceptsLights(boolean acceptsLights) {
        this._acceptsLights = acceptsLights;
    }

    @Override
    public AnimatableDouble getAmbient() {
        return this._ambient;
    }

    public void setAmbient(AnimatableDouble ambient) {
        ambient.copyConfigurationFrom(this._ambient);
        this._ambient = ambient;
    }

    @Override
    public AnimatableDouble getDiffuse() {
        return this._diffuse;
    }

    public void setDiffuse(AnimatableDouble diffuse) {
        diffuse.copyConfigurationFrom(this._diffuse);
        this._diffuse = diffuse;
    }

    @Override
    public AnimatableDouble getSpecular() {
        return this._specular;
    }

    public void setSpecular(AnimatableDouble specular) {
        specular.copyConfigurationFrom(this._specular);
        this._specular = specular;
    }

    @Override
    public AnimatableDouble getShininess() {
        return this._shininess;
    }

    public void setShininess(AnimatableDouble shininess) {
        shininess.copyConfigurationFrom(this._shininess);
        this._shininess = shininess;
    }

    @Override
    public AnimatableDouble getMetal() {
        return this._metal;
    }

    public void setMetal(AnimatableDouble metal) {
        metal.copyConfigurationFrom(this._metal);
        this._metal = metal;
    }

    @Override
    public boolean isVectorLayer() {
        return this.getMediaInput() instanceof VectorMediaInput;
    }

    @Override
    public void prepareExpression(ExpressionScope scope) {
        super.prepareExpression(scope);
        scope.assignTo(this._opacity);
        scope.assignTo(this._audioLevels);
        scope.assignTo(this._timeRemap);
        scope.assignTo(this._shadowExpansionLeft);
        scope.assignTo(this._shadowExpansionTop);
        scope.assignTo(this._shadowExpansionRight);
        scope.assignTo(this._shadowExpansionBottom);
        scope.assignTo(this._lightTransmission);
        scope.assignTo(this._ambient);
        scope.assignTo(this._diffuse);
        scope.assignTo(this._specular);
        scope.assignTo(this._shininess);
        scope.assignTo(this._metal);
        for (Effect effect : this._effects) {
            effect.prepareExpression(scope.clone());
        }
    }

    @Override
    public VideoLayerRenderer.GeneralLayerRenderer createVideoRenderer() {
        MediaInput input = this.getMediaInput();
        if (input == null || !input.isVideoAvailable()) {
            return null;
        }
        if (this.isVectorLayer() && LayerNature.isCTCR(this)) {
            return this.createCRLayerRenderer();
        }
        return this.createNormalLayerRenderer();
    }

    private VideoLayerRenderer.NormalLayerRenderer createNormalLayerRenderer() {
        return new VideoLayerRenderer.AbstractNormalLayerRenderer(){
            private final WrappedOperation<VideoBounds> inputBoundsOperation = new WrappedOperation<VideoBounds>(){

                @Override
                public VideoBounds execute() {
                    return AbstractMediaLayer.this._context.getVideoResolution().scale(AbstractMediaLayer.this.getMediaInput().getVideoFrameBounds());
                }
            };

            @Override
            public MediaLayer getLayer() {
                return AbstractMediaLayer.this;
            }

            @Override
            public double getOpacity() {
                return (Double)AbstractMediaLayer.this._opacity.value(AbstractMediaLayer.this._context) / 100.0;
            }

            @Override
            public void multModelViewMatrix(double[] mvMatrix) {
                AbstractMediaLayer.this._oldSupport.setMatrix(null, mvMatrix);
                LayerMatrixUtil.multModelViewMatrix(AbstractMediaLayer.this, AbstractMediaLayer.this._context, AbstractMediaLayer.this._oldSupport);
                AbstractMediaLayer.this._oldSupport.getMatrix(null, mvMatrix);
            }

            @Override
            public VideoBounds calcBounds(boolean withEffects) {
                return AbstractMediaLayer.this._vePipeline.getVideoBounds(AbstractMediaLayer.this, this.getEffects(withEffects), this.inputBoundsOperation);
            }

            @Override
            public IVideoBuffer render(boolean withEffects, boolean frameBlendEnabled) {
                return AbstractMediaLayer.this._vePipeline.doVideoEffects(AbstractMediaLayer.this, this.getEffects(withEffects), this.inputBoundsOperation, this.createInputBufferOperation(frameBlendEnabled));
            }

            private List<Effect> getEffects(boolean withEffects) {
                return withEffects && AbstractMediaLayer.this._effectsEnabled ? AbstractMediaLayer.this._effects : Collections.emptyList();
            }

            private WrappedOperation<IVideoBuffer> createInputBufferOperation(final boolean frameBlendEnabled) {
                return new WrappedOperation<IVideoBuffer>(){

                    @Override
                    public IVideoBuffer execute() {
                        FrameBlend frameBlend;
                        if (frameBlendEnabled && (frameBlend = LayerNature.getFrameBlend(AbstractMediaLayer.this)) != FrameBlend.NONE) {
                            return AbstractMediaLayer.this.blendFrames(frameBlend);
                        }
                        MediaInput input = AbstractMediaLayer.this.getMediaInput();
                        return input.getVideoFrame(AbstractMediaLayer.this.calcVideoMediaTime(input));
                    }
                };
            }
        };
    }

    private VideoLayerRenderer.CRLayerRenderer createCRLayerRenderer() {
        return new VideoLayerRenderer.AbstractCRLayerRenderer(){

            @Override
            public MediaLayer getLayer() {
                return AbstractMediaLayer.this;
            }

            @Override
            public double getOpacity() {
                return (Double)AbstractMediaLayer.this._opacity.value(AbstractMediaLayer.this._context) / 100.0;
            }

            @Override
            public void multModelViewMatrix(double[] mvMatrix) {
                AbstractMediaLayer.this._oldSupport.setMatrix(null, mvMatrix);
                LayerMatrixUtil.multModelViewMatrix(AbstractMediaLayer.this, AbstractMediaLayer.this._context, AbstractMediaLayer.this._oldSupport);
                AbstractMediaLayer.this._oldSupport.getMatrix(null, mvMatrix);
            }

            @Override
            public VideoBounds calcBounds(boolean withEffects, VideoBounds viewport) {
                return AbstractMediaLayer.this._vePipeline.getVideoBounds(AbstractMediaLayer.this, this.getEffects(withEffects), this.createInputBoundsOperation(viewport));
            }

            @Override
            public IVideoBuffer render(boolean withEffects, VideoBounds viewport, double[] prjMatrix, double[] mvMatrix) {
                return AbstractMediaLayer.this._vePipeline.doVideoEffects(AbstractMediaLayer.this, this.getEffects(withEffects), this.createInputBoundsOperation(viewport), this.createInputBufferOperation(viewport, prjMatrix, mvMatrix));
            }

            @Override
            public IVideoBuffer render() {
                return AbstractMediaLayer.this._context.saveAndExecute(new WrappedOperation<IVideoBuffer>(){

                    @Override
                    public IVideoBuffer execute() {
                        MediaInput input = AbstractMediaLayer.this.getMediaInput();
                        return input.getVideoFrame(AbstractMediaLayer.this.calcVideoMediaTime(input));
                    }
                });
            }

            private List<Effect> getEffects(boolean withEffects) {
                return withEffects && AbstractMediaLayer.this._effectsEnabled ? AbstractMediaLayer.this._effects : Collections.emptyList();
            }

            private WrappedOperation<VideoBounds> createInputBoundsOperation(final VideoBounds viewport) {
                return new WrappedOperation<VideoBounds>(){

                    @Override
                    public VideoBounds execute() {
                        return viewport;
                    }
                };
            }

            private WrappedOperation<IVideoBuffer> createInputBufferOperation(final VideoBounds bounds, final double[] prjMatrix, final double[] mvMatrix) {
                return new WrappedOperation<IVideoBuffer>(){

                    @Override
                    public IVideoBuffer execute() {
                        IVideoBuffer rasterizedBuffer = null;
                        try {
                            rasterizedBuffer = AbstractMediaLayer.this._support.createVideoBuffer(bounds, AbstractMediaLayer.this._context.getColorMode());
                            rasterizedBuffer.clear();
                            VectorMediaInput input = (VectorMediaInput)AbstractMediaLayer.this.getMediaInput();
                            input.rasterize(rasterizedBuffer, prjMatrix, mvMatrix, AbstractMediaLayer.this.calcVideoMediaTime(input));
                            IVideoBuffer result = rasterizedBuffer;
                            rasterizedBuffer = null;
                            IVideoBuffer iVideoBuffer = result;
                            return iVideoBuffer;
                        }
                        finally {
                            if (rasterizedBuffer != null) {
                                rasterizedBuffer.dispose();
                            }
                        }
                    }
                };
            }
        };
    }

    protected Time calcVideoMediaTime(MediaInput input) {
        Time time;
        if (LayerNature.isTimeRemapEnabled(this)) {
            double t0 = (Double)this._timeRemap.value(this._context);
            Time ctxTime = this._context.getTime();
            double t1 = (Double)this._timeRemap.valueAtTime(new Time(ctxTime.timeValue + 1L, ctxTime.timeScale), (CoreContext)this._context);
            Time mediaFrameDuration = input.getVideoFrameDuration();
            int mediaTimeScale = mediaFrameDuration.timeScale;
            time = new Time(Math.round(t0 * (double)mediaTimeScale), mediaTimeScale);
            if (t0 > t1) {
                time = time.subtract(mediaFrameDuration);
            }
        } else {
            time = this._context.getTime().subtract(this.getStartTime());
            double rate = this.getRate();
            Time mediaFrameDuration = input.getVideoFrameDuration();
            if (mediaFrameDuration != null) {
                int mediaTimeScale = mediaFrameDuration.timeScale;
                time = new Time(Math.round(time.toSecond() * rate * (double)mediaTimeScale), mediaTimeScale);
            } else {
                time = new Time(Math.round((double)time.timeValue * rate), time.timeScale);
            }
            if (rate < 0.0) {
                Time mediaDuration = input.getDuration();
                if (mediaDuration != null) {
                    time = time.add(mediaDuration);
                    time = time.subtract(mediaFrameDuration);
                } else {
                    mediaDuration = this.getOutPoint().subtract(this.getStartTime());
                    time = time.add(mediaDuration);
                }
            }
        }
        return time;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IVideoBuffer blendFrames(FrameBlend frameBlend) {
        if (frameBlend == FrameBlend.NONE) {
            throw new IllegalArgumentException();
        }
        if (frameBlend != FrameBlend.FRAME_MIX) {
            throw new UnsupportedOperationException();
        }
        input = this.getMediaInput();
        mediaFrameDuration = input.getVideoFrameDuration();
        ctxTime = this._context.getTime();
        mediaTime0 = this.calcVideoMediaTime(input);
        this._context.setTime(ctxTime.add(this._context.getVideoFrameDuration()));
        mediaTime1 = this.calcVideoMediaTime(input);
        this._context.setTime(ctxTime);
        mediaTimeDiff = mediaTime1.subtract(mediaTime0);
        fpsRatio = mediaTimeDiff.toSecond() / mediaFrameDuration.toSecond();
        if (fpsRatio == 1.0) {
            return input.getVideoFrame(ctxTime);
        }
        fpsRatio = Math.abs(fpsRatio);
        buffers = Util.newList();
        accumBuf = null;
        try {
            block26: {
                block25: {
                    resolution = this._context.getVideoResolution();
                    bounds = resolution.scale(input.getVideoFrameBounds());
                    ctxColorMode = this._context.getColorMode();
                    accumBuf = ctxColorMode.isFloat() != false ? this._support.createVideoBuffer(bounds, ctxColorMode) : this._support.createVideoBuffer(bounds, ColorMode.RGBA16_FLOAT);
                    accumBuf.clear();
                    weights = Util.newList();
                    maxSources = this._accumSuport.getMaxSourcesAtATime();
                    if (!(fpsRatio > 1.0)) break block25;
                    intWeights = Util.newList();
                    w = (int)Math.round(255.0 / fpsRatio);
                    intWeights.add(w);
                    rest = 255 - w;
                    i = 1;
                    if (true) ** GOTO lbl70
                }
                frame = mediaTime0.toFrameNumber(mediaFrameDuration);
                if (mediaTime0.timeValue >= 0L) {
                    t0 = Time.fromFrameNumber((long)frame, (Time)mediaFrameDuration);
                    t1 = Time.fromFrameNumber((long)(frame + 1L), (Time)mediaFrameDuration);
                } else {
                    t0 = Time.fromFrameNumber((long)(frame - 1L), (Time)mediaFrameDuration);
                    t1 = Time.fromFrameNumber((long)frame, (Time)mediaFrameDuration);
                }
                tv0 = mediaTime0.subtract((Time)t0).timeValue;
                tv1 = t1.subtract((Time)mediaTime0).timeValue;
                buffers.add(input.getVideoFrame(t0));
                weights.add((double)tv1 / (double)(tv0 + tv1));
                if (maxSources == 1) {
                    this._accumSuport.accumulate(buffers, weights, accumBuf);
                    ((IVideoBuffer)buffers.get(0)).dispose();
                    buffers.clear();
                    weights.clear();
                }
                buffers.add(input.getVideoFrame(t1));
                weights.add((double)tv0 / (double)(tv0 + tv1));
                break block26;
                do {
                    if ((w = Math.min(rest, 2 * (int)Math.round(255.0 * (q = Math.exp(-(p = 2.35482 * (double)i / fpsRatio) * p / 2.0) / fpsRatio))) / 2) > 0) {
                        intWeights.add(w);
                        rest -= 2 * w;
                    } else if (rest > 0) {
                        intWeights.set(0, (Integer)intWeights.get(0) + rest);
                        rest = 0;
                    }
                    ++i;
lbl70:
                    // 2 sources

                } while (rest > 0);
                n = intWeights.size();
                i = -n + 1;
                while (i < n) {
                    t = mediaTime0.add(new Time(mediaFrameDuration.timeValue * (long)i, mediaFrameDuration.timeScale));
                    buffers.add(input.getVideoFrame(t));
                    weights.add((double)((Integer)intWeights.get(Math.abs(i))).intValue() / 255.0);
                    if (buffers.size() >= maxSources) {
                        this._accumSuport.accumulate(buffers, weights, accumBuf);
                        for (IVideoBuffer vb : buffers) {
                            vb.dispose();
                        }
                        buffers.clear();
                        weights.clear();
                    }
                    ++i;
                }
            }
            if (!buffers.isEmpty()) {
                this._accumSuport.accumulate(buffers, weights, accumBuf);
            }
            if (accumBuf.getColorMode() == ctxColorMode) {
                resultBuffer = accumBuf;
                accumBuf = null;
            } else {
                copy = null;
                try {
                    copy = this._support.createVideoBuffer(bounds, ctxColorMode);
                    this._support.copy(accumBuf, copy);
                    resultBuffer = copy;
                    copy = null;
                }
                finally {
                    if (copy != null) {
                        copy.dispose();
                    }
                }
            }
            var26_33 = resultBuffer;
            return var26_33;
        }
        finally {
            ** for (vb : buffers)
        }
lbl-1000:
        // 1 sources

        {
            vb.dispose();
            continue;
        }
lbl113:
        // 1 sources

        if (accumBuf == null) return var26_33;
        accumBuf.dispose();
        return var26_33;
    }

    private IAudioBuffer getTimeRemappedAudioChunk(MediaInput input) {
        IAudioBuffer ab1 = null;
        IAudioBuffer ab2 = null;
        IObjectArray times = null;
        try {
            AudioMode audioMode = this._context.getAudioMode();
            int sampleRate = audioMode.sampleRate;
            ab1 = this._arSupport.createAudioBuffer();
            times = this._arrayPools.getObjectArray(ab1.getFrameCount());
            this._timeRemap.values(times, audioMode.sampleDuration, this._context.getAudioAnimationRate(), this._context);
            double min = Double.POSITIVE_INFINITY;
            double max = Double.NEGATIVE_INFINITY;
            Object[] timeArray = (Object[])times.getArray();
            int i = 0;
            int n = times.getLength();
            while (i < n) {
                min = Math.min(min, (Double)timeArray[i]);
                max = Math.max(max, (Double)timeArray[i]);
                ++i;
            }
            long timeValueMin = (long)Math.floor(min * (double)sampleRate);
            long timeValueMax = (long)Math.ceil(max * (double)sampleRate);
            this._context.setAudioFrameCount((int)(timeValueMax - timeValueMin) + 1);
            ab2 = input.getAudioChunk(new Time(timeValueMin, sampleRate));
            if (ab2 == null) {
                return null;
            }
            Object data1 = ab1.getData();
            Object data2 = ab2.getData();
            int n1 = ab1.getFrameCount();
            switch (audioMode.dataType) {
                case SHORT: {
                    Object[] array1 = (short[])data1;
                    short[] array2 = (short[])data2;
                    int i2 = 0;
                    while (i2 < n1) {
                        int j = (int)(Math.round((Double)timeArray[i2] * (double)sampleRate) - timeValueMin);
                        array1[i2 * 2] = array2[j * 2];
                        array1[i2 * 2 + 1] = array2[j * 2 + 1];
                        ++i2;
                    }
                    break;
                }
                case INT: {
                    Object[] array1 = (int[])data1;
                    int[] array2 = (int[])data2;
                    int i3 = 0;
                    while (i3 < n1) {
                        int j = (int)(Math.round((Double)timeArray[i3] * (double)sampleRate) - timeValueMin);
                        array1[i3 * 2] = array2[j * 2];
                        array1[i3 * 2 + 1] = array2[j * 2 + 1];
                        ++i3;
                    }
                    break;
                }
                case FLOAT: {
                    Object[] array1 = (float[])data1;
                    float[] array2 = (float[])data2;
                    int i4 = 0;
                    while (i4 < n1) {
                        int j = (int)(Math.round((Double)timeArray[i4] * (double)sampleRate) - timeValueMin);
                        array1[i4 * 2] = (short)array2[j * 2];
                        array1[i4 * 2 + 1] = (short)array2[j * 2 + 1];
                        ++i4;
                    }
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("unsupported AudioMode.DataType: " + audioMode.dataType);
                }
            }
            IAudioBuffer result = ab1;
            ab1 = null;
            IAudioBuffer iAudioBuffer = result;
            return iAudioBuffer;
        }
        finally {
            if (ab1 != null) {
                ab1.dispose();
            }
            if (ab2 != null) {
                ab2.dispose();
            }
            if (times != null) {
                times.release();
            }
        }
    }

    private IAudioBuffer getRateChangedAudioChunk(MediaInput input, Time time, double rate) {
        IAudioBuffer ab1 = null;
        IAudioBuffer ab2 = null;
        try {
            long timeValueMax;
            Time t;
            long timeValueMin;
            AudioMode audioMode = this._context.getAudioMode();
            int sampleRate = audioMode.sampleRate;
            ab1 = this._arSupport.createAudioBuffer();
            double duration = input.getDuration().toSecond();
            if (rate >= 0.0) {
                timeValueMin = (long)Math.floor(time.toSecond() * (double)sampleRate * rate);
                t = time.add(new Time((long)this._context.getAudioFrameCount(), sampleRate));
                timeValueMax = (long)Math.ceil(t.toSecond() * (double)sampleRate * rate);
            } else {
                timeValueMax = (long)Math.ceil(duration * (double)sampleRate + time.toSecond() * (double)sampleRate * rate);
                t = time.add(new Time((long)this._context.getAudioFrameCount(), sampleRate));
                timeValueMin = (long)Math.floor(duration * (double)sampleRate + t.toSecond() * (double)sampleRate * rate);
            }
            this._context.setAudioFrameCount((int)(timeValueMax - timeValueMin) + 1);
            ab2 = input.getAudioChunk(new Time(timeValueMin, sampleRate));
            if (ab2 == null) {
                return null;
            }
            Object data1 = ab1.getData();
            Object data2 = ab2.getData();
            int n1 = ab1.getFrameCount();
            switch (audioMode.dataType) {
                case SHORT: {
                    Object[] array1 = (short[])data1;
                    short[] array2 = (short[])data2;
                    int i = 0;
                    while (i < n1) {
                        int j = rate >= 0.0 ? (int)(Math.round((time.toSecond() * (double)sampleRate + (double)i) * rate) - timeValueMin) : (int)(Math.round(duration * (double)sampleRate + (time.toSecond() * (double)sampleRate + (double)i) * rate) - timeValueMin);
                        array1[i * 2] = array2[j * 2];
                        array1[i * 2 + 1] = array2[j * 2 + 1];
                        ++i;
                    }
                    break;
                }
                case INT: {
                    Object[] array1 = (int[])data1;
                    int[] array2 = (int[])data2;
                    int i = 0;
                    while (i < n1) {
                        int j = rate >= 0.0 ? (int)(Math.round((time.toSecond() * (double)sampleRate + (double)i) * rate) - timeValueMin) : (int)(Math.round(duration * (double)sampleRate + (time.toSecond() * (double)sampleRate + (double)i) * rate) - timeValueMin);
                        array1[i * 2] = array2[j * 2];
                        array1[i * 2 + 1] = array2[j * 2 + 1];
                        ++i;
                    }
                    break;
                }
                case FLOAT: {
                    Object[] array1 = (float[])data1;
                    float[] array2 = (float[])data2;
                    int i = 0;
                    while (i < n1) {
                        int j = rate >= 0.0 ? (int)(Math.round((time.toSecond() * (double)sampleRate + (double)i) * rate) - timeValueMin) : (int)(Math.round(duration * (double)sampleRate + (time.toSecond() * (double)sampleRate + (double)i) * rate) - timeValueMin);
                        array1[i * 2] = (short)array2[j * 2];
                        array1[i * 2 + 1] = (short)array2[j * 2 + 1];
                        ++i;
                    }
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("unsupported AudioMode.DataType: " + audioMode.dataType);
                }
            }
            IAudioBuffer result = ab1;
            ab1 = null;
            IAudioBuffer iAudioBuffer = result;
            return iAudioBuffer;
        }
        finally {
            if (ab1 != null) {
                ab1.dispose();
            }
            if (ab2 != null) {
                ab2.dispose();
            }
        }
    }

    @Override
    public IAudioBuffer renderAudioChunk(boolean rawSource) {
        final MediaInput input = this.getMediaInput();
        if (input == null || !input.isAudioAvailable()) {
            return null;
        }
        WrappedOperation<IAudioBuffer> inputOperation = new WrappedOperation<IAudioBuffer>(){

            @Override
            public IAudioBuffer execute() {
                if (LayerNature.isTimeRemapEnabled(AbstractMediaLayer.this)) {
                    return AbstractMediaLayer.this.getTimeRemappedAudioChunk(input);
                }
                Time time = AbstractMediaLayer.this._context.getTime().subtract(AbstractMediaLayer.this.getStartTime());
                double rate = AbstractMediaLayer.this.getRate();
                if (rate == 1.0) {
                    return input.getAudioChunk(time);
                }
                return AbstractMediaLayer.this.getRateChangedAudioChunk(input, time, rate);
            }
        };
        IAudioBuffer ab = this._aePipeline.doAudioEffects(this, !rawSource && this._effectsEnabled ? this._effects : Collections.emptyList(), inputOperation);
        if (!rawSource) {
            if (this._audioLevels.hasKeyframe() || this._audioLevels.getExpression() != null || !((Vec2d)this._audioLevels.getStaticValue()).equals((Object)Vec2d.ZERO)) {
                IObjectArray audioLevels = this._arrayPools.getObjectArray(ab.getFrameCount());
                this._audioLevels.values(audioLevels, ab.getAudioMode().sampleDuration, this._context.getAudioAnimationRate(), this._context);
                this._arSupport.amplify(ab, (IObjectArray<Vec2d>)audioLevels);
                audioLevels.release();
            }
            Time time = this._context.getTime();
            Time sampleDuration = this._context.getAudioMode().sampleDuration;
            int clearFrameCount = (int)this.getInPoint().subtract(time).toFrameNumber(sampleDuration);
            if (clearFrameCount > 0) {
                this._arSupport.clear(ab, 0, clearFrameCount);
            }
            int clearFrameOffset = (int)this.getOutPoint().subtract(time).toFrameNumber(sampleDuration);
            clearFrameCount = this._context.getAudioFrameCount() - clearFrameOffset;
            if (clearFrameCount > 0) {
                this._arSupport.clear(ab, clearFrameOffset, clearFrameCount);
            }
        }
        return ab;
    }

    @Override
    public void afterDecode(Project p, LayerComposition c) throws ProjectDecodeException {
        super.afterDecode(p, c);
        for (Effect effect : this._effects) {
            effect.afterDecode(p);
        }
    }

    @Override
    public Object createExpressionElement(CoreContext context) {
        return new MediaLayerExpressionElement(context);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AnimatableCastsShadows
    extends AbstractAnimatableEnum<CastsShadows> {
        public AnimatableCastsShadows(CastsShadows staticValue, Collection<Keyframe<CastsShadows>> keyframes, String expression) {
            super(CastsShadows.class, staticValue, keyframes, expression);
        }

        public AnimatableCastsShadows(CastsShadows staticValue) {
            super(CastsShadows.class, staticValue);
        }
    }

    public class MediaLayerExpressionElement
    extends AbstractTransformableLayer.TransformableLayerExpressionElement {
        public MediaLayerExpressionElement(CoreContext context) {
            super(context);
        }

        public Object getOpacity() {
            return this.elem(AbstractMediaLayer.this._opacity);
        }

        public Object getAudioLevels() {
            return this.elem(AbstractMediaLayer.this._audioLevels);
        }

        public Object getTimeRemap() {
            return LayerNature.isTimeRemapEnabled(AbstractMediaLayer.this) ? this.elem(AbstractMediaLayer.this._timeRemap) : null;
        }

        public String getCastsShadows() {
            return AbstractMediaLayer.this._castsShadows.name();
        }

        public Object getShadowExpansionLeft() {
            return this.elem(AbstractMediaLayer.this._shadowExpansionLeft);
        }

        public Object getShadowExpansionTop() {
            return this.elem(AbstractMediaLayer.this._shadowExpansionTop);
        }

        public Object getShadowExpansionRight() {
            return this.elem(AbstractMediaLayer.this._shadowExpansionRight);
        }

        public Object getShadowExpansionBottom() {
            return this.elem(AbstractMediaLayer.this._shadowExpansionBottom);
        }

        public Object getLightTransmission() {
            return this.elem(AbstractMediaLayer.this._lightTransmission);
        }

        public boolean isAcceptsShadows() {
            return AbstractMediaLayer.this._acceptsShadows;
        }

        public boolean isAcceptsLights() {
            return AbstractMediaLayer.this._acceptsLights;
        }

        public Object getAmbient() {
            return this.elem(AbstractMediaLayer.this._ambient);
        }

        public Object getDiffuse() {
            return this.elem(AbstractMediaLayer.this._diffuse);
        }

        public Object getSpecular() {
            return this.elem(AbstractMediaLayer.this._specular);
        }

        public Object getShininess() {
            return this.elem(AbstractMediaLayer.this._shininess);
        }

        public Object getMetal() {
            return this.elem(AbstractMediaLayer.this._metal);
        }

        public Object effect(int index) {
            Effect effect = (Effect)AbstractMediaLayer.this._effects.get(index - 1);
            return this.context.getExpressionElement(effect);
        }

        public Object effect(String name) {
            for (Effect e : AbstractMediaLayer.this._effects) {
                if (!e.getName().equals(name)) continue;
                return this.context.getExpressionElement(e);
            }
            return null;
        }
    }
}

