/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal;

import ch.kuramo.javie.core.Composition;
import ch.kuramo.javie.core.Item;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.ProjectDecodeException;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.annotations.ProjectElement;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ProjectElement(value="project")
public class ProjectImpl
implements Project {
    private String _id;
    private List<Item> _items;
    private List<Composition> _compositions;

    public void initialize() {
        this._id = Util.randomId();
        this._items = Util.newList();
        this._compositions = Util.newList();
    }

    @Override
    public String getId() {
        return this._id;
    }

    public void setId(String id) {
        this._id = id;
    }

    @Override
    public List<Item> getItems() {
        return this._items;
    }

    public void setItems(List<Item> items) {
        this._items = items;
    }

    @Override
    public List<Composition> getCompositions() {
        return this._compositions;
    }

    public void setCompositions(List<Composition> compositions) {
        this._compositions = compositions;
    }

    @Override
    public <T extends Item> T getItem(String id) {
        for (Item i : this._items) {
            if (!i.getId().equals(id)) continue;
            Item t = i;
            return (T)t;
        }
        return null;
    }

    @Override
    public <T extends Composition> T getComposition(String id) {
        for (Composition c : this._compositions) {
            if (!c.getId().equals(id)) continue;
            Composition t = c;
            return (T)t;
        }
        return null;
    }

    @Override
    public void afterDecode() throws ProjectDecodeException {
        for (Item i : this._items) {
            i.afterDecode(this);
        }
        for (Composition c : this._compositions) {
            c.afterDecode(this);
        }
    }
}

