/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.misc;

import ch.kuramo.javie.core.JavieRuntimeException;
import com.jogamp.opengl.impl.awt.Java2DGLContext;
import javassist.CannotCompileException;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import javassist.expr.ExprEditor;
import javassist.expr.FieldAccess;

public class Java2DFboBugFix {
    public static void patch() {
        if (System.getProperty("os.name").toLowerCase().contains("windows") && !Boolean.getBoolean("sun.java2d.opengl.fbobject")) {
            Java2DFboBugFix.noFBOSupportFix();
        }
    }

    private static void noFBOSupportFix() {
        try {
            ClassLoader loader = Java2DGLContext.class.getClassLoader();
            ClassPool pool = new ClassPool();
            pool.appendClassPath((ClassPath)new LoaderClassPath(loader));
            CtClass targetClass = pool.get("com.jogamp.opengl.impl.awt.Java2D");
            targetClass.instrument(new ExprEditor(){

                public void edit(FieldAccess f) throws CannotCompileException {
                    if (f.getFieldName().equals("fbObjectSupportInitialized") && f.isReader()) {
                        f.replace("$_ = false;");
                    }
                }
            });
            targetClass.toClass(loader, null);
        }
        catch (NotFoundException e) {
            throw new JavieRuntimeException(e);
        }
        catch (CannotCompileException e) {
            throw new JavieRuntimeException(e);
        }
    }

    private Java2DFboBugFix() {
    }
}

