/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.output;

import ch.kuramo.javie.api.AudioMode;
import ch.kuramo.javie.api.IAudioBuffer;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Size2i;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.core.Composition;
import ch.kuramo.javie.core.JavieRuntimeException;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.output.ProgressMonitor;
import ch.kuramo.javie.core.output.PushSourceOutput;
import java.io.File;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WindowsDirectShowOutput
extends PushSourceOutput {
    private static final int DS_TIME_SCALE = 10000000;
    private VideoCompressorSettings _vcompSettings;
    private long _nativeObjPointer;
    private Time _frameDuration;
    private volatile Time _videoTime;

    static {
        System.loadLibrary("DirectShowOutput");
    }

    public VideoCompressorSettings getVideoCompressorSettings() {
        return this._vcompSettings;
    }

    public void setVideoCompressorSettings(VideoCompressorSettings vcompSettings) {
        this._vcompSettings = vcompSettings;
    }

    @Override
    protected void initialize() {
        int hr;
        Composition comp = this.getComposition();
        AudioMode audioMode = this.getAudioMode();
        File file = this.getFile();
        if (file.exists()) {
            file.delete();
        }
        Size2i size = comp.getSize();
        Time frameDuration = comp.getFrameDuration();
        long dsFrameDuration = (long)(1.0E7 * frameDuration.toSecond());
        boolean videoEnabled = this.isVideoEnabled();
        boolean audioEnabled = this.isAudioEnabled();
        VideoCompressorSettings vcs = this._vcompSettings;
        if (videoEnabled && vcs == null) {
            vcs = new VideoCompressorSettings(VideoCompressorDescriptor.uncompressedDescriptor("UNCOMPRESSED"));
        }
        long[] nativeObjPointer = new long[1];
        if (videoEnabled && audioEnabled) {
            hr = WindowsDirectShowOutput.initialize(nativeObjPointer, file.getAbsolutePath(), size.width, size.height, dsFrameDuration, true, vcs.moniker, vcs.quality, vcs.keyFrameRate, vcs.PFramesPerKey, vcs.bitRate, vcs.windowSize, vcs.config, audioMode.channels, audioMode.sampleRate, audioMode.sampleSize, audioMode.dataType == AudioMode.DataType.FLOAT);
        } else if (videoEnabled) {
            hr = WindowsDirectShowOutput.initialize(nativeObjPointer, file.getAbsolutePath(), size.width, size.height, dsFrameDuration, true, vcs.moniker, vcs.quality, vcs.keyFrameRate, vcs.PFramesPerKey, vcs.bitRate, vcs.windowSize, vcs.config, 0, 0, 0, false);
        } else if (audioEnabled) {
            hr = WindowsDirectShowOutput.initialize(nativeObjPointer, file.getAbsolutePath(), 0, 0, 0L, false, null, 0.0, 0, 0, 0L, 0L, null, audioMode.channels, audioMode.sampleRate, audioMode.sampleSize, audioMode.dataType == AudioMode.DataType.FLOAT);
        } else {
            throw new Error();
        }
        if (hr != 0) {
            throw new JavieRuntimeException("initialize: hr=" + hr);
        }
        this._nativeObjPointer = nativeObjPointer[0];
        if (videoEnabled) {
            this._frameDuration = frameDuration;
            this._videoTime = new Time(-1L, frameDuration.timeScale);
        }
    }

    @Override
    protected void finish() {
        WindowsDirectShowOutput.finish(this._nativeObjPointer);
        this._nativeObjPointer = 0L;
        this._frameDuration = null;
    }

    @Override
    protected void videoLoop(ProgressMonitor monitor) {
        super.videoLoop(monitor);
        this._videoTime = this.getComposition().getDuration();
    }

    @Override
    protected void writeVideo(long frameNumber, Time time, IVideoBuffer vb) {
        long dsTimeStart = (long)(1.0E7 * time.toSecond());
        long dsTimeEnd = (long)(1.0E7 * time.add(this._frameDuration).toSecond());
        WindowsDirectShowOutput.writeVideo(this._nativeObjPointer, dsTimeStart, dsTimeEnd, (byte[])vb.getArray());
        this._videoTime = time;
    }

    @Override
    protected void audioLoop(ProgressMonitor monitor) {
        if (this._videoTime != null) {
            WindowsDirectShowOutput.coInitializeEx();
            try {
                super.audioLoop(monitor);
            }
            finally {
                WindowsDirectShowOutput.coUninitialize();
            }
        } else {
            super.audioLoop(monitor);
        }
    }

    @Override
    protected void writeAudio(long frameNumber, Time time, IAudioBuffer ab) {
        if (this._videoTime != null) {
            while (this._videoTime.before(time)) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        long dsTime = (long)(1.0E7 * time.toSecond());
        WindowsDirectShowOutput.writeAudio(this._nativeObjPointer, dsTime, ab.getFrameCount(), ab.getData());
    }

    private static native int initialize(long[] var0, String var1, int var2, int var3, long var4, boolean var6, String var7, double var8, int var10, int var11, long var12, long var14, byte[] var16, int var17, int var18, int var19, boolean var20);

    private static native int finish(long var0);

    private static native int writeVideo(long var0, long var2, long var4, byte[] var6);

    private static native int writeAudio(long var0, long var2, int var4, Object var5);

    private static native int coInitializeEx();

    private static native int coUninitialize();

    public static List<VideoCompressorDescriptor> listVideoCompressors(Composition comp) {
        Size2i size = comp.getSize();
        Time frameDuration = comp.getFrameDuration();
        long dsFrameDuration = (long)(1.0E7 * frameDuration.toSecond());
        List<VideoCompressorDescriptor> list = Util.newList();
        int hr = WindowsDirectShowOutput.getVideoCompressors(list, size.width, size.height, dsFrameDuration, true);
        if (hr != 0) {
            throw new JavieRuntimeException("getVideoCompressors: hr=" + hr);
        }
        return list;
    }

    public static void openVideoCompressorConfigDialog(Composition comp, VideoCompressorDescriptor desc, VideoCompressorSettings settings, long hwnd) {
        if (!desc.moniker.equals(settings.moniker)) {
            throw new IllegalArgumentException();
        }
        if (!desc.canConfigDialog) {
            throw new IllegalArgumentException();
        }
        Size2i size = comp.getSize();
        Time frameDuration = comp.getFrameDuration();
        long dsFrameDuration = (long)(1.0E7 * frameDuration.toSecond());
        byte[][] ioConfig = new byte[][]{settings.config};
        int hr = WindowsDirectShowOutput.openVideoCompressorConfigDialog(size.width, size.height, dsFrameDuration, true, desc.moniker, ioConfig, hwnd);
        if (hr != 0) {
            throw new JavieRuntimeException("openVideoCompressorConfigDialog: hr=" + hr);
        }
        settings.config = ioConfig[0];
    }

    public static void openVideoCompressorAboutDialog(VideoCompressorDescriptor desc, long hwnd) {
        if (!desc.canAboutDialog) {
            throw new IllegalArgumentException();
        }
        int hr = WindowsDirectShowOutput.openVideoCompressorAboutDialog(desc.moniker, hwnd);
        if (hr != 0) {
            throw new JavieRuntimeException("openVideoCompressorAboutDialog: hr=" + hr);
        }
    }

    private static native int getVideoCompressors(List<VideoCompressorDescriptor> var0, int var1, int var2, long var3, boolean var5);

    private static native int openVideoCompressorConfigDialog(int var0, int var1, long var2, boolean var4, String var5, byte[][] var6, long var7);

    private static native int openVideoCompressorAboutDialog(String var0, long var1);

    public static class VideoCompressorDescriptor {
        public final String moniker;
        public final String friendlyName;
        public final int capabilities;
        public final boolean canQuality;
        public final boolean canKeyFrame;
        public final boolean canBFrame;
        public final boolean canCrunch;
        public final boolean canWindow;
        public final boolean canConfigDialog;
        public final boolean canAboutDialog;
        public final double defaultQuality;
        public final int defaultKeyFrameRate;
        public final int defaultPFramesPerKey;
        public final long defaultBitRate;

        public VideoCompressorDescriptor(String moniker, String friendlyName, int capabilities, boolean canConfigDialog, boolean canAboutDialog, double defaultQuality, int defaultKeyFrameRate, int defaultPFramesPerKey, long defaultBitRate) {
            this.moniker = moniker;
            this.friendlyName = friendlyName;
            this.capabilities = capabilities;
            this.canQuality = (capabilities & 1) != 0;
            this.canKeyFrame = (capabilities & 4) != 0;
            this.canBFrame = (capabilities & 8) != 0;
            this.canCrunch = (capabilities & 2) != 0;
            this.canWindow = (capabilities & 0x10) != 0;
            this.canConfigDialog = canConfigDialog;
            this.canAboutDialog = canAboutDialog;
            this.defaultQuality = defaultQuality;
            this.defaultKeyFrameRate = defaultKeyFrameRate;
            this.defaultPFramesPerKey = defaultPFramesPerKey;
            this.defaultBitRate = defaultBitRate;
        }

        public static VideoCompressorDescriptor uncompressedDescriptor(String friendlyName) {
            return new VideoCompressorDescriptor(null, friendlyName, 0, false, false, -1.0, -1, -1, 0L);
        }
    }

    public static class VideoCompressorSettings
    implements Cloneable {
        public final String moniker;
        public final String friendlyName;
        public double quality;
        public int keyFrameRate;
        public int PFramesPerKey;
        public long bitRate;
        public long windowSize;
        public byte[] config;

        public VideoCompressorSettings(VideoCompressorDescriptor desc) {
            this.moniker = desc.moniker;
            this.friendlyName = desc.friendlyName;
            this.quality = desc.defaultQuality;
            this.keyFrameRate = desc.defaultKeyFrameRate;
            this.PFramesPerKey = desc.defaultPFramesPerKey;
            this.bitRate = desc.defaultBitRate;
            this.windowSize = 1L;
        }

        public VideoCompressorSettings clone() {
            try {
                return (VideoCompressorSettings)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new Error(e);
            }
        }
    }
}

