/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.actions;

import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.app.UIUtil;
import ch.kuramo.javie.app.project.NewImageSequenceOperation;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.views.ProjectView;
import ch.kuramo.javie.app.widgets.FrameRateComboUtil;
import ch.kuramo.javie.app.widgets.GridBuilder;
import ch.kuramo.javie.core.Folder;
import ch.kuramo.javie.core.FrameDuration;
import java.io.File;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;

public class NewImageSequenceAction
extends Action {
    private final IWorkbenchWindow window;

    public NewImageSequenceAction(IWorkbenchWindow window) {
        super("\u30a4\u30e1\u30fc\u30b8\u30b7\u30fc\u30b1\u30f3\u30b9...");
        this.window = window;
        this.setId("ch.kuramo.javie.app.commands.newImageSequence");
        this.setActionDefinitionId("ch.kuramo.javie.app.commands.newImageSequence");
    }

    public void run() {
        ProjectManager pm = ProjectManager.forWorkbenchWindow(this.window);
        if (pm == null) {
            return;
        }
        File file = this.showFileDialog();
        if (file == null) {
            return;
        }
        Time frameDuration = this.showFrameDurationDialog();
        if (frameDuration == null) {
            return;
        }
        ProjectView projectView = (ProjectView)((Object)UIUtil.showView(this.window.getActivePage(), "ch.kuramo.javie.app.views.projectView"));
        Folder parent = projectView.getItemTreeInsertionPoint();
        pm.postOperation(new NewImageSequenceOperation(pm, parent, file, frameDuration));
    }

    private File showFileDialog() {
        String[] filterNames = new String[]{"\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u308b\u3059\u3079\u3066\u306e\u30d5\u30a1\u30a4\u30eb", "BMP (*.bmp)", "PNG (*.png)", "GIF (*.gif)", "JPEG (*.jpg,*.jpeg)", "\u3059\u3079\u3066\u306e\u30d5\u30a1\u30a4\u30eb"};
        String[] filterExtensions = new String[]{"*.bmp;*.png;*.gif;*.jpg;*.jpeg", "*.bmp", "*.png", "*.gif", "*.jpg;*.jpeg", "*"};
        String platform = SWT.getPlatform();
        if (platform.equals("win32") || platform.equals("wpf")) {
            filterExtensions[filterExtensions.length - 1] = "*.*";
        }
        FileDialog dialog = new FileDialog(this.window.getShell(), 0x10001000);
        dialog.setFilterNames(filterNames);
        dialog.setFilterExtensions(filterExtensions);
        if (dialog.open() == null) {
            return null;
        }
        return new File(dialog.getFilterPath(), dialog.getFileName());
    }

    private Time showFrameDurationDialog() {
        final String[] fpsStr = new String[1];
        Dialog dialog = new Dialog(this.window.getShell()){
            private Combo fpsCombo;

            protected void configureShell(Shell newShell) {
                super.configureShell(newShell);
                newShell.setText("\u30a4\u30e1\u30fc\u30b8\u30b7\u30fc\u30b1\u30f3\u30b9\u306e\u8aad\u307f\u8fbc\u307f");
            }

            protected Control createDialogArea(Composite parent) {
                Composite composite = (Composite)super.createDialogArea(parent);
                GridBuilder gb = new GridBuilder(composite, 3, false);
                gb.hSpan(1).hAlign(131072).label(0, "\u30d5\u30ec\u30fc\u30e0\u30ec\u30fc\u30c8:");
                this.fpsCombo = gb.hSpan(1).hAlign(4).combo(0, 0, FrameRateComboUtil.getComboItems(), FrameRateComboUtil.toComboItem(FrameDuration.FPS_29_97));
                gb.hSpan(1).label(0, "\u30d5\u30ec\u30fc\u30e0\uff0f\u79d2");
                this.fpsCombo.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        this.updateOkButton();
                    }
                });
                this.fpsCombo.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        this.updateOkButton();
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                        this.updateOkButton();
                    }
                });
                Composite grid = gb.getComposite();
                grid.setTabList(gb.getTabList());
                parent.pack();
                return composite;
            }

            private void updateOkButton() {
                Button okButton = this.getButton(0);
                okButton.setEnabled(this.isValidFps());
            }

            private boolean isValidFps() {
                double fps;
                String fpsStr2 = this.fpsCombo.getText().trim();
                try {
                    fps = Double.parseDouble(fpsStr2);
                }
                catch (NumberFormatException numberFormatException) {
                    fps = 0.0;
                }
                return fps >= 1.0;
            }

            protected void okPressed() {
                if (this.isValidFps()) {
                    fpsStr[0] = this.fpsCombo.getText().trim();
                    super.okPressed();
                }
            }
        };
        if (dialog.open() == 0) {
            return FrameRateComboUtil.toFrameDuration(fpsStr[0]);
        }
        return null;
    }
}

