/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.app.PropertyUtil;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.Project;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyLayerPropertyOperation<T>
extends ProjectOperation {
    private final String compId;
    private final String layerId;
    private final String property;
    private final T oldValue;
    private final T newValue;

    public ModifyLayerPropertyOperation(ProjectManager pm, Layer layer, String property, T newValue, String label) {
        super(pm, label);
        LayerComposition comp = pm.checkLayer(layer);
        this.compId = comp.getId();
        this.layerId = layer.getId();
        this.property = property;
        this.oldValue = PropertyUtil.getProperty(layer, property);
        this.newValue = newValue;
        this._noEffect = newValue == this.oldValue || newValue != null && newValue.equals(this.oldValue);
    }

    @Override
    protected IStatus executeOrRedo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.modifyProperty(this.newValue, project, pm);
        return Status.OK_STATUS;
    }

    @Override
    protected IStatus undo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.modifyProperty(this.oldValue, project, pm);
        return Status.OK_STATUS;
    }

    private void modifyProperty(T value, Project project, ProjectManager pm) {
        LayerComposition comp = (LayerComposition)project.getComposition(this.compId);
        Layer layer = comp.getLayer(this.layerId);
        PropertyUtil.setProperty(layer, this.property, value);
        if (pm != null) {
            pm.fireLayerPropertyChange(layer, this.property);
        }
    }
}

