/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.publisher.eclipse;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.equinox.internal.p2.publisher.eclipse.DataLoader;
import org.eclipse.equinox.internal.p2.publisher.eclipse.IProductDescriptor;
import org.eclipse.equinox.internal.provisional.frameworkadmin.BundleInfo;
import org.eclipse.equinox.internal.provisional.frameworkadmin.ConfigData;
import org.eclipse.equinox.internal.provisional.p2.core.Version;
import org.eclipse.equinox.internal.provisional.p2.core.VersionedName;
import org.eclipse.equinox.p2.publisher.AbstractAdvice;
import org.eclipse.equinox.p2.publisher.AbstractPublisherAction;
import org.eclipse.equinox.p2.publisher.actions.ILicenseAdvice;
import org.eclipse.equinox.p2.publisher.eclipse.IBrandingAdvice;
import org.eclipse.equinox.p2.publisher.eclipse.IConfigAdvice;
import org.eclipse.equinox.p2.publisher.eclipse.IExecutableAdvice;

public class ProductFileAdvice
extends AbstractAdvice
implements ILicenseAdvice,
IExecutableAdvice,
IConfigAdvice,
IBrandingAdvice {
    private static final String OSGI_SPLASH_PATH = "osgi.splashPath";
    private static final String SPLASH_PREFIX = "platform:/base/plugins/";
    private IProductDescriptor product;
    private String configSpec;
    private String ws;
    private String os;
    private String arch;
    private ConfigData configData = null;

    protected String getId() {
        return this.product.getId();
    }

    protected Version getVersion() {
        return Version.parseVersion((String)this.product.getVersion());
    }

    public ProductFileAdvice(IProductDescriptor product, String configSpec) {
        this.product = product;
        this.configSpec = configSpec;
        String[] config = AbstractPublisherAction.parseConfigSpec(configSpec);
        this.ws = config[0];
        if (this.ws == null) {
            this.ws = "ANY";
        }
        this.os = config[1];
        if (this.os == null) {
            this.os = "ANY";
        }
        this.arch = config[2];
        if (this.arch == null) {
            this.arch = "ANY";
        }
        this.configData = this.getConfigData();
    }

    public String[] getProgramArguments() {
        String line = this.product.getProgramArguments(this.os);
        return AbstractPublisherAction.getArrayFromString(line, " ");
    }

    public String[] getVMArguments() {
        String line = this.product.getVMArguments(this.os);
        return AbstractPublisherAction.getArrayFromString(line, " ");
    }

    public BundleInfo[] getBundles() {
        return this.configData.getBundles();
    }

    public Properties getProperties() {
        Properties result = new Properties();
        result.putAll((Map<?, ?>)this.configData.getProperties());
        result.putAll((Map<?, ?>)this.product.getConfigurationProperties());
        return result;
    }

    public String getExecutableName() {
        return this.product.getLauncherName();
    }

    public IProductDescriptor getProductFile() {
        return this.product;
    }

    public String[] getIcons() {
        return this.product.getIcons(this.os);
    }

    public String getOS() {
        return this.os;
    }

    public String getLicenseURL() {
        return this.product.getLicenseURL();
    }

    public String getLicenseText() {
        return this.product.getLicenseText();
    }

    private ConfigData getConfigData() {
        String location;
        DataLoader loader = this.createDataLoader();
        ConfigData result = loader != null ? loader.getConfigData() : this.generateConfigData();
        this.addProductFileBundles(result);
        this.addProductFileConfigBundles(result);
        if (this.product.getProductId() != null) {
            result.setProperty("eclipse.product", this.product.getProductId());
        }
        if (this.product.getApplication() != null) {
            result.setProperty("eclipse.application", this.product.getApplication());
        }
        if ((location = this.getSplashLocation()) != null) {
            result.setProperty(OSGI_SPLASH_PATH, SPLASH_PREFIX + location);
        }
        return result;
    }

    private void addProductFileConfigBundles(ConfigData configData) {
        HashSet<BundleInfo> versionBoundBundles = new HashSet<BundleInfo>();
        HashMap unboundedBundles = new HashMap();
        BundleInfo[] bundles = configData.getBundles();
        int i = 0;
        while (i < bundles.length) {
            BundleInfo bundleInfo = bundles[i];
            if (bundleInfo.getVersion() == null || bundleInfo.getVersion().equals("0.0.0")) {
                bundleInfo.setVersion("0.0.0");
                this.addUnboundedBundle(unboundedBundles, bundleInfo);
            } else {
                versionBoundBundles.add(bundleInfo);
                this.addUnboundedBundle(unboundedBundles, bundleInfo);
            }
            ++i;
        }
        List bundleInfos = this.product.getBundleInfos();
        Iterator i2 = bundleInfos.iterator();
        while (i2.hasNext()) {
            BundleInfo bundleInfo = (BundleInfo)i2.next();
            if (versionBoundBundles.contains(bundleInfo)) {
                configData.removeBundle(bundleInfo);
                configData.addBundle(bundleInfo);
                continue;
            }
            if (bundleInfo.getVersion() == null || bundleInfo.getVersion().equals("0.0.0")) {
                List list = (List)unboundedBundles.get(bundleInfo.getSymbolicName());
                if (list == null) {
                    configData.addBundle(bundleInfo);
                    continue;
                }
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    BundleInfo target = (BundleInfo)iterator.next();
                    target.setStartLevel(bundleInfo.getStartLevel());
                    target.setMarkedAsStarted(bundleInfo.isMarkedAsStarted());
                }
                continue;
            }
            configData.addBundle(bundleInfo);
        }
    }

    private void addUnboundedBundle(Map data, BundleInfo bundleInfo) {
        if (!data.containsKey(bundleInfo.getSymbolicName())) {
            data.put(bundleInfo.getSymbolicName(), new LinkedList());
        }
        ((LinkedList)data.get(bundleInfo.getSymbolicName())).add(bundleInfo);
    }

    private void addProductFileBundles(ConfigData configData) {
        List bundles = this.product.getBundles(true);
        HashSet<BundleInfo> set = new HashSet<BundleInfo>();
        set.addAll(Arrays.asList(configData.getBundles()));
        Iterator i = bundles.iterator();
        while (i.hasNext()) {
            VersionedName name = (VersionedName)i.next();
            BundleInfo bundleInfo = new BundleInfo();
            bundleInfo.setSymbolicName(name.getId());
            bundleInfo.setVersion(name.getVersion().toString());
            if (set.contains(bundleInfo)) continue;
            configData.addBundle(bundleInfo);
        }
    }

    private ConfigData generateConfigData() {
        ConfigData result = new ConfigData(null, null, null, null);
        if (this.product.useFeatures()) {
            return result;
        }
        List bundles = this.product.getBundles(true);
        Iterator i = bundles.iterator();
        while (i.hasNext()) {
            VersionedName name = (VersionedName)i.next();
            BundleInfo bundleInfo = new BundleInfo();
            bundleInfo.setSymbolicName(name.getId());
            bundleInfo.setVersion(name.getVersion().toString());
            result.addBundle(bundleInfo);
        }
        return result;
    }

    private String getSplashLocation() {
        return this.product.getSplashLocation();
    }

    protected String getConfigSpec() {
        return this.configSpec;
    }

    protected boolean matchConfig(String spec, boolean includeDefault) {
        if (spec != null) {
            String targetWS = AbstractPublisherAction.parseConfigSpec(spec)[0];
            if (targetWS == null) {
                targetWS = "ANY";
            }
            if (!(this.ws.equals(targetWS) || this.ws.equals("ANY") || targetWS.equals("ANY"))) {
                return false;
            }
            String targetOS = AbstractPublisherAction.parseConfigSpec(spec)[1];
            if (targetOS == null) {
                targetOS = "ANY";
            }
            if (!(this.os.equals(targetOS) || this.os.equals("ANY") || targetOS.equals("ANY"))) {
                return false;
            }
            String targetArch = AbstractPublisherAction.parseConfigSpec(spec)[2];
            if (targetArch == null) {
                targetArch = "ANY";
            }
            if (!(this.arch.equals(targetArch) || this.arch.equals("ANY") || targetArch.equals("ANY"))) {
                return false;
            }
        }
        return true;
    }

    private DataLoader createDataLoader() {
        File parent;
        String location = this.product.getConfigIniPath(this.os);
        if (location == null) {
            location = this.product.getConfigIniPath(null);
        }
        if (location == null) {
            return null;
        }
        File configFile = new File(location);
        if (!configFile.isAbsolute() || !configFile.exists()) {
            configFile = new File(this.product.getLocation().getParentFile(), location);
        }
        if ((parent = configFile.getParentFile()).getName().equals("configuration") && parent.getParentFile() != null) {
            parent = parent.getParentFile();
        }
        return new DataLoader(configFile, parent);
    }
}

