/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.keying;

import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableEnum;
import ch.kuramo.javie.api.IAnimatableLayerReference;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Quality;
import ch.kuramo.javie.api.Resolution;
import ch.kuramo.javie.api.ShaderType;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.services.IBlurSupport;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import com.google.inject.Inject;
import java.util.HashSet;
import javax.media.opengl.GLUniformData;

@Effect(id="ch.kuramo.javie.DifferenceMatte", category="ch.kuramo.javie.api.effectCategory.keying")
public class DifferenceMatte {
    @Property
    private IAnimatableLayerReference differenceLayer;
    @Property(value="CENTER")
    private IAnimatableEnum<IfLayerSizesDiffer> ifLayerSizesDiffer;
    @Property(value="0", min="0", max="100")
    private IAnimatableDouble matchingTolerance;
    @Property(value="0", min="0", max="100")
    private IAnimatableDouble matchingSoftness;
    @Property(value="0", min="0", max="500")
    private IAnimatableDouble blurBeforeDifference;
    @Property(value="RESULT")
    private IAnimatableEnum<Output> output;
    private final IVideoEffectContext context;
    private final IVideoRenderSupport support;
    private final IBlurSupport blurSupport;
    private final IShaderRegistry shaders;

    @Inject
    public DifferenceMatte(IVideoEffectContext context, IVideoRenderSupport support, IBlurSupport blurSupport, IShaderRegistry shaders) {
        this.context = context;
        this.support = support;
        this.blurSupport = blurSupport;
        this.shaders = shaders;
    }

    public IVideoBuffer doVideoEffect() {
        IVideoBuffer source = this.context.doPreviousEffect();
        final VideoBounds bounds = source.getBounds();
        if (bounds.isEmpty()) {
            return source;
        }
        Output output = (Output)((Object)this.context.value(this.output));
        if (output == Output.SOURCE_ONLY) {
            return source;
        }
        IVideoBuffer diffLayer = null;
        IVideoBuffer[] blurred = null;
        try {
            IVideoBuffer input2;
            IVideoBuffer input1;
            Resolution resolution;
            double blur;
            diffLayer = this.context.getLayerVideoFrame(this.differenceLayer);
            if (diffLayer == null) {
                IVideoBuffer result = source;
                source = null;
                IVideoBuffer iVideoBuffer = result;
                return iVideoBuffer;
            }
            final boolean stretchToFit = this.context.value(this.ifLayerSizesDiffer) == IfLayerSizesDiffer.STRETCH_TO_FIT;
            final VideoBounds diffBounds = diffLayer.getBounds();
            if (stretchToFit && !diffBounds.equals((Object)bounds)) {
                IVideoBuffer old = diffLayer;
                diffLayer = this.stretchToFit(old, bounds);
                old.dispose();
            }
            if ((blur = (resolution = this.context.getVideoResolution()).scale(((Double)this.context.value((IAnimatableValue)this.blurBeforeDifference)).doubleValue())) > 0.0) {
                blurred = new IVideoBuffer[]{this.blurSupport.gaussianBlur(source, blur, IBlurSupport.BlurDimensions.BOTH, true, true), this.blurSupport.gaussianBlur(diffLayer, blur, IBlurSupport.BlurDimensions.BOTH, true, true)};
            }
            double tolerance = (Double)this.context.value((IAnimatableValue)this.matchingTolerance) * Math.sqrt(3.0) / 100.0;
            double softness = (Double)this.context.value((IAnimatableValue)this.matchingSoftness) / 100.0;
            HashSet<GLUniformData> uniforms = new HashSet<GLUniformData>();
            uniforms.add(new GLUniformData("texture1", 0));
            uniforms.add(new GLUniformData("texture2", 1));
            uniforms.add(new GLUniformData("t", (float)tolerance));
            uniforms.add(new GLUniformData("s", (float)((Math.sqrt(3.0) - tolerance) * softness)));
            if (output != Output.MATTE_ONLY) {
                uniforms.add(new GLUniformData("source", 2));
            }
            if (blurred != null) {
                input1 = blurred[0];
                input2 = blurred[1];
            } else {
                input1 = source;
                input2 = diffLayer;
            }
            Runnable operation = new Runnable(){

                public void run() {
                    double[][][] texCoords;
                    if (stretchToFit) {
                        texCoords = new double[][][]{new double[][]{{0.0, 0.0}, {1.0, 0.0}, {1.0, 1.0}, {0.0, 1.0}}, new double[][]{{0.0, 0.0}, {1.0, 0.0}, {1.0, 1.0}, {0.0, 1.0}}};
                    } else {
                        double x = (double)(diffBounds.width - bounds.width) * 0.5 / (double)diffBounds.width;
                        double y = (double)(diffBounds.height - bounds.height) * 0.5 / (double)diffBounds.height;
                        texCoords = new double[][][]{new double[][]{{0.0, 0.0}, {1.0, 0.0}, {1.0, 1.0}, {0.0, 1.0}}, new double[][]{{x, y}, {1.0 - x, y}, {1.0 - x, 1.0 - y}, {x, 1.0 - y}}};
                    }
                    DifferenceMatte.this.support.ortho2D(bounds);
                    DifferenceMatte.this.support.quad2D(bounds, (double[][][])texCoords);
                }
            };
            switch (output) {
                case RESULT: {
                    IVideoBuffer iVideoBuffer = this.support.useShaderProgram(this.getProgram(false), uniforms, operation, 0, null, new IVideoBuffer[]{input1, input2, source});
                    return iVideoBuffer;
                }
                case MATTE_ONLY: {
                    IVideoBuffer iVideoBuffer = this.support.useShaderProgram(this.getProgram(true), uniforms, operation, 0, null, new IVideoBuffer[]{input1, input2});
                    return iVideoBuffer;
                }
            }
            throw new Error();
        }
        finally {
            if (source != null) {
                source.dispose();
            }
            if (diffLayer != null) {
                diffLayer.dispose();
            }
            if (blurred != null) {
                if (blurred[0] != null) {
                    blurred[0].dispose();
                }
                if (blurred[1] != null) {
                    blurred[1].dispose();
                }
            }
        }
    }

    private IVideoBuffer stretchToFit(IVideoBuffer diffLayer, final VideoBounds bounds) {
        IVideoBuffer buffer = null;
        try {
            buffer = this.support.createVideoBuffer(bounds);
            if (this.context.getQuality() == Quality.DRAFT || this.context.getVideoResolution().scale < 1.0) {
                diffLayer.setTextureFilter(IVideoBuffer.TextureFilter.NEAREST);
            } else {
                VideoBounds diffBounds = diffLayer.getBounds();
                if (bounds.width < diffBounds.width || bounds.height < diffBounds.height) {
                    diffLayer.setTextureFilter(IVideoBuffer.TextureFilter.MIPMAP);
                } else {
                    diffLayer.setTextureFilter(IVideoBuffer.TextureFilter.LINEAR);
                }
            }
            Runnable operation = new Runnable(){

                public void run() {
                    DifferenceMatte.this.support.ortho2D(bounds);
                    DifferenceMatte.this.support.quad2D(bounds, (double[][][])new double[][][]{new double[][]{{0.0, 0.0}, {1.0, 0.0}, {1.0, 1.0}, {0.0, 1.0}}});
                }
            };
            this.support.useFramebuffer(operation, 0, buffer, new IVideoBuffer[]{diffLayer});
            IVideoBuffer result = buffer;
            buffer = null;
            IVideoBuffer iVideoBuffer = result;
            return iVideoBuffer;
        }
        finally {
            if (buffer != null) {
                buffer.dispose();
            }
        }
    }

    private IShaderProgram getProgram(boolean matteOnly) {
        String programName = String.valueOf(DifferenceMatte.class.getName()) + (matteOnly ? ".MATTE_ONLY" : ".DIFFERENCE_MATTE");
        IShaderProgram program = this.shaders.getProgram(programName);
        if (program == null) {
            String[] source = this.createProgramSource(matteOnly);
            program = this.shaders.registerProgram(programName, ShaderType.FRAGMENT_SHADER, null, source);
        }
        return program;
    }

    private String[] createProgramSource(boolean matteOnly) {
        boolean mo = matteOnly;
        return new String[]{mo ? "#define MATTE_ONLY" : "", "", "uniform sampler2D texture1;", "uniform sampler2D texture2;", "uniform float t;", "uniform float s;", "", "#ifndef MATTE_ONLY", "\tuniform sampler2D source;", "#endif", "", "void main(void)", "{", "\tvec2 tc1 = gl_TexCoord[0].st;", "\tvec4 color1 = texture2D(texture1, tc1);", "\tcolor1.rgb = (color1.a > 0.0) ? color1.rgb/color1.a : vec3(0.0);", "", "\tvec2 tc2 = gl_TexCoord[1].st;", "\tvec4 color2 = texture2D(texture2, tc2);", "\tcolor2.rgb = (color2.a > 0.0) ? color2.rgb/color2.a : vec3(0.0);", "", "\tfloat d = distance(color1.rgb, color2.rgb);", "\td = clamp((d-t)/s, 0.0, 1.0);", "", "#ifdef MATTE_ONLY", "\tgl_FragColor = vec4(d);", "#else", "\tgl_FragColor = texture2D(source, tc1) * d;", "#endif", "}"};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IfLayerSizesDiffer {
        CENTER,
        STRETCH_TO_FIT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Output {
        RESULT,
        SOURCE_ONLY,
        MATTE_ONLY;

    }
}

