/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.stylize;

import ch.kuramo.javie.api.BlendMode;
import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.IAnimatableBoolean;
import ch.kuramo.javie.api.IAnimatableColor;
import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableEnum;
import ch.kuramo.javie.api.IAnimatableInteger;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IAnimatableVec2d;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.ShaderType;
import ch.kuramo.javie.api.Vec2d;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.services.IBlendSupport;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import com.google.inject.Inject;
import java.nio.FloatBuffer;
import java.util.HashSet;
import javax.media.opengl.GLUniformData;

@Effect(id="ch.kuramo.javie.LightBurst", category="ch.kuramo.javie.api.effectCategory.stylize")
public class LightBurst {
    @Property
    private IAnimatableVec2d center;
    @Property(value="100", min="0")
    private IAnimatableDouble intensity;
    @Property(value="0", min="0", max="200")
    private IAnimatableDouble rayLength;
    @Property(value="false")
    private IAnimatableBoolean setColor;
    @Property(value="1.0,0.8,0.4")
    private IAnimatableColor color;
    @Property(value="ON_TOP")
    private IAnimatableEnum<RayComposite> rayComposite;
    @Property(value="ADD")
    private IAnimatableEnum<BlendMode> blendMode;
    @Property(value="200", min="0")
    private IAnimatableInteger maxSamples;
    @Property(value="true")
    private IAnimatableBoolean fast;
    private final IVideoEffectContext context;
    private final IVideoRenderSupport support;
    private final IBlendSupport blendSupport;
    private final IShaderRegistry shaders;
    private static /* synthetic */ int[] $SWITCH_TABLE$ch$kuramo$javie$effects$stylize$LightBurst$RayComposite;

    @Inject
    public LightBurst(IVideoEffectContext context, IVideoRenderSupport support, IBlendSupport blendSupport, IShaderRegistry shaders) {
        this.context = context;
        this.support = support;
        this.blendSupport = blendSupport;
        this.shaders = shaders;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IVideoBuffer doVideoEffect() {
        source = this.context.doPreviousEffect();
        bounds = source.getBounds();
        if (bounds.isEmpty()) {
            return source;
        }
        resolution = this.context.getVideoResolution();
        center = resolution.scale((Vec2d)this.context.value((IAnimatableValue)this.center));
        intensity = (Double)this.context.value((IAnimatableValue)this.intensity) / 100.0;
        rayLength = resolution.scale(((Double)this.context.value((IAnimatableValue)this.rayLength)).doubleValue());
        color = (Boolean)this.context.value((IAnimatableValue)this.setColor) != false ? (Color)this.context.value((IAnimatableValue)this.color) : null;
        rayComposite = (RayComposite)this.context.value(this.rayComposite);
        blendMode = (BlendMode)this.context.value(this.blendMode);
        maxSamples = (Integer)this.context.value((IAnimatableValue)this.maxSamples);
        fast = (Boolean)this.context.value((IAnimatableValue)this.fast);
        tmpBuffers = new HashSet<IVideoBuffer>();
        tmpBuffers.add(source);
        try {
            uniforms = new HashSet<GLUniformData>();
            buffer = source;
            if (fast) {
                uniforms.add(new GLUniformData("amount", (float)(rayLength / resolution.scale(200.0) / (double)maxSamples * 5.0)));
                uniforms.add(new GLUniformData("source", 0));
                uniforms.add(new GLUniformData("center", 2, this.toFloatBuffer(new double[]{center.x - bounds.x, center.y - bounds.y})));
                uniforms.add(new GLUniformData("size", 2, this.toFloatBuffer(new double[]{bounds.width, bounds.height})));
                uniforms.add(new GLUniformData("maxSamples", 5.0f));
                i = 0;
                while (i < 2) {
                    buffer.setTextureFilter(IVideoBuffer.TextureFilter.LINEAR);
                    buffer = this.support.useShaderProgram(this.getPreprocessProgram(), uniforms, null, new IVideoBuffer[]{buffer});
                    tmpBuffers.add(buffer);
                    ++i;
                }
                uniforms.clear();
                maxSamples = (int)Math.ceil((double)maxSamples / 5.0);
            }
            if (color == null) {
                program = this.getSourceColorProgram();
            } else {
                program = this.getSetColorProgram();
                uniforms.add(new GLUniformData("color", 3, this.toFloatBuffer(new double[]{color.r, color.g, color.b})));
            }
            uniforms.add(new GLUniformData("amount", (float)(rayLength / resolution.scale(200.0))));
            uniforms.add(new GLUniformData("source", 0));
            uniforms.add(new GLUniformData("center", 2, this.toFloatBuffer(new double[]{center.x - bounds.x, center.y - bounds.y})));
            uniforms.add(new GLUniformData("size", 2, this.toFloatBuffer(new double[]{bounds.width, bounds.height})));
            uniforms.add(new GLUniformData("intensity", (float)intensity));
            uniforms.add(new GLUniformData("maxSamples", (float)maxSamples));
            buffer.setTextureFilter(IVideoBuffer.TextureFilter.LINEAR);
            buffer = this.support.useShaderProgram(program, uniforms, null, new IVideoBuffer[]{buffer});
            tmpBuffers.add(buffer);
            source.setTextureFilter(IVideoBuffer.TextureFilter.NEAREST);
            switch (LightBurst.$SWITCH_TABLE$ch$kuramo$javie$effects$stylize$LightBurst$RayComposite()[rayComposite.ordinal()]) {
                case 1: {
                    var19_17 = this.blendSupport.blend(buffer, source, null, blendMode, 1.0, this.context);
                    return var19_17;
                }
                case 2: {
                    var19_18 = this.blendSupport.blend(source, buffer, null, blendMode, 1.0, this.context);
                    return var19_18;
                }
            }
            tmpBuffers.remove(buffer);
            var19_19 = buffer;
            return var19_19;
        }
        finally {
            ** for (vb : tmpBuffers)
        }
lbl-1000:
        // 1 sources

        {
            vb.dispose();
            continue;
        }
lbl79:
        // 1 sources

        return var19_17;
    }

    private FloatBuffer toFloatBuffer(double ... values) {
        float[] array = new float[values.length];
        int i = 0;
        while (i < values.length) {
            array[i] = (float)values[i];
            ++i;
        }
        return FloatBuffer.wrap(array);
    }

    private IShaderProgram getPreprocessProgram() {
        return this.getProgram(true, false);
    }

    private IShaderProgram getSourceColorProgram() {
        return this.getProgram(false, false);
    }

    private IShaderProgram getSetColorProgram() {
        return this.getProgram(false, true);
    }

    private IShaderProgram getProgram(boolean preprocess, boolean setColor) {
        String programName = String.valueOf(LightBurst.class.getName()) + (preprocess ? ".PREPROCESS" : "") + ((setColor &= !preprocess) ? ".SET_COLOR" : "");
        IShaderProgram program = this.shaders.getProgram(programName);
        if (program == null) {
            String[] source = LightBurst.createProgramSource(preprocess, setColor);
            program = this.shaders.registerProgram(programName, ShaderType.FRAGMENT_SHADER, null, source);
        }
        return program;
    }

    private static String[] createProgramSource(boolean preprocess, boolean setColor) {
        boolean p = preprocess;
        boolean c = !preprocess && setColor;
        return new String[]{p ? "#define PREPROCESS" : "", c ? "#define SET_COLOR" : "", "", "uniform sampler2D source;", "uniform float amount;", "uniform vec2 center;", "uniform vec2 size;", "uniform float maxSamples;", "", "#ifndef PREPROCESS", "\tuniform float intensity;", "#endif", "", "#ifdef SET_COLOR", "\tuniform vec3 color;", "#endif", "", "const float PI_0_5 = 3.14159265358979323846264 * 0.5;", "", "void main(void)", "{", "\tvec2 coord = gl_TexCoord[0].st;", "\tvec2 v = center - coord * size;", "\tfloat d = length(v);", "", "\tvec4 srcSum = texture2D(source, coord);", "", "\tif (d > 0.0) {", "\t\tv /= size;", "\t\tint n = 0;", "", "\t\tint   n1 = int(min(amount*d+1.0, maxSamples));", "\t\tfloat rn1 = 1.0/float(n1);", "\t\tvec2  v1 = v*amount*rn1;", "\t\tfor (int i = 1; i <= n1; ++i) {", "#ifdef PREPROCESS", "\t\t\tsrcSum += texture2D(source, coord + v1*float(i));", "#else", "\t\t\tfloat fi = float(i);", "\t\t\tfloat t = 1.0 - fi*rn1;", "\t\t\tsrcSum += texture2D(source, coord + v1*fi) * t;", "#endif", "\t\t}", "\t\tn += n1;", "", "#ifdef PREPROCESS", "\t\tint   n2 = int(min(amount*d+1.0, maxSamples));", "\t\tvec2  v2 = v*amount/float(n2);", "\t\tfor (int i = 1; i <= n2; ++i) {", "\t\t\tsrcSum += texture2D(source, coord - v2*float(i));", "\t\t}", "\t\tn += n2;", "#endif", "", "\t\tsrcSum /= float(n+1);", "\t}", "", "#ifdef PREPROCESS", "\tgl_FragColor = srcSum;", "#else", "", "#ifdef SET_COLOR", "\tfloat lum = dot(srcSum.rgb, vec3(0.299, 0.587, 0.114));", "\tvec4 fc = vec4(color*lum, lum);", "#else", "\tvec4 fc = srcSum;", "#endif", "", "\tgl_FragColor = sin(PI_0_5 * min(fc*2.0*intensity, 1.0));", "#endif", "}"};
    }

    static /* synthetic */ int[] $SWITCH_TABLE$ch$kuramo$javie$effects$stylize$LightBurst$RayComposite() {
        if ($SWITCH_TABLE$ch$kuramo$javie$effects$stylize$LightBurst$RayComposite != null) {
            return $SWITCH_TABLE$ch$kuramo$javie$effects$stylize$LightBurst$RayComposite;
        }
        int[] nArray = new int[RayComposite.values().length];
        try {
            nArray[RayComposite.BEHIND.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RayComposite.ON_TOP.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RayComposite.RAY_ONLY.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$ch$kuramo$javie$effects$stylize$LightBurst$RayComposite = nArray;
        return nArray;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RayComposite {
        ON_TOP,
        BEHIND,
        RAY_ONLY;

    }
}

