/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.jvm;

import com.jogamp.common.impl.Debug;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.HashSet;

public class JNILibLoaderBase {
    public static final boolean DEBUG;
    private static final AccessControlContext localACC;
    private static final HashSet loaded;
    private static LoaderAction loaderAction;
    private static final Class customLauncherClass;
    private static final Method customLoadLibraryMethod;

    public static boolean isLoaded(String libName) {
        return loaded.contains(libName);
    }

    public static void addLoaded(String libName) {
        loaded.add(libName);
        if (DEBUG) {
            System.err.println("JNILibLoaderBase Loaded Native Library: " + libName);
        }
    }

    public static void disableLoading() {
        JNILibLoaderBase.setLoadingAction(null);
    }

    public static void enableLoading() {
        JNILibLoaderBase.setLoadingAction(new DefaultAction());
    }

    public static synchronized void setLoadingAction(LoaderAction action) {
        loaderAction = action;
    }

    protected static synchronized boolean loadLibrary(String libname, boolean ignoreError) {
        if (loaderAction != null) {
            return loaderAction.loadLibrary(libname, ignoreError);
        }
        return false;
    }

    protected static synchronized void loadLibrary(String libname, String[] preload, boolean preloadIgnoreError) {
        if (loaderAction != null) {
            loaderAction.loadLibrary(libname, preload, preloadIgnoreError);
        }
    }

    private static void loadLibraryInternal(String libraryName) {
        if (null != customLoadLibraryMethod && !libraryName.equals("jawt")) {
            try {
                customLoadLibraryMethod.invoke(null, libraryName);
            }
            catch (Exception e) {
                Throwable t = e;
                if (t instanceof InvocationTargetException) {
                    t = ((InvocationTargetException)t).getTargetException();
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw (UnsatisfiedLinkError)new UnsatisfiedLinkError("can not load library " + libraryName).initCause(e);
            }
        } else {
            System.loadLibrary(libraryName);
        }
    }

    static {
        String launcherClassName;
        DEBUG = Debug.debug("JNILibLoader");
        localACC = AccessController.getContext();
        loaded = new HashSet();
        loaderAction = new DefaultAction();
        Class<?> launcherClass = null;
        Method loadLibraryMethod = null;
        if (Debug.getBooleanProperty("sun.jnlp.applet.launcher", false, localACC)) {
            try {
                launcherClass = Class.forName("org.jdesktop.applet.util.JNLPAppletLauncher");
                loadLibraryMethod = launcherClass.getDeclaredMethod("loadLibrary", String.class);
            }
            catch (ClassNotFoundException ex) {
                if (DEBUG) {
                    ex.printStackTrace();
                }
            }
            catch (NoSuchMethodException ex) {
                if (DEBUG) {
                    ex.printStackTrace();
                }
                launcherClass = null;
            }
        }
        if (null == launcherClass && null != (launcherClassName = Debug.getProperty("jnlp.launcher.class", false, localACC))) {
            try {
                launcherClass = Class.forName(launcherClassName);
                loadLibraryMethod = launcherClass.getDeclaredMethod("loadLibrary", String.class);
            }
            catch (ClassNotFoundException ex) {
                if (DEBUG) {
                    ex.printStackTrace();
                }
            }
            catch (NoSuchMethodException ex) {
                if (DEBUG) {
                    ex.printStackTrace();
                }
                launcherClass = null;
            }
        }
        customLauncherClass = launcherClass;
        customLoadLibraryMethod = loadLibraryMethod;
    }

    private static class DefaultAction
    implements LoaderAction {
        private DefaultAction() {
        }

        public boolean loadLibrary(String libname, boolean ignoreError) {
            boolean res;
            block5: {
                res = true;
                if (!JNILibLoaderBase.isLoaded(libname)) {
                    try {
                        JNILibLoaderBase.loadLibraryInternal(libname);
                        JNILibLoaderBase.addLoaded(libname);
                        if (DEBUG) {
                            System.err.println("JNILibLoaderBase loaded " + libname);
                        }
                    }
                    catch (UnsatisfiedLinkError e) {
                        res = false;
                        if (DEBUG) {
                            e.printStackTrace();
                        }
                        if (ignoreError || e.getMessage().indexOf("already loaded") >= 0) break block5;
                        throw e;
                    }
                }
            }
            return res;
        }

        public void loadLibrary(String libname, String[] preload, boolean preloadIgnoreError) {
            if (!JNILibLoaderBase.isLoaded(libname)) {
                if (null != preload) {
                    for (int i = 0; i < preload.length; ++i) {
                        this.loadLibrary(preload[i], preloadIgnoreError);
                    }
                }
                this.loadLibrary(libname, false);
            }
        }
    }

    public static interface LoaderAction {
        public boolean loadLibrary(String var1, boolean var2);

        public void loadLibrary(String var1, String[] var2, boolean var3);
    }
}

