/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app;

import ch.kuramo.javie.app.Activator;
import ch.kuramo.javie.app.Perspective;
import ch.kuramo.javie.app.actions.OpenProjectAction;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.core.Util;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.WeakHashMap;
import net.arnx.jsonic.JSON;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IWorkbenchWindow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecentProjects {
    private static final String RECENT_PROJECTS = "RECENT_PROJECTS";
    private static final IPreferenceStore prefStore = Activator.getDefault().getPreferenceStore();
    private static final WeakHashMap<IWorkbenchWindow, WeakReference<MenuManager>> map = Util.newWeakHashMap();

    public static MenuManager createMenuManager(IWorkbenchWindow window) {
        MenuManager mm = new MenuManager("\u6700\u8fd1\u306e\u30d7\u30ed\u30b8\u30a7\u30af\u30c8\u3092\u958b\u304f");
        map.put(window, new WeakReference<MenuManager>(mm));
        RecentProjects.rebuildMenu(window, mm, RecentProjects.loadEntries());
        return mm;
    }

    public static void add(ProjectManager pm) {
        String path;
        if (pm.getFile() == null) {
            throw new IllegalArgumentException();
        }
        String id = pm.getProject().getId();
        try {
            path = pm.getFile().getCanonicalPath();
        }
        catch (IOException iOException) {
            path = pm.getFile().getAbsolutePath();
        }
        List<List<String>> entries = RecentProjects.loadEntries();
        Iterator<List<String>> it = entries.iterator();
        while (it.hasNext()) {
            List<String> idAndPath = it.next();
            if (!idAndPath.get(1).equals(path)) continue;
            it.remove();
        }
        entries.add(0, Arrays.asList(id, path));
        if (entries.size() > 30) {
            entries = entries.subList(0, 30);
            Perspective.deleteOld(pm.getWorkbenchWindow().getWorkbench(), entries);
        }
        prefStore.setValue(RECENT_PROJECTS, JSON.encode(entries));
        IWorkbenchWindow window = pm.getWorkbenchWindow();
        WeakReference<MenuManager> mmRef = map.get(window);
        MenuManager mm = (MenuManager)mmRef.get();
        if (mm != null) {
            RecentProjects.rebuildMenu(window, mm, entries);
        }
    }

    private static List<List<String>> loadEntries() {
        List list;
        String data = prefStore.getString(RECENT_PROJECTS);
        if (data.length() > 0 && (list = (List)JSON.decode((String)data, List.class)).size() > 0 && list.get(0) instanceof List && ((List)list.get(0)).get(0) instanceof String) {
            List tmp = list;
            return tmp;
        }
        return Util.newList();
    }

    private static void rebuildMenu(final IWorkbenchWindow window, MenuManager mm, List<List<String>> entries) {
        mm.removeAll();
        if (entries.isEmpty()) {
            Action placeholder = new Action("\u6700\u8fd1\u306e\u30d7\u30ed\u30b8\u30a7\u30af\u30c8\u306f\u3042\u308a\u307e\u305b\u3093"){};
            placeholder.setEnabled(false);
            mm.add((IAction)placeholder);
            return;
        }
        if (entries.size() > 10) {
            entries = entries.subList(0, 10);
        }
        for (List<String> idAndPath : entries) {
            String path = idAndPath.get(1);
            final File file = new File(path);
            if (!file.exists() || !file.isFile()) continue;
            mm.add((IAction)new Action(path){

                public void run() {
                    if (file.exists() && file.isFile()) {
                        OpenProjectAction.openProject(window, file);
                    }
                }
            });
        }
    }
}

