/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.actions;

import ch.kuramo.javie.app.widgets.GridBuilder;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

class PrecomposeDialog
extends Dialog {
    private final boolean canLeaveAttrs;
    private boolean leaveAttrs;
    private final String origCompName;
    private String newCompName;

    PrecomposeDialog(Shell parentShell, boolean canLeaveAttrs, String origCompName, String newCompName) {
        super(parentShell);
        this.canLeaveAttrs = canLeaveAttrs;
        this.leaveAttrs = canLeaveAttrs;
        this.origCompName = origCompName;
        this.newCompName = newCompName;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("\u30d7\u30ea\u30b3\u30f3\u30dd\u30fc\u30ba");
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridBuilder gb = new GridBuilder(composite, 2, false);
        gb.getLayout().verticalSpacing = 20;
        gb.hSpan(1).hAlign(131072).label(0, "\u65b0\u898f\u30b3\u30f3\u30dd\u30b8\u30b7\u30e7\u30f3\u540d:");
        final Text compNameText = gb.hSpan(1).hAlign(4).width(300).text(2048, this.newCompName);
        Composite radioGroup = gb.hSpan(2).hAlign(4).composite(0);
        radioGroup.setLayout((Layout)new FillLayout());
        GridBuilder gb2 = new GridBuilder(radioGroup, 1, false);
        Button leaveAttrsRadio = gb2.hSpan(1).hAlign(16384).button(16, String.format("\u3059\u3079\u3066\u306e\u5c5e\u6027\u3092 \u201c%s\u201d \u306b\u6b8b\u3059", this.origCompName));
        Button moveAttrsRadio = gb2.hSpan(1).hAlign(16384).button(16, "\u3059\u3079\u3066\u306e\u5c5e\u6027\u3092\u65b0\u898f\u30b3\u30f3\u30dd\u30b8\u30b7\u30e7\u30f3\u306b\u79fb\u52d5\u3059\u308b");
        leaveAttrsRadio.setEnabled(this.canLeaveAttrs);
        leaveAttrsRadio.setSelection(this.leaveAttrs);
        moveAttrsRadio.setSelection(!this.leaveAttrs);
        compNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PrecomposeDialog.this.newCompName = compNameText.getText().trim();
                Button okButton = PrecomposeDialog.this.getButton(0);
                okButton.setEnabled(PrecomposeDialog.this.newCompName.length() > 0);
            }
        });
        leaveAttrsRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrecomposeDialog.this.leaveAttrs = true;
            }
        });
        moveAttrsRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrecomposeDialog.this.leaveAttrs = false;
            }
        });
        return composite;
    }

    public void create() {
        super.create();
        Button okButton = this.getButton(0);
        okButton.setEnabled(this.newCompName.length() > 0);
    }

    public boolean isLeaveAttrs() {
        return this.leaveAttrs;
    }

    public String getNewCompositionName() {
        return this.newCompName;
    }
}

