/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.player;

import java.util.LinkedHashMap;
import java.util.Map;

class MovingAverage {
    private final LinkedHashMap<Object, Double> map = new LinkedHashMap<Object, Double>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Object, Double> eldest) {
            if (this.size() > MovingAverage.this.numEntries) {
                MovingAverage movingAverage = MovingAverage.this;
                movingAverage.sum = movingAverage.sum - eldest.getValue();
                return true;
            }
            return false;
        }
    };
    private final int numEntries;
    private final int sampleInterval;
    private double sum;
    private volatile double average;
    private int counter;
    private volatile double sampledAverage;

    MovingAverage(int numEntries, int sampleInterval) {
        this.numEntries = numEntries;
        this.sampleInterval = sampleInterval;
    }

    MovingAverage(int numEntries) {
        this(numEntries, 10);
    }

    void add(double value) {
        this.map.put(new Object(), value);
        this.sum += value;
        int size = this.map.size();
        double d = this.average = size < this.numEntries ? Double.NaN : this.sum / (double)size;
        if (this.counter++ % this.sampleInterval == 0) {
            this.sampledAverage = this.average;
        }
    }

    double getAverage() {
        return this.average;
    }

    double getSampledAverage() {
        return this.sampledAverage;
    }

    void reset() {
        this.map.clear();
        this.sum = 0.0;
        this.average = Double.NaN;
        this.counter = 0;
        this.sampledAverage = Double.NaN;
    }
}

