/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.app.PropertyUtil;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.core.AnimatableValue;
import ch.kuramo.javie.core.Composition;
import ch.kuramo.javie.core.Effect;
import ch.kuramo.javie.core.EffectableLayer;
import ch.kuramo.javie.core.JavieRuntimeException;
import ch.kuramo.javie.core.Keyframe;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.MediaInput;
import ch.kuramo.javie.core.MediaItemLayer;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.PropertyDescriptor;
import ch.kuramo.javie.core.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayerSlipOperation
extends ProjectOperation {
    private final String _compId;
    private final Map<String, Time> _startTimes;
    private final List<Entry<?>> _entries;
    private volatile Time _deltaTime;

    public LayerSlipOperation(ProjectManager projectManager, LayerComposition comp, Object[][] layersAndStartTimes, Object[][] keyframeData, Time deltaTime, String relation) {
        super(projectManager, "\u30ec\u30a4\u30e4\u30fc\u6642\u9593\u306e\u5909\u66f4", relation);
        projectManager.checkComposition((Composition)comp);
        this._compId = comp.getId();
        this._deltaTime = this.clampDeltaTime(deltaTime, layersAndStartTimes);
        Map startTimes = null;
        List entries = null;
        if (keyframeData != null) {
            if (this._deltaTime.timeValue != 0L) {
                Layer layer;
                startTimes = Util.newMap();
                Object[][] objectArray = layersAndStartTimes;
                int n = layersAndStartTimes.length;
                int n2 = 0;
                while (n2 < n) {
                    Object[] o = objectArray[n2];
                    layer = (Layer)o[0];
                    startTimes.put(layer.getId(), (Time)o[1]);
                    ++n2;
                }
                entries = Util.newList();
                objectArray = keyframeData;
                n = keyframeData.length;
                n2 = 0;
                while (n2 < n) {
                    Object[] data = objectArray[n2];
                    layer = (Layer)data[0];
                    if (projectManager.checkLayer(layer) != comp) {
                        throw new IllegalArgumentException();
                    }
                    Entry entry = new Entry(layer, data);
                    entries.add(entry);
                    ++n2;
                }
            } else {
                this._noEffect = true;
            }
        }
        this._startTimes = startTimes;
        this._entries = entries;
    }

    private Time clampDeltaTime(Time deltaTime, Object[][] layersAndStartTimes) {
        Object[][] objectArray = layersAndStartTimes;
        int n = layersAndStartTimes.length;
        int n2 = 0;
        while (n2 < n) {
            Time duration;
            MediaInput input;
            Object[] o = objectArray[n2];
            Layer layer = (Layer)o[0];
            if (layer instanceof MediaItemLayer && (input = ((MediaItemLayer)layer).getMediaInput()) != null && (duration = input.getDuration()) != null) {
                Time inPoint = layer.getInPoint();
                Time outPoint = layer.getOutPoint();
                Time startTime = (Time)o[1];
                Time endTime = startTime.add(new Time((long)((double)duration.timeValue / Math.abs(layer.getRate())), duration.timeScale));
                Time t = inPoint.subtract(startTime);
                if (t.before(deltaTime)) {
                    deltaTime = t;
                }
                if ((t = outPoint.subtract(endTime)).after(deltaTime)) {
                    deltaTime = t;
                }
            }
            ++n2;
        }
        return deltaTime;
    }

    @Override
    protected IStatus executeOrRedo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.slip(true, project, pm);
        return Status.OK_STATUS;
    }

    @Override
    protected IStatus undo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.slip(false, project, pm);
        return Status.OK_STATUS;
    }

    private void slip(boolean shift, Project project, ProjectManager pm) throws ExecutionException {
        if (this._startTimes == null || this._entries == null) {
            throw new IllegalStateException();
        }
        LayerComposition comp = (LayerComposition)project.getComposition(this._compId);
        List<Layer> data1 = this.shiftStartTimeOrRestore(shift, pm != null, comp);
        Object[][] data2 = this.shiftKeyframesOrRestore(shift, pm != null, comp);
        if (pm != null) {
            pm.fireLayerSlipEdit(comp, new Object[]{data1, data2});
        }
    }

    private List<Layer> shiftStartTimeOrRestore(boolean shift, boolean createData, LayerComposition comp) {
        List layers = createData ? Util.newList() : null;
        for (Map.Entry<String, Time> e : this._startTimes.entrySet()) {
            Layer layer = comp.getLayer(e.getKey());
            Time startTime = e.getValue();
            layer.setStartTime(shift ? this._deltaTime.add(startTime) : startTime);
            if (!createData) continue;
            layers.add(layer);
        }
        return layers;
    }

    private Object[][] shiftKeyframesOrRestore(boolean shift, boolean createData, LayerComposition comp) throws ExecutionException {
        List data = createData ? Util.newList() : null;
        for (Entry<?> e : this._entries) {
            AnimatableValue avalue;
            Layer layer = comp.getLayer(e.layerId);
            if (e.effectIndex == -1) {
                avalue = (AnimatableValue)PropertyUtil.getProperty(layer, e.property);
            } else {
                AnimatableValue tmp;
                Effect effect = (Effect)((EffectableLayer)layer).getEffects().get(e.effectIndex);
                PropertyDescriptor pd = effect.getEffectDescriptor().getPropertyDescriptor(e.property);
                avalue = tmp = (AnimatableValue)pd.get(effect);
            }
            Entry<?> eo = e;
            List<Time> times = this.shiftKeyframesOrRestore(shift, avalue, eo, createData);
            if (!createData) continue;
            data.add(new Object[]{layer, e.effectIndex, e.property, times});
        }
        return createData ? (Object[][])data.toArray((T[])new Object[data.size()][]) : null;
    }

    private <V> List<Time> shiftKeyframesOrRestore(boolean shift, AnimatableValue<V> avalue, Entry<V> entry, boolean returnTimes) {
        avalue.clearKeyframes(avalue.getStaticValue());
        for (Keyframe kf : entry.restOfKeyframes) {
            avalue.putKeyframe(kf);
        }
        ArrayList<Time> times = returnTimes ? new ArrayList<Time>(entry.keyframesToShift.size()) : null;
        for (Keyframe kf : entry.keyframesToShift) {
            Time time;
            if (shift) {
                time = this._deltaTime.add(kf.time);
                avalue.putKeyframe(new Keyframe(time, kf.value, kf.interpolation));
            } else {
                time = kf.time;
                avalue.putKeyframe(kf);
            }
            if (!returnTimes) continue;
            times.add(time);
        }
        return times;
    }

    @Override
    protected boolean merge(ProjectOperation operation, IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) {
        if (pm == null) {
            try {
                this.executeOrRedo(monitor, info, project, null);
            }
            catch (ExecutionException e) {
                throw new JavieRuntimeException((Throwable)e);
            }
            return true;
        }
        LayerSlipOperation newOp = (LayerSlipOperation)operation;
        if (newOp._startTimes != null || newOp._entries != null) {
            throw new IllegalStateException();
        }
        if (!newOp._deltaTime.equals((Object)this._deltaTime)) {
            this._deltaTime = newOp._deltaTime;
            try {
                this.executeOrRedo(monitor, info, project, pm);
            }
            catch (ExecutionException e) {
                throw new JavieRuntimeException((Throwable)e);
            }
            this._noEffect = this._deltaTime.timeValue == 0L;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry<V> {
        final String layerId;
        final int effectIndex;
        final String property;
        final Set<Keyframe<V>> keyframesToShift;
        final Set<Keyframe<V>> restOfKeyframes;

        Entry(Layer layer, Object[] data) {
            AnimatableValue avalue;
            Set tmp;
            this.layerId = layer.getId();
            this.effectIndex = (Integer)data[1];
            this.property = (String)data[2];
            this.keyframesToShift = tmp = (Set)data[3];
            if (this.effectIndex == -1) {
                avalue = (AnimatableValue)PropertyUtil.getProperty(layer, this.property);
            } else {
                AnimatableValue tmp2;
                Effect effect = (Effect)((EffectableLayer)layer).getEffects().get(this.effectIndex);
                PropertyDescriptor pd = effect.getEffectDescriptor().getPropertyDescriptor(this.property);
                avalue = tmp2 = (AnimatableValue)pd.get(effect);
            }
            this.restOfKeyframes = Util.newSet(avalue.getKeyframeMap().values());
            this.restOfKeyframes.removeAll(this.keyframesToShift);
        }
    }
}

