/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.core.Item;
import ch.kuramo.javie.core.MediaItem;
import ch.kuramo.javie.core.MediaOptions;
import ch.kuramo.javie.core.Project;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ModifyMediaOptionsOperation
extends ProjectOperation {
    private final String itemId;
    private final MediaOptions oldOptions;
    private final MediaOptions newOptions;

    public ModifyMediaOptionsOperation(ProjectManager pm, MediaItem mediaItem, MediaOptions newOptions) {
        super(pm, "\u30e1\u30c7\u30a3\u30a2\u30aa\u30d7\u30b7\u30e7\u30f3\u306e\u5909\u66f4", true);
        pm.checkItem((Item)mediaItem);
        this.itemId = mediaItem.getId();
        this.oldOptions = mediaItem.getMediaOptions();
        this.newOptions = newOptions.clone();
    }

    protected IStatus executeOrRedo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.setOptions(project, pm, this.newOptions);
        return Status.OK_STATUS;
    }

    protected IStatus undo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.setOptions(project, pm, this.oldOptions);
        return Status.OK_STATUS;
    }

    private void setOptions(Project project, ProjectManager pm, MediaOptions options) {
        MediaItem mediaItem = (MediaItem)project.getItem(this.itemId);
        mediaItem.setMediaOptions(options);
        if (pm != null) {
            pm.fireItemUpdate((Item)mediaItem);
        }
    }

    public String getMediaItemId() {
        return this.itemId;
    }
}

