/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.mmd2javie;

import ch.kuramo.javie.api.ColorMode;
import ch.kuramo.javie.api.Size2i;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.api.Vec3d;
import ch.kuramo.javie.core.CameraLayer;
import ch.kuramo.javie.core.Composition;
import ch.kuramo.javie.core.CompositionItem;
import ch.kuramo.javie.core.Interpolation;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.NullLayer;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.services.ProjectElementFactory;
import java.awt.geom.CubicCurve2D;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MMD2Javie2 {
    private static final Logger logger = LoggerFactory.getLogger(MMD2Javie2.class);
    private List<VmdCamera> data;

    MMD2Javie2() {
    }

    boolean readFile(final File file, IRunnableContext rc) {
        block4: {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        MMD2Javie2.this.readFile(file, monitor);
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            logger.info("\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u3092\u958b\u59cb\u3057\u307e\u3057\u305f...");
            rc.run(true, true, runnable);
            if (this.data == null) break block4;
            logger.info("\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u3092\u5b8c\u4e86\u3057\u307e\u3057\u305f");
            return true;
        }
        try {
            logger.info("\u30c7\u30fc\u30bf\u304c\u3042\u308a\u307e\u305b\u3093");
            return false;
        }
        catch (InterruptedException interruptedException) {
            logger.info("\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u3092\u4e2d\u65ad\u3057\u307e\u3057\u305f");
        }
        catch (InvocationTargetException ex) {
            Throwable t = ex.getTargetException();
            logger.error("\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f", t != null ? t : ex);
        }
        return false;
    }

    private void readFile(File file, IProgressMonitor monitor) throws IOException {
        List data = Util.newList();
        monitor.beginTask("\u30d5\u30a1\u30a4\u30eb\u3092\u8aad\u307f\u8fbc\u307f\u4e2d...", -1);
        BufferedInputStream in = null;
        try {
            int count;
            String str;
            in = new BufferedInputStream(new FileInputStream(file));
            byte[] bytes = new byte[26];
            int len = ((InputStream)in).read(bytes);
            if (!(bytes[len - 1] != 0 || !(str = new String(bytes, 0, len - 1, "US-ASCII")).equals("Vocaloid Motion Data 0002") || ((InputStream)in).skip(24L) != 24L || (count = MMD2Javie2.readInt(in)) != 0 && ((InputStream)in).skip(count *= 111) != (long)count || (count = MMD2Javie2.readInt(in)) != 0 && ((InputStream)in).skip(count *= 23) != (long)count || (count = MMD2Javie2.readInt(in)) == 0)) {
                monitor.done();
                monitor.beginTask("\u30d5\u30a1\u30a4\u30eb\u3092\u8aad\u307f\u8fbc\u307f\u4e2d...", count + 1);
                int i = 0;
                while (i < count) {
                    data.add(new VmdCamera(in));
                    monitor.worked(1);
                    ++i;
                }
                Collections.sort(data, new Comparator<VmdCamera>(){

                    @Override
                    public int compare(VmdCamera o1, VmdCamera o2) {
                        return o1.frameNumber - o2.frameNumber;
                    }
                });
                monitor.worked(1);
            }
            this.data = data.isEmpty() ? null : data;
        }
        finally {
            monitor.done();
            if (in != null) {
                ((InputStream)in).close();
            }
        }
    }

    void createCamera(Time frameDuration, double scale, Vec3d offset, Size2i compSize, Project project, ProjectElementFactory elementFactory, IProgressMonitor monitor) throws InterruptedException {
        if (this.data == null) {
            throw new IllegalStateException();
        }
        int frameCount = this.getFrameCount();
        monitor.beginTask("\u30ab\u30e1\u30e9\u30c7\u30fc\u30bf\u3092\u51e6\u7406\u4e2d...", 1 + frameCount);
        try {
            Time duration = Time.fromFrameNumber((long)frameCount, (Time)frameDuration);
            LayerComposition layerComp = elementFactory.newLayerComposition(ColorMode.RGBA8, compSize, frameDuration, duration);
            CompositionItem compItem = elementFactory.newCompositionItem((Composition)layerComp);
            compItem.setName("MMD Camera");
            project.getCompositions().add(layerComp);
            project.getItems().add(compItem);
            NullLayer yNullLayer = elementFactory.newNullLayer();
            this.initLayerTimes((Layer)yNullLayer, frameDuration, duration);
            yNullLayer.setThreeD(true);
            NullLayer xzNullLayer = elementFactory.newNullLayer();
            this.initLayerTimes((Layer)xzNullLayer, frameDuration, duration);
            xzNullLayer.setThreeD(true);
            xzNullLayer.setParentId(yNullLayer.getId());
            CameraLayer cameraLayer = elementFactory.newCameraLayer();
            this.initLayerTimes((Layer)cameraLayer, frameDuration, duration);
            cameraLayer.setParentId(xzNullLayer.getId());
            yNullLayer.setName("MMD Camera [position, rotationY]");
            xzNullLayer.setName("MMD Camera [rotationXZ]");
            cameraLayer.setName("MMD Camera");
            layerComp.getLayers().add(cameraLayer);
            layerComp.getLayers().add(xzNullLayer);
            layerComp.getLayers().add(yNullLayer);
            VmdCamera vmdCamera = this.data.get(0);
            double x = vmdCamera.x * scale + offset.x;
            double y = vmdCamera.y * scale + offset.y;
            double z = vmdCamera.z * scale + offset.z;
            double rx = vmdCamera.rx;
            double ry = vmdCamera.ry;
            double rz = vmdCamera.rz;
            double len = vmdCamera.length * scale;
            double zoom = this.calcZoom(compSize.height, vmdCamera.viewingAngle);
            yNullLayer.getPosition().reset((Object)new Vec3d(x, y, z));
            yNullLayer.getRotationY().reset((Object)Math.toDegrees(ry));
            xzNullLayer.getRotationX().reset((Object)Math.toDegrees(rx));
            xzNullLayer.getRotationZ().reset((Object)Math.toDegrees(rz));
            cameraLayer.getPosition().reset((Object)new Vec3d(0.0, 0.0, len));
            cameraLayer.getZoom().reset((Object)zoom);
            monitor.worked(1);
            Time time = Time.fromFrameNumber((long)vmdCamera.frameNumber, (Time)frameDuration);
            yNullLayer.getPosition().putKeyframe(time, (Object)new Vec3d(x, y, z), Interpolation.LINEAR);
            yNullLayer.getRotationY().putKeyframe(time, (Object)Math.toDegrees(ry), Interpolation.LINEAR);
            xzNullLayer.getRotationX().putKeyframe(time, (Object)Math.toDegrees(rx), Interpolation.LINEAR);
            xzNullLayer.getRotationZ().putKeyframe(time, (Object)Math.toDegrees(rz), Interpolation.LINEAR);
            cameraLayer.getPosition().putKeyframe(time, (Object)new Vec3d(0.0, 0.0, len), Interpolation.LINEAR);
            cameraLayer.getZoom().putKeyframe(time, (Object)zoom, Interpolation.LINEAR);
            monitor.worked(vmdCamera.frameNumber + 1);
            VmdCamera prevCamera = null;
            int k = 0;
            int i = vmdCamera.frameNumber + 1;
            while (i < frameCount) {
                if (monitor.isCanceled()) {
                    throw new InterruptedException("canceled");
                }
                if (vmdCamera.frameNumber < i) {
                    prevCamera = vmdCamera;
                    vmdCamera = this.data.get(++k);
                }
                time = Time.fromFrameNumber((long)i, (Time)frameDuration);
                if (vmdCamera.frameNumber == i) {
                    x = vmdCamera.x * scale + offset.x;
                    y = vmdCamera.y * scale + offset.y;
                    z = vmdCamera.z * scale + offset.z;
                    rx = vmdCamera.rx;
                    ry = vmdCamera.ry;
                    rz = vmdCamera.rz;
                    len = vmdCamera.length * scale;
                    zoom = this.calcZoom(compSize.height, vmdCamera.viewingAngle);
                    yNullLayer.getPosition().putKeyframe(time, (Object)new Vec3d(x, y, z), Interpolation.LINEAR);
                    yNullLayer.getRotationY().putKeyframe(time, (Object)Math.toDegrees(ry), Interpolation.LINEAR);
                    xzNullLayer.getRotationX().putKeyframe(time, (Object)Math.toDegrees(rx), Interpolation.LINEAR);
                    xzNullLayer.getRotationZ().putKeyframe(time, (Object)Math.toDegrees(rz), Interpolation.LINEAR);
                    cameraLayer.getPosition().putKeyframe(time, (Object)new Vec3d(0.0, 0.0, len), Interpolation.LINEAR);
                    cameraLayer.getZoom().putKeyframe(time, (Object)zoom, Interpolation.LINEAR);
                } else {
                    double[][] ip = vmdCamera.interpolations;
                    double t = (double)(i - prevCamera.frameNumber) / (double)(vmdCamera.frameNumber - prevCamera.frameNumber);
                    if (this.isCurve(ip[0]) || this.isCurve(ip[1]) || this.isCurve(ip[2])) {
                        x = this.curve(prevCamera.x, vmdCamera.x, ip[0], t) * scale + offset.x;
                        y = this.curve(prevCamera.y, vmdCamera.y, ip[1], t) * scale + offset.y;
                        z = this.curve(prevCamera.z, vmdCamera.z, ip[2], t) * scale + offset.z;
                        yNullLayer.getPosition().putKeyframe(time, (Object)new Vec3d(x, y, z), Interpolation.LINEAR);
                    }
                    if (this.isCurve(ip[3])) {
                        rx = this.curve(prevCamera.rx, vmdCamera.rx, ip[3], t);
                        ry = this.curve(prevCamera.ry, vmdCamera.ry, ip[3], t);
                        rz = this.curve(prevCamera.rz, vmdCamera.rz, ip[3], t);
                        yNullLayer.getRotationY().putKeyframe(time, (Object)Math.toDegrees(ry), Interpolation.LINEAR);
                        xzNullLayer.getRotationX().putKeyframe(time, (Object)Math.toDegrees(rx), Interpolation.LINEAR);
                        xzNullLayer.getRotationZ().putKeyframe(time, (Object)Math.toDegrees(rz), Interpolation.LINEAR);
                    }
                    if (this.isCurve(ip[4])) {
                        len = this.curve(prevCamera.length, vmdCamera.length, ip[4], t) * scale;
                        cameraLayer.getPosition().putKeyframe(time, (Object)new Vec3d(0.0, 0.0, len), Interpolation.LINEAR);
                    }
                    if (this.isCurve(ip[5])) {
                        double viewingAngle = this.curve(prevCamera.viewingAngle, vmdCamera.viewingAngle, ip[5], t);
                        zoom = this.calcZoom(compSize.height, viewingAngle);
                        cameraLayer.getZoom().putKeyframe(time, (Object)zoom, Interpolation.LINEAR);
                    }
                }
                monitor.worked(1);
                ++i;
            }
        }
        finally {
            monitor.done();
        }
    }

    private void initLayerTimes(Layer layer, Time frameDuration, Time duration) {
        Time time0 = Time.fromFrameNumber((long)0L, (Time)frameDuration);
        layer.setStartTime(time0);
        layer.setInPoint(time0);
        layer.setOutPoint(duration);
    }

    private double calcZoom(int compHeight, double viewingAngle) {
        return (double)compHeight / (2.0 * Math.tan(Math.toRadians(viewingAngle) / 2.0));
    }

    private boolean isCurve(double[] interpolation) {
        return interpolation[0] != interpolation[2] || interpolation[1] != interpolation[3];
    }

    private double curve(double v1, double v2, double[] ip, double t) {
        double[] eqn = new double[]{-t, 3.0 * ip[0], 3.0 * ip[1] - 6.0 * ip[0], 1.0 + 3.0 * ip[0] - 3.0 * ip[1]};
        int n = CubicCurve2D.solveCubic(eqn);
        double p = -1.0;
        int i = 0;
        while (i < n) {
            if (eqn[i] >= 0.0 && eqn[i] <= 1.0) {
                p = eqn[i];
                break;
            }
            ++i;
        }
        if (p == -1.0) {
            return v1 + (v2 - v1) * t;
        }
        double pp = p * p;
        double ppp = pp * p;
        double q = 1.0 - p;
        double qq = q * q;
        return v1 + (v2 - v1) * (3.0 * qq * p * ip[2] + 3.0 * q * pp * ip[3] + ppp);
    }

    public int getFrameCount() {
        return this.data != null ? this.data.get((int)(this.data.size() - 1)).frameNumber + 1 : 0;
    }

    private static byte readByte(InputStream in) throws IOException {
        int b = in.read();
        if (b == -1) {
            throw new EOFException();
        }
        return (byte)b;
    }

    private static int readInt(InputStream in) throws IOException {
        int value = 0;
        int i = 0;
        while (i < 4) {
            int b = in.read();
            if (b == -1) {
                throw new EOFException();
            }
            value += b << i * 8;
            ++i;
        }
        return value;
    }

    private static float readFloat(InputStream in) throws IOException {
        return Float.intBitsToFloat(MMD2Javie2.readInt(in));
    }

    private static boolean readBoolean(InputStream in) throws IOException {
        int b = in.read();
        if (b == -1) {
            throw new EOFException();
        }
        return b != 0;
    }

    private static class VmdCamera {
        final int frameNumber;
        final double length;
        final double x;
        final double y;
        final double z;
        final double rx;
        final double ry;
        final double rz;
        final double[][] interpolations;
        final int viewingAngle;
        final boolean orthographic;

        VmdCamera(InputStream in) throws IOException {
            this.frameNumber = MMD2Javie2.readInt(in);
            this.length = MMD2Javie2.readFloat(in);
            this.x = MMD2Javie2.readFloat(in);
            this.y = -MMD2Javie2.readFloat(in);
            this.z = MMD2Javie2.readFloat(in);
            this.rx = MMD2Javie2.readFloat(in);
            this.ry = -MMD2Javie2.readFloat(in);
            this.rz = MMD2Javie2.readFloat(in);
            this.interpolations = new double[6][4];
            int i = 0;
            while (i < 6) {
                this.interpolations[i][0] = (double)MMD2Javie2.readByte(in) / 127.0;
                this.interpolations[i][1] = (double)MMD2Javie2.readByte(in) / 127.0;
                this.interpolations[i][2] = (double)MMD2Javie2.readByte(in) / 127.0;
                this.interpolations[i][3] = (double)MMD2Javie2.readByte(in) / 127.0;
                ++i;
            }
            this.viewingAngle = MMD2Javie2.readInt(in);
            this.orthographic = MMD2Javie2.readBoolean(in);
        }
    }
}

