/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core;

import ch.kuramo.javie.api.IAnimatableVec2d;
import ch.kuramo.javie.api.Vec2d;
import ch.kuramo.javie.core.ArithmeticalAnimatableValue;
import ch.kuramo.javie.core.CoreContext;
import ch.kuramo.javie.core.Keyframe;
import ch.kuramo.javie.core.expression.ExpressionUtils;
import ch.kuramo.javie.core.expression.Vec2dProperty;
import java.util.Collection;
import org.mozilla.javascript.Scriptable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnimatableVec2d
extends ArithmeticalAnimatableValue<Vec2d>
implements IAnimatableVec2d {
    public AnimatableVec2d(Vec2d staticValue, Collection<Keyframe<Vec2d>> keyframes, String expression) {
        super(staticValue, keyframes, expression, Vec2d.NEGATIVE_INFINITY, Vec2d.POSITIVE_INFINITY);
    }

    public AnimatableVec2d(Vec2d defaultValue) {
        super(defaultValue, Vec2d.NEGATIVE_INFINITY, Vec2d.POSITIVE_INFINITY);
    }

    public AnimatableVec2d(Vec2d defaultValue, Vec2d minValue, Vec2d maxValue) {
        super(defaultValue, minValue, maxValue);
    }

    @Override
    public Vec2d clamp(Vec2d value) {
        return Vec2d.min((Vec2d)Vec2d.max((Vec2d)value, (Vec2d)((Vec2d)this._minValue)), (Vec2d)((Vec2d)this._maxValue));
    }

    @Override
    public Vec2d jsToJava(Object jsValue) {
        Object o = ExpressionUtils.toDoubleOrDoubleArray(jsValue);
        if (o == null) {
            return Vec2d.ZERO;
        }
        if (o instanceof double[]) {
            double[] array = (double[])o;
            if (array.length < 2) {
                double[] tmp = array;
                array = new double[2];
                int i = 0;
                while (i < tmp.length) {
                    array[i] = tmp[i];
                    ++i;
                }
            }
            return this.valueOf(array);
        }
        double d = (Double)o;
        return new Vec2d(d, d);
    }

    @Override
    protected double[] toArray(Vec2d value) {
        return new double[]{value.x, value.y};
    }

    @Override
    protected Vec2d valueOf(double[] d) {
        return new Vec2d(d[0], d[1]);
    }

    public Scriptable createExpressionElement(final CoreContext context) {
        Vec2dProperty v2p = new Vec2dProperty(){

            public Vec2d getValue() {
                return (Vec2d)AnimatableVec2d.this.value(context);
            }

            public Vec2d valueAtTime(double t) {
                return (Vec2d)AnimatableVec2d.this.valueAtTime(t, context);
            }
        };
        return context.toNativeJavaObject(v2p, null);
    }
}

