/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.expression;

import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.Vec2d;
import ch.kuramo.javie.api.Vec3d;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.expression.ColorProperty;
import ch.kuramo.javie.core.expression.Vec2dProperty;
import ch.kuramo.javie.core.expression.Vec3dProperty;
import java.util.LinkedList;
import java.util.Map;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Wrapper;

public class ExpressionUtils {
    private static final String THREAD_LOCAL_STACK = String.valueOf(ExpressionUtils.class.getName()) + ".THREAD_LOCAL_STACK";

    public static void pushThreadLocals(Context context, Object ... keys) {
        LinkedList stack = (LinkedList)context.getThreadLocal((Object)THREAD_LOCAL_STACK);
        if (stack == null) {
            stack = Util.newLinkedList();
            context.putThreadLocal((Object)THREAD_LOCAL_STACK, stack);
        }
        Map<Object, Object> map = Util.newMap();
        Object[] objectArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            Object key = objectArray[n2];
            map.put(key, context.getThreadLocal(key));
            ++n2;
        }
        stack.add(map);
    }

    public static void popThreadLocals(Context context) {
        LinkedList stack = (LinkedList)context.getThreadLocal((Object)THREAD_LOCAL_STACK);
        if (stack == null) {
            throw new IllegalStateException();
        }
        Map map = (Map)stack.removeLast();
        for (Map.Entry e : map.entrySet()) {
            context.putThreadLocal(e.getKey(), e.getValue());
        }
    }

    public static Object toDoubleOrDoubleArray(Object jsValue) {
        if (jsValue instanceof NativeArray) {
            return Context.jsToJava((Object)jsValue, double[].class);
        }
        if (jsValue instanceof Wrapper) {
            Object javaObj = ((Wrapper)jsValue).unwrap();
            if (javaObj instanceof Vec3dProperty) {
                javaObj = ((Vec3dProperty)javaObj).getValue();
            } else if (javaObj instanceof Vec2dProperty) {
                javaObj = ((Vec2dProperty)javaObj).getValue();
            } else if (javaObj instanceof ColorProperty) {
                javaObj = ((ColorProperty)javaObj).getValue();
            }
            if (javaObj instanceof Vec3d) {
                Vec3d v = (Vec3d)javaObj;
                return new double[]{v.x, v.y, v.z};
            }
            if (javaObj instanceof Vec2d) {
                Vec2d v = (Vec2d)javaObj;
                return new double[]{v.x, v.y};
            }
            if (javaObj instanceof Color) {
                Color c = (Color)javaObj;
                return new double[]{c.rawRed, c.rawGreen, c.rawBlue, c.rawAlpha};
            }
            if (javaObj instanceof Object[]) {
                Object[] objArray = (Object[])javaObj;
                double[] dblArray = new double[objArray.length];
                int i = 0;
                while (i < objArray.length) {
                    dblArray[i] = (Double)Context.jsToJava((Object)objArray[i], Double.TYPE);
                    ++i;
                }
                return dblArray;
            }
            jsValue = javaObj;
        }
        if (jsValue == null) {
            return null;
        }
        if (jsValue instanceof double[]) {
            return jsValue;
        }
        return Context.jsToJava((Object)jsValue, Double.TYPE);
    }
}

