/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal;

import ch.kuramo.javie.api.Color;

class HSLUtil {
    HSLUtil() {
    }

    static Color addHSL(Color color, double hue, double sat, double lum) {
        hue = (HSLUtil.hue(color) + hue) % 1.0;
        if (hue < 0.0) {
            hue += 1.0;
        }
        sat = HSLUtil.clamp(HSLUtil.sat(color) + sat, 0.0, 1.0);
        lum = HSLUtil.clamp(HSLUtil.lum(color) + lum, 0.0, 1.0);
        Color tmp = HSLUtil.hsl2rgb(new double[]{hue, 1.0, 0.5});
        return HSLUtil.set_lum(HSLUtil.set_sat(tmp, sat), lum);
    }

    private static double clamp(double value, double a, double b) {
        return Math.min(Math.max(value, Math.min(a, b)), Math.max(a, b));
    }

    private static double min(double a, double b, double c) {
        return Math.min(Math.min(a, b), c);
    }

    private static double max(double a, double b, double c) {
        return Math.max(Math.max(a, b), c);
    }

    private static double sat(Color color) {
        return HSLUtil.max(color.r, color.g, color.b) - HSLUtil.min(color.r, color.g, color.b);
    }

    private static double lum(Color color) {
        return 0.299 * color.r + 0.587 * color.g + 0.114 * color.b;
    }

    private static Color set_sat(Color color, double s) {
        double r = color.r;
        double g = color.g;
        double b = color.b;
        double n = HSLUtil.min(r, g, b);
        double x = HSLUtil.max(r, g, b);
        if (x > n) {
            if (x == r) {
                if (n == g) {
                    b = (b - n) * s / (x - n);
                    g = 0.0;
                } else {
                    g = (g - n) * s / (x - n);
                    b = 0.0;
                }
                r = s;
            } else if (x == g) {
                if (n == b) {
                    r = (r - n) * s / (x - n);
                    b = 0.0;
                } else {
                    b = (b - n) * s / (x - n);
                    r = 0.0;
                }
                g = s;
            } else {
                if (n == r) {
                    g = (g - n) * s / (x - n);
                    r = 0.0;
                } else {
                    r = (r - n) * s / (x - n);
                    g = 0.0;
                }
                b = s;
            }
            return new Color(r, g, b);
        }
        return Color.BLACK;
    }

    private static Color set_lum(Color color, double l) {
        double d = l - HSLUtil.lum(color);
        return HSLUtil.clipColor(color.r + d, color.g + d, color.b + d);
    }

    private static Color clipColor(double r, double g, double b) {
        double x;
        double l = HSLUtil.clamp(0.299 * r + 0.587 * g + 0.114 * b, 0.0, 1.0);
        double n = HSLUtil.min(r, g, b);
        if (n < 0.0) {
            r = l + (r - l) * l / (l - n);
            g = l + (g - l) * l / (l - n);
            b = l + (b - l) * l / (l - n);
        }
        if ((x = HSLUtil.max(r, g, b)) > 1.0) {
            r = l + (r - l) * (1.0 - l) / (x - l);
            g = l + (g - l) * (1.0 - l) / (x - l);
            b = l + (b - l) * (1.0 - l) / (x - l);
        }
        return new Color(r, g, b);
    }

    private static double hue(Color rgb) {
        double min = HSLUtil.min(rgb.r, rgb.g, rgb.b);
        double max = HSLUtil.max(rgb.r, rgb.g, rgb.b);
        double dmax = max - min;
        if (dmax == 0.0) {
            return 0.0;
        }
        double dr = ((max - rgb.r) / 6.0 + dmax / 2.0) / dmax;
        double dg = ((max - rgb.g) / 6.0 + dmax / 2.0) / dmax;
        double db = ((max - rgb.b) / 6.0 + dmax / 2.0) / dmax;
        double hue = rgb.r == max ? db - dg : (rgb.g == max ? 0.3333333333333333 + dr - db : 0.6666666666666666 + dg - dr);
        if ((hue %= 1.0) < 0.0) {
            hue += 1.0;
        }
        return hue;
    }

    private static Color hsl2rgb(double[] hsl) {
        double hue = hsl[0];
        double sat = hsl[1];
        double lum = hsl[2];
        if (sat == 0.0) {
            return new Color(lum, lum, lum);
        }
        double t2 = lum < 0.5 ? lum * (1.0 + sat) : lum + sat - lum * sat;
        double t1 = lum * 2.0 - t2;
        return new Color(HSLUtil.hue2rgb(t1, t2, hue + 0.3333333333333333), HSLUtil.hue2rgb(t1, t2, hue), HSLUtil.hue2rgb(t1, t2, hue - 0.3333333333333333));
    }

    private static double hue2rgb(double t1, double t2, double hue) {
        if ((hue %= 1.0) < 0.0) {
            hue += 1.0;
        }
        return hue * 6.0 < 1.0 ? t1 + (t2 - t1) * 6.0 * hue : (hue * 2.0 < 1.0 ? t2 : (hue * 3.0 < 2.0 ? t1 + (t2 - t1) * (0.6666666666666666 - hue) * 6.0 : t1));
    }
}

