/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal;

import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.api.Vec3d;
import ch.kuramo.javie.core.AnimatableValue;
import ch.kuramo.javie.core.Camera;
import ch.kuramo.javie.core.Light;
import ch.kuramo.javie.core.LightLayer;
import ch.kuramo.javie.core.LightType;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.internal.LayerMatrixUtil;
import ch.kuramo.javie.core.services.RenderContext;
import ch.kuramo.javie.core.services.VideoRenderSupport;
import java.util.Map;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LightImpl
implements Light {
    private final LightLayer layer;
    private final RenderContext context;
    private final VideoRenderSupport oldSupport;
    private final Map<Time, Vec3d> directionCache = Util.newMap();
    private final Map<Time, Vec3d> positionCache = Util.newMap();
    private final Map<AnimatableValue<?>, Map<Time, ?>> valueCache = Util.newMap();

    LightImpl(LightLayer layer, RenderContext context, VideoRenderSupport oldSupport) {
        this.layer = layer;
        this.context = context;
        this.oldSupport = oldSupport;
    }

    private double[] getModelView3D() {
        double[] mvMatrix = new double[16];
        Camera camera = this.context.getCamera();
        System.arraycopy(camera.getModelView3D(), 0, mvMatrix, 0, 16);
        this.oldSupport.setMatrix(null, mvMatrix);
        LayerMatrixUtil.multModelViewMatrix(this.layer, this.context, this.oldSupport);
        this.oldSupport.getMatrix(null, mvMatrix);
        return mvMatrix;
    }

    private <V> V getValue(AnimatableValue<V> avalue) {
        Object value;
        Time time = this.context.getTime();
        Map<Object, Object> map = this.valueCache.get(avalue);
        if (map != null) {
            value = map.get(time);
            if (value != null) {
                return (V)value;
            }
        } else {
            map = Util.newMap();
            this.valueCache.put(avalue, map);
        }
        value = avalue.value(this.context);
        map.put(time, value);
        return (V)value;
    }

    @Override
    public LightType getType() {
        return this.layer.getLightType();
    }

    @Override
    public boolean isCastsShadows() {
        return this.layer.getLightType() != LightType.AMBIENT && this.layer.isCastsShadows();
    }

    @Override
    public Vec3d getDirectionInCameraView() {
        switch (this.layer.getLightType()) {
            case POINT: 
            case AMBIENT: {
                throw new IllegalStateException();
            }
        }
        Time time = this.context.getTime();
        Vec3d dir = this.directionCache.get(time);
        if (dir != null) {
            return dir;
        }
        Point3d p0 = new Point3d();
        Point3d p1 = new Point3d(0.0, 0.0, 1.0);
        Matrix4d m = new Matrix4d(this.getModelView3D());
        m.transpose();
        m.transform(p0);
        m.transform(p1);
        Vector3d v = new Vector3d();
        v.sub((Tuple3d)p1, (Tuple3d)p0);
        v.normalize();
        dir = new Vec3d(v.x, v.y, v.z);
        this.directionCache.put(time, dir);
        return dir;
    }

    @Override
    public Vec3d getPositionInCameraView() {
        switch (this.layer.getLightType()) {
            case PARALLEL: 
            case AMBIENT: {
                throw new IllegalStateException();
            }
        }
        Time time = this.context.getTime();
        Vec3d pos = this.positionCache.get(time);
        if (pos != null) {
            return pos;
        }
        Point3d p = new Point3d();
        Matrix4d m = new Matrix4d(this.getModelView3D());
        m.transpose();
        m.transform(p);
        pos = new Vec3d(p.x, p.y, p.z);
        this.positionCache.put(time, pos);
        return pos;
    }

    @Override
    public double getIntensity() {
        return this.getValue(this.layer.getIntensity());
    }

    @Override
    public Vec3d getAttenuation() {
        switch (this.layer.getLightType()) {
            case SPOT: 
            case POINT: {
                return this.getValue(this.layer.getAttenuation());
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public Color getColor() {
        return this.getValue(this.layer.getColor());
    }

    @Override
    public double getConeAngle() {
        if (this.layer.getLightType() == LightType.SPOT) {
            return this.getValue(this.layer.getConeAngle());
        }
        throw new IllegalStateException();
    }

    @Override
    public double getConeFeather() {
        if (this.layer.getLightType() == LightType.SPOT) {
            return this.getValue(this.layer.getConeFeather());
        }
        throw new IllegalStateException();
    }

    @Override
    public double getShadowDarkness() {
        if (this.isCastsShadows()) {
            return this.getValue(this.layer.getShadowDarkness());
        }
        throw new IllegalStateException();
    }

    @Override
    public double getShadowDiffusion() {
        if (this.isCastsShadows()) {
            if (this.layer.getLightType() == LightType.PARALLEL) {
                return 0.0;
            }
            return this.getValue(this.layer.getShadowDiffusion());
        }
        throw new IllegalStateException();
    }
}

