/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal.services;

import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.ColorMode;
import ch.kuramo.javie.api.services.IAntiAliasSupport;
import ch.kuramo.javie.core.services.GLGlobal;
import ch.kuramo.javie.core.services.RenderContext;
import com.google.inject.Inject;
import javax.media.opengl.GL2;

public class AntiAliasSupportImpl
implements IAntiAliasSupport {
    private static final boolean MACOSX = System.getProperty("os.name").toLowerCase().replaceAll("\\s+", "").contains("macosx");
    private final RenderContext context;
    private final int samples;
    private int frameBuffer;
    private final int[] renderBuffer = new int[2];
    private final int[] internalFormat = new int[2];
    private final int[] width = new int[2];
    private final int[] height = new int[2];
    private static final float[] FLOAT0000 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};

    @Inject
    public AntiAliasSupportImpl(RenderContext context, GLGlobal glGlobal) {
        this.context = context;
        int samples = Math.min(glGlobal.getMaxSamples(), 8);
        this.samples = samples > 0 ? samples : 0;
    }

    void dispose() {
        GL2 gl = this.context.getGL().getGL2();
        int i = 0;
        while (i < 2) {
            this.internalFormat[i] = 0;
            this.width[i] = 0;
            this.height[i] = 0;
            if (this.renderBuffer[i] != 0) {
                gl.glDeleteRenderbuffers(1, new int[]{this.renderBuffer[i]}, 0);
                this.renderBuffer[i] = 0;
            }
            ++i;
        }
        if (this.frameBuffer != 0) {
            gl.glDeleteFramebuffers(1, new int[]{this.frameBuffer}, 0);
            this.frameBuffer = 0;
        }
    }

    private int getFrameBuffer(GL2 gl) {
        if (this.frameBuffer == 0) {
            int[] fb = new int[1];
            gl.glGenFramebuffers(1, fb, 0);
            this.frameBuffer = fb[0];
        }
        return this.frameBuffer;
    }

    private int getRenderBuffer(GL2 gl, int i, int internalFormat, int width, int height) {
        if (this.renderBuffer[i] == 0) {
            int[] rb = new int[1];
            gl.glGenRenderbuffers(1, rb, 0);
            this.renderBuffer[i] = rb[0];
        }
        if (internalFormat != this.internalFormat[i] || width != this.width[i] || height != this.height[i]) {
            gl.glBindRenderbuffer(36161, this.renderBuffer[i]);
            gl.glRenderbufferStorageMultisample(36161, this.samples, internalFormat, width, height);
            this.internalFormat[i] = internalFormat;
            this.width[i] = width;
            this.height[i] = height;
        }
        return this.renderBuffer[i];
    }

    private int getColorRenderBuffer(GL2 gl, int width, int height) {
        width = Math.max(width, this.width[0]);
        height = Math.max(height, this.height[0]);
        return this.getRenderBuffer(gl, 0, this.context.getColorMode().glInternalFormat, width, height);
    }

    private int getDepthRenderBuffer(GL2 gl) {
        int internalFormat = this.context.getColorMode() == ColorMode.RGBA32_FLOAT ? 33191 : 6402;
        return this.getRenderBuffer(gl, 1, internalFormat, this.width[0], this.height[0]);
    }

    private void clear(GL2 gl, boolean clearDepth, Color clearColor) {
        int bits = 0;
        if (clearDepth) {
            gl.glClearDepth(1.0);
            bits |= 0x100;
        }
        if (clearColor != null) {
            float a = (float)clearColor.a;
            float r = (float)clearColor.r * a;
            float g = (float)clearColor.g * a;
            float b = (float)clearColor.b * a;
            gl.glClearColor(r, g, b, a);
            bits |= 0x4000;
        }
        if (bits != 0) {
            gl.glClear(bits);
        }
    }

    public void antiAlias(int width, int height, boolean depthTest, Color clearColor, Runnable operation) {
        if (width <= 0 || height <= 0) {
            return;
        }
        if (this.samples == 0) {
            this.runWithoutRenderbuffer(width, height, depthTest, clearColor, operation);
            return;
        }
        GL2 gl = this.context.getGL().getGL2();
        int[] current = new int[3];
        gl.glGetIntegerv(36006, current, 0);
        gl.glGetIntegerv(36010, current, 1);
        gl.glGetIntegerv(36007, current, 2);
        try {
            int fb = this.getFrameBuffer(gl);
            gl.glBindFramebuffer(36009, fb);
            gl.glPushAttrib(0x4000 | (depthTest ? 8448 : 0));
            try {
                gl.glFramebufferRenderbuffer(36009, 36064, 36161, this.getColorRenderBuffer(gl, width, height));
                gl.glDrawBuffer(36064);
                if (depthTest) {
                    gl.glFramebufferRenderbuffer(36009, 36096, 36161, this.getDepthRenderBuffer(gl));
                    gl.glEnable(2929);
                } else if (MACOSX && this.renderBuffer[1] != 0) {
                    gl.glFramebufferRenderbuffer(36009, 36096, 36161, this.getDepthRenderBuffer(gl));
                }
                this.clear(gl, depthTest, clearColor);
                operation.run();
                gl.glBindFramebuffer(36008, fb);
                gl.glBindFramebuffer(36009, current[0]);
                gl.glBlitFramebuffer(0, 0, width, height, 0, 0, width, height, 16384, 9728);
            }
            finally {
                gl.glFramebufferRenderbuffer(36009, 36096, 36161, 0);
                gl.glFramebufferRenderbuffer(36009, 36064, 36161, 0);
                gl.glPopAttrib();
            }
        }
        finally {
            gl.glBindRenderbuffer(36161, current[2]);
            gl.glBindFramebuffer(36008, current[1]);
            gl.glBindFramebuffer(36009, current[0]);
        }
    }

    public void antiAlias(int width, int height, Runnable operation) {
        this.antiAlias(width, height, false, Color.COLORLESS_TRANSPARENT, operation);
    }

    private void runWithoutRenderbuffer(int width, int height, boolean depthTest, Color clearColor, Runnable operation) {
        GL2 gl = this.context.getGL().getGL2();
        int depthTexture = 0;
        gl.glPushAttrib(0x4000 | (depthTest ? 8448 : 0));
        try {
            if (depthTest) {
                depthTexture = this.createDepthTexture(gl, width, height);
                gl.glFramebufferTexture2D(36160, 36096, 3553, depthTexture, 0);
                gl.glEnable(2929);
            }
            this.clear(gl, depthTest, clearColor);
            operation.run();
        }
        catch (Throwable throwable) {
            if (depthTest) {
                gl.glFramebufferTexture2D(36160, 36096, 3553, 0, 0);
                if (depthTexture != 0) {
                    gl.glDeleteTextures(1, new int[]{depthTexture}, 0);
                }
            }
            gl.glPopAttrib();
            throw throwable;
        }
        if (depthTest) {
            gl.glFramebufferTexture2D(36160, 36096, 3553, 0, 0);
            if (depthTexture != 0) {
                gl.glDeleteTextures(1, new int[]{depthTexture}, 0);
            }
        }
        gl.glPopAttrib();
    }

    private int createDepthTexture(GL2 gl, int width, int height) {
        int internalFormat = this.context.getColorMode() == ColorMode.RGBA32_FLOAT ? 33191 : 6402;
        int[] texture = new int[1];
        int[] current = new int[1];
        gl.glGetIntegerv(32873, current, 0);
        try {
            gl.glGenTextures(1, texture, 0);
            gl.glBindTexture(3553, texture[0]);
            gl.glTexParameteri(3553, 10241, 9728);
            gl.glTexParameteri(3553, 10240, 9728);
            gl.glTexParameteri(3553, 10242, 33069);
            gl.glTexParameteri(3553, 10243, 33069);
            gl.glTexParameterfv(3553, 4100, FLOAT0000, 0);
            gl.glTexImage2D(3553, 0, internalFormat, Math.max(1, width), Math.max(1, height), 0, 6402, 5126, null);
            int result = texture[0];
            texture[0] = 0;
            int n = result;
            return n;
        }
        finally {
            gl.glBindTexture(3553, current[0]);
            if (texture[0] != 0) {
                gl.glDeleteTextures(1, texture, 0);
            }
        }
    }

    public int getSamples() {
        return this.samples;
    }
}

