/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal.services;

import java.lang.reflect.Array;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ArrayPool<T> {
    private static final Logger _logger = LoggerFactory.getLogger(ArrayPool.class);
    private static final int MAX_QUEUE_SIZE = 16;
    private static final int[] ARRAY_LENGTHS = new int[]{4096, 16384, 65536, 262144, 524288, 0x100000, 0x200000, 0x400000, 0x800000, 0x1000000};
    private final Class<?> _componentType;
    private final ConcurrentHashMap<Integer, PoolQueue> _map = new ConcurrentHashMap();

    ArrayPool(Class<?> componentType) {
        this._componentType = componentType;
    }

    private T newArray(int length) {
        return (T)Array.newInstance(this._componentType, length);
    }

    private PoolQueue getQueue(int length) {
        Integer key = length;
        if (!this._map.containsKey(key)) {
            this._map.putIfAbsent(key, new PoolQueue(length));
        }
        return this._map.get(key);
    }

    T get(int length) {
        int i = 0;
        while (i < ARRAY_LENGTHS.length) {
            int n = ARRAY_LENGTHS[i];
            if (length <= n) {
                return (T)this.getQueue(n).get();
            }
            ++i;
        }
        _logger.warn(String.format("length is too big to pool: %s[%d]", this._componentType.getName(), length));
        return this.newArray(length);
    }

    void put(T array) {
        if (array == null) {
            return;
        }
        int length = Array.getLength(array);
        int i = 0;
        while (i < ARRAY_LENGTHS.length) {
            if (length == ARRAY_LENGTHS[i]) {
                this.getQueue(length).put(array);
                return;
            }
            ++i;
        }
        if (length <= ARRAY_LENGTHS[ARRAY_LENGTHS.length - 1]) {
            throw new IllegalArgumentException("array length does not match: " + length);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PoolQueue {
        private final int _length;
        private final ConcurrentLinkedQueue<T> _queue = new ConcurrentLinkedQueue();
        private final AtomicInteger _count = new AtomicInteger();

        private PoolQueue(int length) {
            this._length = length;
        }

        private T get() {
            Object array = this._queue.poll();
            if (array != null) {
                this._count.decrementAndGet();
            } else {
                array = ArrayPool.this.newArray(this._length);
                _logger.info(String.format("new array created: %s[%d]", ArrayPool.this._componentType.getName(), this._length));
            }
            return array;
        }

        private void put(T array) {
            if (this._count.get() < 16) {
                this._queue.add(array);
                this._count.incrementAndGet();
            } else {
                _logger.info(String.format("queue is reached to max size: %s[%d]", ArrayPool.this._componentType.getName(), this._length));
            }
        }
    }
}

