/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal.services;

import ch.kuramo.javie.core.MediaSource;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.internal.JavaImageSource;
import ch.kuramo.javie.core.internal.JavaSoundSource;
import ch.kuramo.javie.core.services.MediaSourceFactory;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaSourceFactoryImpl
implements MediaSourceFactory {
    private static final Logger _logger = LoggerFactory.getLogger(MediaSourceFactoryImpl.class);
    private final List<Class<? extends MediaSource>> _sourceClasses = Util.newList();
    private final Map<String, Entry> _entries = Util.newMap();
    @Inject
    private Injector _injector;

    public MediaSourceFactoryImpl() {
        Class<MediaSource> clazz = this.classForName("ch.kuramo.javie.core.internal.MacOSXQTCoreVideoSource");
        if (clazz != null) {
            this._sourceClasses.add(JavaImageSource.class);
            this._sourceClasses.add(JavaSoundSource.class);
            this._sourceClasses.add(clazz);
        } else {
            clazz = this.classForName("ch.kuramo.javie.core.internal.WindowsDirectShowSource");
            if (clazz != null) {
                this._sourceClasses.add(JavaImageSource.class);
                this._sourceClasses.add(JavaSoundSource.class);
                this._sourceClasses.add(clazz);
            } else {
                _logger.warn("only JavaImageSource and JavaSoundSource are available");
                this._sourceClasses.add(JavaImageSource.class);
                this._sourceClasses.add(JavaSoundSource.class);
            }
        }
    }

    private Class<MediaSource> classForName(String className) {
        try {
            Class<MediaSource> clazz = Class.forName(className);
            return clazz;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Override
    public synchronized MediaSource get(String key, File file) {
        Entry entry = this._entries.get(key);
        if (entry != null) {
            ++entry.counter;
            return entry.source;
        }
        LinkedHashMap<Class<? extends MediaSource>, Throwable> throwables = Util.newLinkedHashMap();
        for (Class<? extends MediaSource> clazz : this._sourceClasses) {
            MediaSource source;
            block6: {
                try {
                    source = (MediaSource)this._injector.getInstance(clazz);
                    if (!source.initialize(file)) {
                        source.dispose();
                    }
                    break block6;
                }
                catch (Throwable t) {
                    throwables.put(clazz, t);
                }
                continue;
            }
            this._entries.put(key, new Entry(source));
            return source;
        }
        for (Map.Entry entry2 : throwables.entrySet()) {
            _logger.info(String.format("failed to create MediaSource (%s): %s: %s", ((Class)entry2.getKey()).getName(), file.getAbsolutePath(), ((Throwable)entry2.getValue()).toString()));
        }
        return null;
    }

    @Override
    public synchronized <T extends MediaSource> T get(Class<T> sourceClass, String key, File file) {
        Entry entry = this._entries.get(key);
        if (entry != null) {
            ++entry.counter;
            return (T)((MediaSource)sourceClass.cast(entry.source));
        }
        try {
            MediaSource source = (MediaSource)this._injector.getInstance(sourceClass);
            if (source.initialize(file)) {
                this._entries.put(key, new Entry(source));
                return (T)source;
            }
            source.dispose();
        }
        catch (Throwable t) {
            _logger.info(String.format("failed to create MediaSource (%s): %s: %s", sourceClass.getName(), file.getAbsolutePath(), t.toString()));
        }
        return null;
    }

    @Override
    public synchronized void release(String key) {
        Entry entry = this._entries.get(key);
        if (--entry.counter == 0) {
            this._entries.remove(key);
            entry.source.dispose();
        }
    }

    private static class Entry {
        int counter = 1;
        final MediaSource source;

        Entry(MediaSource source) {
            this.source = source;
        }
    }
}

