/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.nio;

import com.jogamp.common.nio.AbstractLongBuffer;
import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.common.os.Platform;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;

final class PointerBufferME_CDC_FP
extends PointerBuffer {
    private IntBuffer pb;

    PointerBufferME_CDC_FP(ByteBuffer bb) {
        super(bb);
        this.pb = bb.asIntBuffer();
    }

    public final long get(int idx) {
        if (0 > idx || idx >= this.capacity) {
            throw new IndexOutOfBoundsException();
        }
        if (Platform.is32Bit()) {
            return (long)this.pb.get(idx) & 0xFFFFFFFFL;
        }
        long lo = 0xFFFFFFFFL & (long)this.pb.get(idx <<= 1);
        long hi = 0xFFFFFFFFL & (long)this.pb.get(idx + 1);
        if (Platform.isLittleEndian()) {
            return hi << 32 | lo;
        }
        return lo << 32 | hi;
    }

    public final AbstractLongBuffer put(int idx, long v) {
        if (0 > idx || idx >= this.capacity) {
            throw new IndexOutOfBoundsException();
        }
        this.backup[idx] = v;
        if (Platform.is32Bit()) {
            this.pb.put(idx, (int)v);
        } else {
            idx <<= 1;
            int lo = (int)(v & 0xFFFFFFFFL);
            int hi = (int)(v >> 32 & 0xFFFFFFFFL);
            if (Platform.isLittleEndian()) {
                this.pb.put(idx, lo);
                this.pb.put(idx + 1, hi);
            } else {
                this.pb.put(idx, hi);
                this.pb.put(idx + 1, lo);
            }
        }
        return this;
    }
}

