/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.os;

import com.jogamp.common.jvm.JNILibLoaderBase;
import com.jogamp.common.os.DynamicLibraryBundleInfo;
import com.jogamp.common.os.DynamicLookupHelper;
import com.jogamp.common.os.NativeLibrary;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class DynamicLibraryBundle
implements DynamicLookupHelper {
    protected static final boolean DEBUG = NativeLibrary.DEBUG;
    protected static final boolean DEBUG_LOOKUP = NativeLibrary.DEBUG_LOOKUP;
    private DynamicLibraryBundleInfo info;
    private List toolLibNames;
    private boolean[] toolLibLoaded;
    private int toolLibLoadedNumber;
    protected List nativeLibraries;
    private List glueLibNames;
    private boolean[] glueLibLoaded;
    private int glueLibLoadedNumber;
    private long toolGetProcAddressHandle;
    private HashSet toolGetProcAddressFuncNameSet;
    private List toolGetProcAddressFuncNameList;

    public DynamicLibraryBundle(DynamicLibraryBundleInfo info) {
        if (null == info) {
            throw new RuntimeException("Null DynamicLibraryBundleInfo");
        }
        this.info = info;
        if (DEBUG) {
            System.out.println("DynamicLibraryBundle.init start with: " + info.getClass().getName());
        }
        this.nativeLibraries = new ArrayList();
        this.toolLibNames = info.getToolLibNames();
        this.glueLibNames = info.getGlueLibNames();
        this.loadLibraries();
        this.toolGetProcAddressFuncNameList = info.getToolGetProcAddressFuncNameList();
        if (null != this.toolGetProcAddressFuncNameList) {
            this.toolGetProcAddressFuncNameSet = new HashSet(this.toolGetProcAddressFuncNameList);
            this.toolGetProcAddressHandle = this.getToolGetProcAddressHandle();
        } else {
            this.toolGetProcAddressFuncNameSet = new HashSet();
            this.toolGetProcAddressHandle = 0L;
        }
        if (DEBUG) {
            System.out.println("DynamicLibraryBundle.init Summary: " + info.getClass().getName());
            System.out.println("     toolGetProcAddressFuncNameList: " + this.toolGetProcAddressFuncNameList);
            System.out.println("     Tool Lib Names : " + this.toolLibNames);
            System.out.println("     Tool Lib Loaded: " + this.getToolLibLoadedNumber() + "/" + this.getToolLibNumber() + ", complete " + this.isToolLibComplete());
            System.out.println("     Glue Lib Names : " + this.glueLibNames);
            System.out.println("     Glue Lib Loaded: " + this.getGlueLibLoadedNumber() + "/" + this.getGlueLibNumber() + ", complete " + this.isGlueLibComplete());
            System.out.println("     All Complete: " + this.isLibComplete());
        }
    }

    public final boolean isLibComplete() {
        return this.isToolLibComplete() && this.isGlueLibComplete();
    }

    public final int getToolLibNumber() {
        return this.toolLibNames.size();
    }

    public final int getToolLibLoadedNumber() {
        return this.toolLibLoadedNumber;
    }

    public final boolean isToolLibComplete() {
        return this.getToolLibNumber() == this.getToolLibLoadedNumber();
    }

    public final boolean isToolLibLoaded() {
        return 0 < this.toolLibLoadedNumber;
    }

    public final boolean isToolLibLoaded(int i) {
        if (0 <= i && i < this.toolLibLoaded.length) {
            return this.toolLibLoaded[i];
        }
        return false;
    }

    public final int getGlueLibNumber() {
        return this.glueLibNames.size();
    }

    public final int getGlueLibLoadedNumber() {
        return this.glueLibLoadedNumber;
    }

    public final boolean isGlueLibComplete() {
        return this.getGlueLibNumber() == this.getGlueLibLoadedNumber();
    }

    public final boolean isGlueLibLoaded(int i) {
        if (0 <= i && i < this.glueLibLoaded.length) {
            return this.glueLibLoaded[i];
        }
        return false;
    }

    public final DynamicLibraryBundleInfo getBundleInfo() {
        return this.info;
    }

    protected long getToolGetProcAddressHandle() {
        if (!this.isToolLibLoaded()) {
            return 0L;
        }
        long aptr = 0L;
        Iterator iter = this.toolGetProcAddressFuncNameList.iterator();
        while (0L == aptr && iter.hasNext()) {
            String name = (String)iter.next();
            aptr = this.dynamicLookupFunctionOnLibs(name);
            if (!DEBUG) continue;
            System.out.println("getToolGetProcAddressHandle: " + name + " -> 0x" + Long.toHexString(aptr));
        }
        return aptr;
    }

    protected NativeLibrary loadFirstAvailable(List libNames, ClassLoader loader, boolean global) {
        Iterator iter = libNames.iterator();
        while (iter.hasNext()) {
            NativeLibrary lib = NativeLibrary.open((String)iter.next(), loader, global);
            if (lib == null) continue;
            return lib;
        }
        return null;
    }

    private void loadLibraries() {
        int i;
        if (null == this.toolLibNames || this.toolLibNames.size() == 0) {
            if (DEBUG) {
                System.out.println("No Tool native library names given");
            }
            return;
        }
        if (null == this.glueLibNames || this.glueLibNames.size() == 0) {
            if (DEBUG) {
                System.out.println("No Glue native library names given");
            }
            return;
        }
        this.toolLibLoadedNumber = 0;
        this.toolLibLoaded = new boolean[this.toolLibNames.size()];
        for (i = 0; i < this.toolLibNames.size(); ++i) {
            this.toolLibLoaded[i] = false;
        }
        this.glueLibLoaded = new boolean[this.glueLibNames.size()];
        for (i = 0; i < this.glueLibNames.size(); ++i) {
            this.glueLibLoaded[i] = false;
        }
        ClassLoader loader = this.getClass().getClassLoader();
        NativeLibrary lib = null;
        i = 0;
        Iterator iter = this.toolLibNames.iterator();
        while (iter.hasNext()) {
            Object listObj = iter.next();
            ArrayList<String> libNames = null;
            if (listObj instanceof List) {
                libNames = (ArrayList<String>)listObj;
            } else if (listObj instanceof String) {
                libNames = new ArrayList<String>();
                libNames.add((String)listObj);
            } else {
                throw new RuntimeException("List element " + i + " must be either a List or String: " + this.toolLibNames);
            }
            if (null != libNames && libNames.size() > 0) {
                lib = this.loadFirstAvailable(libNames, loader, this.info.shallLinkGlobal());
                if (null == lib) {
                    if (DEBUG) {
                        System.out.println("Unable to load any Tool library of: " + libNames);
                    }
                } else {
                    this.nativeLibraries.add(lib);
                    this.toolLibLoaded[i] = true;
                    ++this.toolLibLoadedNumber;
                    if (DEBUG) {
                        System.out.println("Loaded Tool library: " + lib);
                    }
                }
            }
            ++i;
        }
        if (!this.isToolLibLoaded()) {
            if (DEBUG) {
                System.out.println("No Tool libraries loaded");
            }
            return;
        }
        this.glueLibLoadedNumber = 0;
        i = 0;
        iter = this.glueLibNames.iterator();
        while (iter.hasNext()) {
            boolean res;
            block23: {
                String libName = (String)iter.next();
                boolean ignoreError = true;
                try {
                    res = GlueJNILibLoaderBase.loadLibrary(libName, ignoreError);
                    if (DEBUG && !res) {
                        System.out.println("Info: Could not load JNI/Glue library: " + libName);
                    }
                }
                catch (UnsatisfiedLinkError e) {
                    res = false;
                    if (!DEBUG) break block23;
                    System.out.println("Unable to load JNI/Glue library: " + libName);
                    e.printStackTrace();
                }
            }
            this.glueLibLoaded[i] = res;
            if (res) {
                ++this.glueLibLoadedNumber;
            }
            ++i;
        }
    }

    private long dynamicLookupFunctionOnLibs(String funcName) {
        if (!this.isToolLibLoaded() || null == funcName) {
            if (DEBUG_LOOKUP && !this.isToolLibLoaded()) {
                System.err.println("Lookup-Native: <" + funcName + "> ** FAILED ** Tool native library not loaded");
            }
            return 0L;
        }
        long addr = 0L;
        NativeLibrary lib = null;
        if (this.info.shallLookupGlobal()) {
            addr = NativeLibrary.dynamicLookupFunctionGlobal(funcName);
        }
        Iterator iter = this.nativeLibraries.iterator();
        while (0L == addr && iter.hasNext()) {
            lib = (NativeLibrary)iter.next();
            addr = lib.dynamicLookupFunction(funcName);
        }
        if (DEBUG_LOOKUP) {
            String libName;
            String string = libName = null == lib ? "GLOBAL" : lib.toString();
            if (0L != addr) {
                System.err.println("Lookup-Native: <" + funcName + "> 0x" + Long.toHexString(addr) + " in lib " + libName);
            } else {
                System.err.println("Lookup-Native: <" + funcName + "> ** FAILED ** in libs " + this.nativeLibraries);
            }
        }
        return addr;
    }

    public long dynamicLookupFunction(String funcName) {
        if (!this.isToolLibLoaded() || null == funcName) {
            if (DEBUG_LOOKUP && !this.isToolLibLoaded()) {
                System.err.println("Lookup: <" + funcName + "> ** FAILED ** Tool native library not loaded");
            }
            return 0L;
        }
        if (this.toolGetProcAddressFuncNameSet.contains(funcName)) {
            return this.toolGetProcAddressHandle;
        }
        long addr = 0L;
        if (0L != this.toolGetProcAddressHandle) {
            addr = this.info.toolDynamicLookupFunction(this.toolGetProcAddressHandle, funcName);
            if (DEBUG_LOOKUP && 0L != addr) {
                System.err.println("Lookup-Tool: <" + funcName + "> 0x" + Long.toHexString(addr));
            }
        }
        if (0L == addr) {
            addr = this.dynamicLookupFunctionOnLibs(funcName);
        }
        return addr;
    }

    static class GlueJNILibLoaderBase
    extends JNILibLoaderBase {
        GlueJNILibLoaderBase() {
        }

        protected static synchronized boolean loadLibrary(String libname, boolean ignoreError) {
            return JNILibLoaderBase.loadLibrary(libname, ignoreError);
        }
    }
}

