/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import com.jogamp.common.GlueGenVersion;
import com.jogamp.common.os.Platform;
import com.jogamp.common.util.VersionUtil;
import java.util.Iterator;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class JogampVersion {
    public static Attributes.Name IMPLEMENTATION_BRANCH = new Attributes.Name("Implementation-Branch");
    public static Attributes.Name IMPLEMENTATION_COMMIT = new Attributes.Name("Implementation-Commit");
    private String packageName;
    private Manifest mf;
    private int hash;
    private Attributes mainAttributes;
    private Set mainAttributeNames;

    protected JogampVersion(String packageName, Manifest mf) {
        this.packageName = packageName;
        this.mf = mf;
        this.hash = mf.hashCode();
        this.mainAttributes = mf.getMainAttributes();
        this.mainAttributeNames = this.mainAttributes.keySet();
    }

    public final int hashCode() {
        return this.hash;
    }

    public final boolean equals(Object o) {
        if (o instanceof JogampVersion) {
            return this.mf.equals(((JogampVersion)o).getManifest());
        }
        return false;
    }

    public final Manifest getManifest() {
        return this.mf;
    }

    public final String getPackageName() {
        return this.packageName;
    }

    public final String getAttribute(Attributes.Name attributeName) {
        return null != attributeName ? (String)this.mainAttributes.get(attributeName) : null;
    }

    public final String getAttribute(String attributeName) {
        return this.getAttribute(this.getAttributeName(attributeName));
    }

    public final Attributes.Name getAttributeName(String attributeName) {
        Iterator iter = this.mainAttributeNames.iterator();
        while (iter.hasNext()) {
            Attributes.Name an = (Attributes.Name)iter.next();
            if (!an.toString().equals(attributeName)) continue;
            return an;
        }
        return null;
    }

    public final Set getAttributeNames() {
        return this.mainAttributeNames;
    }

    public final String getExtensionName() {
        return this.getAttribute(Attributes.Name.EXTENSION_NAME);
    }

    public final String getImplementationBranch() {
        return this.getAttribute(GlueGenVersion.IMPLEMENTATION_BRANCH);
    }

    public final String getImplementationCommit() {
        return this.getAttribute(GlueGenVersion.IMPLEMENTATION_COMMIT);
    }

    public final String getImplementationTitle() {
        return this.getAttribute(Attributes.Name.IMPLEMENTATION_TITLE);
    }

    public final String getImplementationVendor() {
        return this.getAttribute(Attributes.Name.IMPLEMENTATION_VENDOR);
    }

    public final String getImplementationVendorID() {
        return this.getAttribute(Attributes.Name.IMPLEMENTATION_VENDOR_ID);
    }

    public final String getImplementationURL() {
        return this.getAttribute(Attributes.Name.IMPLEMENTATION_URL);
    }

    public final String getImplementationVersion() {
        return this.getAttribute(Attributes.Name.IMPLEMENTATION_VERSION);
    }

    public final String getSpecificationTitle() {
        return this.getAttribute(Attributes.Name.SPECIFICATION_TITLE);
    }

    public final String getSpecificationVendor() {
        return this.getAttribute(Attributes.Name.SPECIFICATION_VENDOR);
    }

    public final String getSpecificationVersion() {
        return this.getAttribute(Attributes.Name.SPECIFICATION_VERSION);
    }

    public final StringBuffer getFullManifestInfo(StringBuffer sb) {
        return VersionUtil.getFullManifestInfo(this.getManifest(), sb);
    }

    public StringBuffer getManifestInfo(StringBuffer sb) {
        if (null == sb) {
            sb = new StringBuffer();
        }
        String nl = Platform.getNewline();
        sb.append("Package: ").append(this.getPackageName()).append(nl);
        sb.append("Extension Name: ").append(this.getExtensionName()).append(nl);
        sb.append("Specification Title: ").append(this.getSpecificationTitle()).append(nl);
        sb.append("Specification Vendor: ").append(this.getSpecificationVendor()).append(nl);
        sb.append("Specification Version: ").append(this.getSpecificationVersion()).append(nl);
        sb.append("Implementation Title: ").append(this.getImplementationTitle()).append(nl);
        sb.append("Implementation Vendor: ").append(this.getImplementationVendor()).append(nl);
        sb.append("Implementation Vendor ID: ").append(this.getImplementationVendorID()).append(nl);
        sb.append("Implementation URL: ").append(this.getImplementationURL()).append(nl);
        sb.append("Implementation Version: ").append(this.getImplementationVersion()).append(nl);
        sb.append("Implementation Branch: ").append(this.getImplementationBranch()).append(nl);
        sb.append("Implementation Commit: ").append(this.getImplementationCommit()).append(nl);
        return sb;
    }

    public StringBuffer toString(StringBuffer sb) {
        if (null == sb) {
            sb = new StringBuffer();
        }
        sb.append("-----------------------------------------------------------------------------------------------------").append(Platform.getNewline());
        this.getManifestInfo(sb);
        sb.append("-----------------------------------------------------------------------------------------------------");
        return sb;
    }

    public String toString() {
        return this.toString(null).toString();
    }
}

