/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.impl;

import com.jogamp.common.util.locks.RecursiveLock;
import com.jogamp.opengl.impl.GLContextImpl;
import com.jogamp.opengl.impl.GLDrawableHelper;
import com.jogamp.opengl.impl.GLDrawableImpl;
import javax.media.nativewindow.NativeSurface;
import javax.media.opengl.GL;
import javax.media.opengl.GLAnimatorControl;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLException;
import javax.media.opengl.GLPbuffer;
import javax.media.opengl.GLProfile;
import javax.media.opengl.GLRunnable;

public class GLPbufferImpl
implements GLPbuffer {
    private GLDrawableImpl pbufferDrawable;
    private GLContextImpl context;
    private GLDrawableHelper drawableHelper = new GLDrawableHelper();
    private int floatMode;
    DisposeAction disposeAction = new DisposeAction();
    private RecursiveLock recurLock = new RecursiveLock();
    private InitAction initAction = new InitAction();
    private DisplayAction displayAction = new DisplayAction();
    private SwapBuffersAction swapBuffersAction = new SwapBuffersAction();

    public GLPbufferImpl(GLDrawableImpl gLDrawableImpl, GLContext gLContext) {
        GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)gLDrawableImpl.getNativeSurface().getGraphicsConfiguration().getNativeGraphicsConfiguration().getChosenCapabilities();
        if (gLCapabilitiesImmutable.isOnscreen()) {
            if (gLCapabilitiesImmutable.isPBuffer()) {
                throw new IllegalArgumentException("Error: Given drawable is Onscreen and Pbuffer: " + gLDrawableImpl);
            }
            throw new IllegalArgumentException("Error: Given drawable is Onscreen: " + gLDrawableImpl);
        }
        if (!gLCapabilitiesImmutable.isPBuffer()) {
            throw new IllegalArgumentException("Error: Given drawable is not Pbuffer: " + gLDrawableImpl);
        }
        this.pbufferDrawable = gLDrawableImpl;
        this.context = (GLContextImpl)gLDrawableImpl.createContext(gLContext);
        this.context.setSynchronized(true);
    }

    public GLContext createContext(GLContext gLContext) {
        return this.pbufferDrawable.createContext(gLContext);
    }

    public void setRealized(boolean bl) {
    }

    public boolean isRealized() {
        return true;
    }

    public void destroy() {
        if (null != this.context) {
            try {
                this.drawableHelper.invokeGL(this.pbufferDrawable, this.context, this.disposeAction, null);
            }
            catch (GLException gLException) {
                gLException.printStackTrace();
            }
            this.drawableHelper.reset();
            this.context.destroy();
        }
        this.pbufferDrawable.destroy();
    }

    public void setSize(int n, int n2) {
        throw new GLException("Not yet implemented");
    }

    public NativeSurface getNativeSurface() {
        return this.pbufferDrawable.getNativeSurface();
    }

    public long getHandle() {
        return this.pbufferDrawable.getHandle();
    }

    public GLDrawableFactory getFactory() {
        return this.pbufferDrawable.getFactory();
    }

    public int getWidth() {
        return this.pbufferDrawable.getWidth();
    }

    public int getHeight() {
        return this.pbufferDrawable.getHeight();
    }

    public void display() {
        this.invokeGL(this.displayAction);
    }

    public void repaint() {
        this.display();
    }

    public void addGLEventListener(GLEventListener gLEventListener) {
        this.drawableHelper.addGLEventListener(gLEventListener);
    }

    public void addGLEventListener(int n, GLEventListener gLEventListener) {
        this.drawableHelper.addGLEventListener(n, gLEventListener);
    }

    public void removeGLEventListener(GLEventListener gLEventListener) {
        this.drawableHelper.removeGLEventListener(gLEventListener);
    }

    public void setAnimator(GLAnimatorControl gLAnimatorControl) {
        this.drawableHelper.setAnimator(gLAnimatorControl);
    }

    public GLAnimatorControl getAnimator() {
        return this.drawableHelper.getAnimator();
    }

    public void invoke(boolean bl, GLRunnable gLRunnable) {
        this.drawableHelper.invoke(this, bl, gLRunnable);
    }

    public void setContext(GLContext gLContext) {
        this.context = (GLContextImpl)gLContext;
    }

    public GLContext getContext() {
        return this.context;
    }

    public GLDrawable getDrawable() {
        return this.pbufferDrawable;
    }

    public GL getGL() {
        return this.getContext().getGL();
    }

    public GL setGL(GL gL) {
        return this.getContext().setGL(gL);
    }

    public void setAutoSwapBufferMode(boolean bl) {
        this.drawableHelper.setAutoSwapBufferMode(bl);
    }

    public boolean getAutoSwapBufferMode() {
        return this.drawableHelper.getAutoSwapBufferMode();
    }

    public void swapBuffers() {
        this.invokeGL(this.swapBuffersAction);
    }

    public void bindTexture() {
        this.context.bindPbufferToTexture();
    }

    public void releaseTexture() {
        this.context.releasePbufferFromTexture();
    }

    public GLCapabilitiesImmutable getChosenGLCapabilities() {
        if (this.pbufferDrawable == null) {
            return null;
        }
        return this.pbufferDrawable.getChosenGLCapabilities();
    }

    public GLCapabilitiesImmutable getRequestedGLCapabilities() {
        if (this.pbufferDrawable == null) {
            return null;
        }
        return this.pbufferDrawable.getRequestedGLCapabilities();
    }

    public GLProfile getGLProfile() {
        if (this.pbufferDrawable == null) {
            return null;
        }
        return this.pbufferDrawable.getGLProfile();
    }

    public int lockSurface() throws GLException {
        this.recurLock.lock();
        return 3;
    }

    public void unlockSurface() {
        this.recurLock.unlock();
    }

    public boolean isSurfaceLocked() {
        return this.recurLock.isLocked();
    }

    public Throwable getLockedStack() {
        return this.recurLock.getLockedStack();
    }

    public int getFloatingPointMode() {
        if (this.floatMode == 0) {
            throw new GLException("Pbuffer not initialized, or floating-point support not requested");
        }
        return this.floatMode;
    }

    private void invokeGL(Runnable runnable) {
        this.drawableHelper.invokeGL(this.pbufferDrawable, this.context, runnable, this.initAction);
    }

    class SwapBuffersAction
    implements Runnable {
        SwapBuffersAction() {
        }

        public void run() {
            GLPbufferImpl.this.pbufferDrawable.swapBuffers();
        }
    }

    class DisplayAction
    implements Runnable {
        DisplayAction() {
        }

        public void run() {
            GLPbufferImpl.this.drawableHelper.display(GLPbufferImpl.this);
        }
    }

    class InitAction
    implements Runnable {
        InitAction() {
        }

        public void run() {
            GLPbufferImpl.this.floatMode = GLPbufferImpl.this.context.getFloatingPointMode();
            GLPbufferImpl.this.drawableHelper.init(GLPbufferImpl.this);
        }
    }

    class DisposeAction
    implements Runnable {
        DisposeAction() {
        }

        public void run() {
            GLPbufferImpl.this.drawableHelper.dispose(GLPbufferImpl.this);
        }
    }
}

