/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.impl.glu.nurbs;

public class Knotvector {
    public static final float TOLERANCE = 1.0E-5f;
    private static final int MAXORDER = 24;
    int knotcount;
    int stride;
    int order;
    float[] knotlist;

    public Knotvector(int n, int n2, int n3, float[] fArray) {
        this.init(n, n2, n3, fArray);
    }

    public void init(int n, int n2, int n3, float[] fArray) {
        this.knotcount = n;
        this.stride = n2;
        this.order = n3;
        this.knotlist = new float[n];
        for (int i = 0; i < n; ++i) {
            this.knotlist[i] = fArray[i];
        }
    }

    public int validate() {
        int n;
        int n2 = this.knotcount - 1;
        if (this.order < 1 || this.order > 24) {
            return 1;
        }
        if (this.knotcount < 2 * this.order) {
            return 2;
        }
        if (Knotvector.identical(this.knotlist[n2 - (this.order - 1)], this.knotlist[this.order - 1])) {
            return 3;
        }
        for (n = 0; n < n2; ++n) {
            if (!(this.knotlist[n] > this.knotlist[n + 1])) continue;
            return 4;
        }
        n = 1;
        while (n2 >= 1) {
            if (this.knotlist[n2] - this.knotlist[n2 - 1] < 1.0E-5f) {
                ++n;
            } else {
                if (n > this.order) {
                    return 5;
                }
                n = 1;
            }
            --n2;
        }
        if (n > this.order) {
            return 5;
        }
        return 0;
    }

    public void show(String string) {
    }

    public static boolean identical(float f, float f2) {
        return f - f2 < 1.0E-5f;
    }
}

