/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.impl.macosx.cgl;

import com.jogamp.gluegen.runtime.ProcAddressTable;
import com.jogamp.gluegen.runtime.opengl.GLProcAddressResolver;
import com.jogamp.opengl.impl.GLContextImpl;
import com.jogamp.opengl.impl.GLContextShareSet;
import com.jogamp.opengl.impl.GLDrawableImpl;
import com.jogamp.opengl.impl.macosx.cgl.CGL;
import com.jogamp.opengl.impl.macosx.cgl.CGLExt;
import com.jogamp.opengl.impl.macosx.cgl.CGLExtImpl;
import com.jogamp.opengl.impl.macosx.cgl.CGLExtProcAddressTable;
import com.jogamp.opengl.impl.macosx.cgl.MacOSXCGLGraphicsConfiguration;
import java.nio.ByteBuffer;
import java.util.Map;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.DefaultGraphicsConfiguration;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;

public abstract class MacOSXCGLContext
extends GLContextImpl {
    protected boolean isNSContext;
    private CGLExt cglExt;
    private CGLExtProcAddressTable cglExtProcAddressTable;

    protected MacOSXCGLContext(GLDrawableImpl gLDrawableImpl, GLContext gLContext) {
        super(gLDrawableImpl, gLContext);
    }

    public Object getPlatformGLExtensions() {
        return this.getCGLExt();
    }

    protected boolean isNSContext() {
        return this.isNSContext;
    }

    public CGLExt getCGLExt() {
        if (this.cglExt == null) {
            this.cglExt = new CGLExtImpl(this);
        }
        return this.cglExt;
    }

    public final ProcAddressTable getPlatformExtProcAddressTable() {
        return this.getCGLExtProcAddressTable();
    }

    public final CGLExtProcAddressTable getCGLExtProcAddressTable() {
        return this.cglExtProcAddressTable;
    }

    protected Map getFunctionNameMap() {
        return null;
    }

    protected Map getExtensionNameMap() {
        return null;
    }

    protected long createContextARBImpl(long l, boolean bl, int n, int n2, int n3) {
        return 0L;
    }

    protected void destroyContextARBImpl(long l) {
    }

    public final boolean isGLReadDrawableAvailable() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean create(boolean bl, boolean bl2) {
        MacOSXCGLGraphicsConfiguration macOSXCGLGraphicsConfiguration;
        GLCapabilitiesImmutable gLCapabilitiesImmutable;
        GLProfile gLProfile;
        MacOSXCGLContext macOSXCGLContext = (MacOSXCGLContext)GLContextShareSet.getShareContext(this);
        long l = 0L;
        if (macOSXCGLContext != null) {
            if (!macOSXCGLContext.isNSContext()) {
                throw new GLException("GLContextShareSet is not a NS Context");
            }
            l = macOSXCGLContext.getHandle();
            if (l == 0L) {
                throw new GLException("GLContextShareSet returned a NULL OpenGL context");
            }
        }
        if ((gLProfile = (gLCapabilitiesImmutable = (GLCapabilitiesImmutable)(macOSXCGLGraphicsConfiguration = (MacOSXCGLGraphicsConfiguration)this.drawable.getNativeSurface().getGraphicsConfiguration().getNativeGraphicsConfiguration()).getRequestedCapabilities()).getGLProfile()).isGL3()) {
            throw new GLException("GL3 profile currently not supported on MacOSX, due to the lack of a OpenGL 3.1 implementation");
        }
        GLCapabilities gLCapabilities = (GLCapabilities)gLCapabilitiesImmutable.cloneMutable();
        gLCapabilities.setPBuffer(bl);
        gLCapabilities.setPbufferFloatingPointBuffers(bl2);
        long l2 = MacOSXCGLGraphicsConfiguration.GLCapabilities2NSPixelFormat(gLCapabilities);
        if (l2 == 0L) {
            throw new GLException("Unable to allocate pixel format with requested GLCapabilities");
        }
        macOSXCGLGraphicsConfiguration.setChosenPixelFormat(l2);
        try {
            int[] nArray = new int[1];
            this.contextHandle = CGL.createContext(l, this.drawable.getHandle(), l2, nArray, 0);
            if (this.contextHandle == 0L) {
                if (nArray[0] == 1) {
                    if (DEBUG) {
                        System.err.println("!!! View not ready for " + this.getClass().getName());
                    }
                    boolean bl3 = false;
                    return bl3;
                }
                throw new GLException("Error creating NSOpenGLContext with requested pixel format");
            }
            if (!bl && !gLCapabilities.isBackgroundOpaque()) {
                CGL.setContextOpacity(this.contextHandle, 0);
            }
            GLCapabilitiesImmutable gLCapabilitiesImmutable2 = MacOSXCGLGraphicsConfiguration.NSPixelFormat2GLCapabilities(gLProfile, l2);
            macOSXCGLGraphicsConfiguration.setChosenCapabilities(gLCapabilitiesImmutable2);
        }
        finally {
            CGL.deletePixelFormat(l2);
        }
        if (!CGL.makeCurrentContext(this.contextHandle)) {
            throw new GLException("Error making Context (NS) current");
        }
        this.isNSContext = true;
        this.setGLFunctionAvailability(true, 0, 0, 34);
        GLContextShareSet.contextCreated(this);
        return true;
    }

    protected void makeCurrentImpl(boolean bl) throws GLException {
        if (this.isNSContext) {
            if (!CGL.makeCurrentContext(this.contextHandle)) {
                throw new GLException("Error making Context (NS) current");
            }
        } else if (0 != CGL.CGLSetCurrentContext(this.contextHandle)) {
            throw new GLException("Error making Context (CGL) current");
        }
    }

    protected void releaseImpl() throws GLException {
        if (this.isNSContext) {
            if (!CGL.clearCurrentContext(this.contextHandle)) {
                throw new GLException("Error freeing OpenGL Context (NS)");
            }
        } else {
            CGL.CGLReleaseContext(this.contextHandle);
        }
    }

    protected void destroyImpl() throws GLException {
        if (!this.isNSContext) {
            if (0 != CGL.CGLDestroyContext(this.contextHandle)) {
                throw new GLException("Unable to delete OpenGL Context (CGL)");
            }
            if (DEBUG) {
                System.err.println("!!! Destroyed OpenGL Context (CGL) " + this.contextHandle);
            }
        } else {
            if (!CGL.deleteContext(this.contextHandle)) {
                throw new GLException("Unable to delete OpenGL Context (NS)");
            }
            if (DEBUG) {
                System.err.println("!!! Destroyed OpenGL Context (NS) " + this.contextHandle);
            }
        }
    }

    protected void copyImpl(GLContext gLContext, int n) throws GLException {
        long l = this.getHandle();
        long l2 = gLContext.getHandle();
        if (!this.isNSContext()) {
            if (((MacOSXCGLContext)gLContext).isNSContext()) {
                throw new GLException("Source OpenGL Context is NS ; Destination Context is CGL.");
            }
            CGL.CGLCopyContext(l2, l, n);
        } else {
            if (!((MacOSXCGLContext)gLContext).isNSContext()) {
                throw new GLException("Source OpenGL Context is CGL ; Destination Context is NS.");
            }
            CGL.copyContext(l, l2, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void updateGLXProcAddressTable() {
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = this.drawable.getNativeSurface().getGraphicsConfiguration().getNativeGraphicsConfiguration();
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsConfiguration.getScreen().getDevice();
        String string = abstractGraphicsDevice.getUniqueID();
        if (DEBUG) {
            System.err.println(MacOSXCGLContext.getThreadName() + ": !!! Initializing CGL extension address table: " + string);
        }
        CGLExtProcAddressTable cGLExtProcAddressTable = null;
        Object object = mappedContextTypeObjectLock;
        synchronized (object) {
            cGLExtProcAddressTable = (CGLExtProcAddressTable)((Object)mappedGLXProcAddress.get(string));
        }
        if (null != cGLExtProcAddressTable) {
            this.cglExtProcAddressTable = cGLExtProcAddressTable;
            if (DEBUG) {
                System.err.println(MacOSXCGLContext.getThreadName() + ": !!! GLContext CGL ProcAddressTable reusing key(" + string + ") -> " + ((Object)((Object)cGLExtProcAddressTable)).hashCode());
            }
        } else {
            if (this.cglExtProcAddressTable == null) {
                this.cglExtProcAddressTable = new CGLExtProcAddressTable(new GLProcAddressResolver());
            }
            this.resetProcAddressTable(this.getCGLExtProcAddressTable());
            object = mappedContextTypeObjectLock;
            synchronized (object) {
                mappedGLXProcAddress.put(string, this.getCGLExtProcAddressTable());
                if (DEBUG) {
                    System.err.println(MacOSXCGLContext.getThreadName() + ": !!! GLContext CGL ProcAddressTable mapping key(" + string + ") -> " + ((Object)((Object)this.getCGLExtProcAddressTable())).hashCode());
                }
            }
        }
    }

    public String getPlatformExtensionsString() {
        return "";
    }

    protected void swapBuffers() {
        DefaultGraphicsConfiguration defaultGraphicsConfiguration = (DefaultGraphicsConfiguration)this.drawable.getNativeSurface().getGraphicsConfiguration().getNativeGraphicsConfiguration();
        GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)defaultGraphicsConfiguration.getChosenCapabilities();
        if (gLCapabilitiesImmutable.isOnscreen()) {
            if (this.isNSContext) {
                if (!CGL.flushBuffer(this.contextHandle)) {
                    throw new GLException("Error swapping buffers (NS)");
                }
            } else if (0 != CGL.CGLFlushDrawable(this.contextHandle)) {
                throw new GLException("Error swapping buffers (CGL)");
            }
        }
    }

    protected void setSwapIntervalImpl(int n) {
        if (!this.isCreated()) {
            throw new GLException("OpenGL context not created");
        }
        if (this.isNSContext) {
            CGL.setSwapInterval(this.contextHandle, n);
        } else {
            int[] nArray = new int[]{n};
            CGL.CGLSetParameter(this.contextHandle, 222, nArray, 0);
        }
        this.currentSwapInterval = n;
    }

    public ByteBuffer glAllocateMemoryNV(int n, float f, float f2, float f3) {
        throw new GLException("Not yet implemented");
    }

    public boolean isExtensionAvailable(String string) {
        if (string.equals("GL_ARB_pbuffer") || string.equals("GL_ARB_pixel_format")) {
            return true;
        }
        return super.isExtensionAvailable(string);
    }

    public int getOffscreenContextPixelDataType() {
        throw new GLException("Should not call this");
    }

    public int getOffscreenContextReadBuffer() {
        throw new GLException("Should not call this");
    }

    public boolean offscreenImageNeedsVerticalFlip() {
        throw new GLException("Should not call this");
    }

    public void bindPbufferToTexture() {
        throw new GLException("Should not call this");
    }

    public void releasePbufferFromTexture() {
        throw new GLException("Should not call this");
    }

    public abstract void setOpenGLMode(int var1);

    public abstract int getOpenGLMode();
}

