/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.impl.windows.wgl;

import com.jogamp.nativewindow.impl.windows.GDI;
import com.jogamp.nativewindow.impl.windows.PIXELFORMATDESCRIPTOR;
import com.jogamp.opengl.impl.Debug;
import com.jogamp.opengl.impl.GLGraphicsConfigurationFactoryImpl;
import com.jogamp.opengl.impl.windows.wgl.WindowsWGLContext;
import com.jogamp.opengl.impl.windows.wgl.WindowsWGLDrawable;
import com.jogamp.opengl.impl.windows.wgl.WindowsWGLDrawableFactory;
import com.jogamp.opengl.impl.windows.wgl.WindowsWGLGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.CapabilitiesChooser;
import javax.media.nativewindow.CapabilitiesImmutable;
import javax.media.nativewindow.DefaultGraphicsScreen;
import javax.media.nativewindow.GraphicsConfigurationFactory;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.windows.WindowsGraphicsDevice;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;

public class WindowsWGLGraphicsConfigurationFactory
extends GLGraphicsConfigurationFactoryImpl {
    protected static final boolean DEBUG = Debug.debug("GraphicsConfiguration");

    WindowsWGLGraphicsConfigurationFactory() {
        GraphicsConfigurationFactory.registerFactory((Class)WindowsGraphicsDevice.class, (GraphicsConfigurationFactory)this);
    }

    protected AbstractGraphicsConfiguration chooseGraphicsConfigurationImpl(CapabilitiesImmutable capabilitiesImmutable, CapabilitiesImmutable capabilitiesImmutable2, CapabilitiesChooser capabilitiesChooser, AbstractGraphicsScreen abstractGraphicsScreen) {
        if (!(capabilitiesImmutable instanceof GLCapabilitiesImmutable)) {
            throw new IllegalArgumentException("This NativeWindowFactory accepts only GLCapabilities objects - chosen");
        }
        if (!(capabilitiesImmutable2 instanceof GLCapabilitiesImmutable)) {
            throw new IllegalArgumentException("This NativeWindowFactory accepts only GLCapabilities objects - requested");
        }
        return WindowsWGLGraphicsConfigurationFactory.chooseGraphicsConfigurationStatic((GLCapabilitiesImmutable)capabilitiesImmutable, (GLCapabilitiesImmutable)capabilitiesImmutable2, capabilitiesChooser, abstractGraphicsScreen);
    }

    static WindowsWGLGraphicsConfiguration createDefaultGraphicsConfiguration(GLCapabilitiesImmutable gLCapabilitiesImmutable, AbstractGraphicsScreen abstractGraphicsScreen) {
        return WindowsWGLGraphicsConfigurationFactory.chooseGraphicsConfigurationStatic(gLCapabilitiesImmutable, gLCapabilitiesImmutable, null, abstractGraphicsScreen);
    }

    static WindowsWGLGraphicsConfiguration chooseGraphicsConfigurationStatic(GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesImmutable gLCapabilitiesImmutable2, CapabilitiesChooser capabilitiesChooser, AbstractGraphicsScreen abstractGraphicsScreen) {
        if (null == abstractGraphicsScreen) {
            abstractGraphicsScreen = DefaultGraphicsScreen.createDefault((String)"Windows");
        }
        if (!gLCapabilitiesImmutable.isOnscreen() && gLCapabilitiesImmutable.getDoubleBuffered()) {
            GLCapabilities gLCapabilities = (GLCapabilities)gLCapabilitiesImmutable.cloneMutable();
            gLCapabilities.setDoubleBuffered(false);
            gLCapabilitiesImmutable = gLCapabilities;
        }
        return new WindowsWGLGraphicsConfiguration(abstractGraphicsScreen, gLCapabilitiesImmutable, gLCapabilitiesImmutable2, (GLCapabilitiesChooser)capabilitiesChooser);
    }

    static void updateGraphicsConfiguration(CapabilitiesChooser capabilitiesChooser, GLDrawableFactory gLDrawableFactory, NativeSurface nativeSurface, int[] nArray) {
        if (capabilitiesChooser != null && !(capabilitiesChooser instanceof GLCapabilitiesChooser)) {
            throw new IllegalArgumentException("This NativeWindowFactory accepts only GLCapabilitiesChooser objects");
        }
        if (gLDrawableFactory == null) {
            throw new IllegalArgumentException("GLDrawableFactory is null");
        }
        if (nativeSurface == null) {
            throw new IllegalArgumentException("NativeSurface is null");
        }
        long l = nativeSurface.getSurfaceHandle();
        if (0L == l) {
            throw new GLException("Error: HDC is null");
        }
        WindowsWGLGraphicsConfiguration windowsWGLGraphicsConfiguration = (WindowsWGLGraphicsConfiguration)nativeSurface.getGraphicsConfiguration().getNativeGraphicsConfiguration();
        if (!windowsWGLGraphicsConfiguration.isDetermined()) {
            WindowsWGLGraphicsConfigurationFactory.updateGraphicsConfiguration(windowsWGLGraphicsConfiguration, capabilitiesChooser, gLDrawableFactory, l, false, nArray);
        } else {
            int n = -1;
            boolean bl = false;
            n = GDI.GetPixelFormat((long)l);
            if (1 > n) {
                if (!GDI.SetPixelFormat((long)l, (int)windowsWGLGraphicsConfiguration.getPixelFormatID(), (PIXELFORMATDESCRIPTOR)windowsWGLGraphicsConfiguration.getPixelFormat())) {
                    throw new GLException("Unable to set pixel format " + windowsWGLGraphicsConfiguration.getPixelFormatID() + " for device context " + WindowsWGLGraphicsConfigurationFactory.toHexString(l) + ": error code " + GDI.GetLastError());
                }
                bl = true;
                n = windowsWGLGraphicsConfiguration.getPixelFormatID();
            }
            if (DEBUG) {
                System.err.println("!!! setPixelFormat (post): hdc " + WindowsWGLGraphicsConfigurationFactory.toHexString(l) + ", " + windowsWGLGraphicsConfiguration.getPixelFormatID() + " -> " + n + ", set: " + bl);
                Thread.dumpStack();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void preselectGraphicsConfiguration(CapabilitiesChooser capabilitiesChooser, GLDrawableFactory gLDrawableFactory, AbstractGraphicsDevice abstractGraphicsDevice, WindowsWGLGraphicsConfiguration windowsWGLGraphicsConfiguration, int[] nArray) {
        if (capabilitiesChooser != null && !(capabilitiesChooser instanceof GLCapabilitiesChooser)) {
            throw new IllegalArgumentException("This NativeWindowFactory accepts only GLCapabilitiesChooser objects");
        }
        if (gLDrawableFactory == null) {
            throw new IllegalArgumentException("GLDrawableFactory is null");
        }
        if (windowsWGLGraphicsConfiguration == null) {
            throw new IllegalArgumentException("WindowsWGLGraphicsConfiguration is null");
        }
        WindowsWGLDrawableFactory windowsWGLDrawableFactory = (WindowsWGLDrawableFactory)gLDrawableFactory;
        WindowsWGLDrawable windowsWGLDrawable = windowsWGLDrawableFactory.getSharedDrawable(abstractGraphicsDevice);
        if (null == windowsWGLDrawable) {
            throw new IllegalArgumentException("Shared Drawable is null");
        }
        windowsWGLDrawable.lockSurface();
        try {
            long l = windowsWGLDrawable.getHandle();
            if (0L == l) {
                throw new GLException("Error: HDC is null");
            }
            WindowsWGLGraphicsConfigurationFactory.updateGraphicsConfiguration(windowsWGLGraphicsConfiguration, capabilitiesChooser, windowsWGLDrawableFactory, l, true, nArray);
        }
        finally {
            windowsWGLDrawable.unlockSurface();
        }
    }

    private static void updateGraphicsConfiguration(WindowsWGLGraphicsConfiguration windowsWGLGraphicsConfiguration, CapabilitiesChooser capabilitiesChooser, GLDrawableFactory gLDrawableFactory, long l, boolean bl, int[] nArray) {
        if (DEBUG) {
            if (bl) {
                System.err.println("updateGraphicsConfiguration(using shared): hdc " + WindowsWGLGraphicsConfigurationFactory.toHexString(l));
            } else {
                System.err.println("updateGraphicsConfiguration(using target): hdc " + WindowsWGLGraphicsConfigurationFactory.toHexString(l));
            }
            System.err.println("!!! user chosen caps " + windowsWGLGraphicsConfiguration.getChosenCapabilities());
        }
        if (!WindowsWGLGraphicsConfigurationFactory.updateGraphicsConfigurationARB(l, bl, windowsWGLGraphicsConfiguration, capabilitiesChooser, (WindowsWGLDrawableFactory)gLDrawableFactory, nArray)) {
            WindowsWGLGraphicsConfigurationFactory.updateGraphicsConfigurationGDI(l, bl, windowsWGLGraphicsConfiguration, capabilitiesChooser, nArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean updateGraphicsConfigurationARB(long l, boolean bl, WindowsWGLGraphicsConfiguration windowsWGLGraphicsConfiguration, CapabilitiesChooser capabilitiesChooser, WindowsWGLDrawableFactory windowsWGLDrawableFactory, int[] nArray) {
        int n;
        AbstractGraphicsDevice abstractGraphicsDevice = windowsWGLGraphicsConfiguration.getScreen().getDevice();
        WindowsWGLContext windowsWGLContext = (WindowsWGLContext)windowsWGLDrawableFactory.getOrCreateSharedContextImpl(abstractGraphicsDevice);
        if (null == windowsWGLContext) {
            if (DEBUG) {
                System.err.println("updateGraphicsConfigurationARB: SharedContext is null: " + abstractGraphicsDevice);
            }
            return false;
        }
        GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)windowsWGLGraphicsConfiguration.getChosenCapabilities();
        boolean bl2 = gLCapabilitiesImmutable.isOnscreen();
        boolean bl3 = gLCapabilitiesImmutable.isPBuffer();
        GLProfile gLProfile = gLCapabilitiesImmutable.getGLProfile();
        CapabilitiesImmutable[] capabilitiesImmutableArray = null;
        GLCapabilitiesImmutable gLCapabilitiesImmutable2 = null;
        boolean bl4 = false;
        if (!windowsWGLContext.isExtensionAvailable("WGL_ARB_pixel_format")) {
            if (DEBUG) {
                System.err.println("updateGraphicsConfigurationARB: WGL_ARB_pixel_format not available");
            }
            return false;
        }
        windowsWGLContext.makeCurrent();
        try {
            if (!bl && 1 <= (n = GDI.GetPixelFormat((long)l))) {
                if (DEBUG) {
                    System.err.println("updateGraphicsConfigurationARB: Pixel format already chosen for HDC: " + WindowsWGLGraphicsConfigurationFactory.toHexString(l) + ", pixelformat " + n);
                }
                bl4 = true;
                gLCapabilitiesImmutable2 = WindowsWGLGraphicsConfiguration.wglARBPFID2GLCapabilities(windowsWGLContext, l, n, gLProfile, bl2, bl3);
            } else {
                int n2;
                int n3 = -1;
                if (null == nArray) {
                    int[] nArray2 = new int[512];
                    float[] fArray = new float[1];
                    nArray = WindowsWGLGraphicsConfiguration.wglChoosePixelFormatARB(l, windowsWGLContext, gLCapabilitiesImmutable, nArray2, -1, fArray);
                    if (null != nArray) {
                        n3 = 0;
                        if (DEBUG) {
                            System.err.println("updateGraphicsConfigurationARB: NumFormats (wglChoosePixelFormatARB) " + nArray.length);
                            System.err.println("updateGraphicsConfigurationARB: Used wglChoosePixelFormatARB to recommend pixel format " + nArray[n3] + ", idx " + n3);
                        }
                    } else {
                        nArray = WindowsWGLGraphicsConfiguration.wglAllARBPFIDs(windowsWGLContext, l);
                        if (DEBUG) {
                            System.err.println("updateGraphicsConfigurationARB: NumFormats (wglAllARBPFIDs) " + nArray.length);
                        }
                    }
                    if (null == nArray) {
                        if (DEBUG) {
                            Thread.dumpStack();
                        }
                        boolean bl5 = false;
                        return bl5;
                    }
                }
                if (0 > (n2 = WindowsWGLGraphicsConfigurationFactory.chooseCapabilities(capabilitiesChooser, gLCapabilitiesImmutable, capabilitiesImmutableArray = WindowsWGLGraphicsConfiguration.wglARBPFIDs2GLCapabilities(windowsWGLContext, l, nArray, gLProfile, bl2, bl3), n3))) {
                    if (DEBUG) {
                        Thread.dumpStack();
                    }
                    boolean bl6 = false;
                    return bl6;
                }
                gLCapabilitiesImmutable2 = capabilitiesImmutableArray[n2];
                n = nArray[n2];
                if (DEBUG) {
                    System.err.println("!!! chosen pfdID " + n + ", caps " + gLCapabilitiesImmutable2);
                }
            }
        }
        finally {
            windowsWGLContext.release();
        }
        PIXELFORMATDESCRIPTOR pIXELFORMATDESCRIPTOR = WindowsWGLGraphicsConfiguration.createPixelFormatDescriptor();
        if (GDI.DescribePixelFormat((long)l, (int)n, (int)pIXELFORMATDESCRIPTOR.size(), (PIXELFORMATDESCRIPTOR)pIXELFORMATDESCRIPTOR) == 0) {
            throw new GLException("updateGraphicsConfigurationARB: Error describing the chosen pixel format: " + n + ", " + GDI.GetLastError());
        }
        if (!bl && !bl4) {
            if (!GDI.SetPixelFormat((long)l, (int)n, (PIXELFORMATDESCRIPTOR)pIXELFORMATDESCRIPTOR)) {
                throw new GLException("Unable to set pixel format " + n + " for device context " + WindowsWGLGraphicsConfigurationFactory.toHexString(l) + ": error code " + GDI.GetLastError());
            }
            if (DEBUG) {
                System.err.println("!!! setPixelFormat (ARB): hdc " + WindowsWGLGraphicsConfigurationFactory.toHexString(l) + ", " + windowsWGLGraphicsConfiguration.getPixelFormatID() + " -> " + n);
            }
        }
        windowsWGLGraphicsConfiguration.setCapsPFD(gLCapabilitiesImmutable2, pIXELFORMATDESCRIPTOR, n, true);
        return true;
    }

    private static boolean updateGraphicsConfigurationGDI(long l, boolean bl, WindowsWGLGraphicsConfiguration windowsWGLGraphicsConfiguration, CapabilitiesChooser capabilitiesChooser, int[] nArray) {
        int n;
        GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)windowsWGLGraphicsConfiguration.getChosenCapabilities();
        boolean bl2 = gLCapabilitiesImmutable.isOnscreen();
        boolean bl3 = gLCapabilitiesImmutable.isPBuffer();
        GLProfile gLProfile = gLCapabilitiesImmutable.getGLProfile();
        CapabilitiesImmutable[] capabilitiesImmutableArray = null;
        GLCapabilitiesImmutable gLCapabilitiesImmutable2 = null;
        boolean bl4 = false;
        PIXELFORMATDESCRIPTOR pIXELFORMATDESCRIPTOR = WindowsWGLGraphicsConfiguration.createPixelFormatDescriptor();
        if (!bl && 1 <= (n = GDI.GetPixelFormat((long)l))) {
            if (DEBUG) {
                System.err.println("updateGraphicsConfigurationGDI: NOTE: pixel format already chosen for HDC: " + WindowsWGLGraphicsConfigurationFactory.toHexString(l) + ", pixelformat " + n);
            }
            bl4 = true;
            gLCapabilitiesImmutable2 = WindowsWGLGraphicsConfiguration.PFD2GLCapabilities(gLProfile, l, n, bl2, bl3, pIXELFORMATDESCRIPTOR);
        } else {
            int n2;
            int n3;
            if (null == nArray) {
                nArray = WindowsWGLGraphicsConfiguration.wglAllGDIPFIDs(l);
            }
            int n4 = nArray.length;
            capabilitiesImmutableArray = new GLCapabilitiesImmutable[n4];
            for (n3 = 0; n3 < n4; ++n3) {
                capabilitiesImmutableArray[n3] = WindowsWGLGraphicsConfiguration.PFD2GLCapabilities(gLProfile, l, nArray[n3], bl2, bl3, pIXELFORMATDESCRIPTOR);
            }
            pIXELFORMATDESCRIPTOR = WindowsWGLGraphicsConfiguration.GLCapabilities2PFD(gLCapabilitiesImmutable, pIXELFORMATDESCRIPTOR);
            n = GDI.ChoosePixelFormat((long)l, (PIXELFORMATDESCRIPTOR)pIXELFORMATDESCRIPTOR);
            n3 = -1;
            if (1 <= n) {
                for (n3 = n4 - 1; 0 <= n3 && n != nArray[n3]; --n3) {
                }
            }
            if (DEBUG) {
                System.err.println("updateGraphicsConfigurationGDI: ChoosePixelFormat(HDC " + WindowsWGLGraphicsConfigurationFactory.toHexString(l) + ") = " + n + ", idx " + n3 + " (LastError: " + GDI.GetLastError() + ")");
            }
            if (0 > (n2 = WindowsWGLGraphicsConfigurationFactory.chooseCapabilities(capabilitiesChooser, gLCapabilitiesImmutable, capabilitiesImmutableArray, n3))) {
                if (DEBUG) {
                    Thread.dumpStack();
                }
                return false;
            }
            gLCapabilitiesImmutable2 = capabilitiesImmutableArray[n2];
            n = nArray[n2];
            if (DEBUG) {
                System.err.println("!!! chosen pfdID " + n + ", idx " + n2 + ", caps " + gLCapabilitiesImmutable2);
            }
        }
        if (GDI.DescribePixelFormat((long)l, (int)n, (int)pIXELFORMATDESCRIPTOR.size(), (PIXELFORMATDESCRIPTOR)pIXELFORMATDESCRIPTOR) == 0) {
            throw new GLException("Error describing the chosen pixel format: " + n + ", " + GDI.GetLastError());
        }
        if (!bl && !bl4) {
            if (!GDI.SetPixelFormat((long)l, (int)n, (PIXELFORMATDESCRIPTOR)pIXELFORMATDESCRIPTOR)) {
                throw new GLException("Unable to set pixel format " + n + " for device context " + WindowsWGLGraphicsConfigurationFactory.toHexString(l) + ": error code " + GDI.GetLastError());
            }
            if (DEBUG) {
                System.err.println("!!! setPixelFormat (GDI): hdc " + WindowsWGLGraphicsConfigurationFactory.toHexString(l) + ", " + windowsWGLGraphicsConfiguration.getPixelFormatID() + " -> " + n);
            }
        }
        windowsWGLGraphicsConfiguration.setCapsPFD(gLCapabilitiesImmutable2, pIXELFORMATDESCRIPTOR, n, false);
        return true;
    }

    static String getThreadName() {
        return Thread.currentThread().getName();
    }

    static String toHexString(long l) {
        return "0x" + Long.toHexString(l);
    }
}

