/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.nativewindow.impl.windows;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.StructAccessor;
import com.jogamp.common.os.Platform;
import com.jogamp.nativewindow.impl.windows.BITMAPINFO32;
import com.jogamp.nativewindow.impl.windows.BITMAPINFO64;
import com.jogamp.nativewindow.impl.windows.BITMAPINFOHEADER;
import java.nio.ByteBuffer;

public abstract class BITMAPINFO {
    StructAccessor accessor;

    public static int size() {
        if (Platform.is32Bit()) {
            return BITMAPINFO32.size();
        }
        return BITMAPINFO64.size();
    }

    public static BITMAPINFO create() {
        return BITMAPINFO.create(Buffers.newDirectByteBuffer((int)BITMAPINFO.size()));
    }

    public static BITMAPINFO create(ByteBuffer byteBuffer) {
        if (Platform.is32Bit()) {
            return new BITMAPINFO32(byteBuffer);
        }
        return new BITMAPINFO64(byteBuffer);
    }

    BITMAPINFO(ByteBuffer byteBuffer) {
        this.accessor = new StructAccessor(byteBuffer);
    }

    public ByteBuffer getBuffer() {
        return this.accessor.getBuffer();
    }

    public abstract BITMAPINFOHEADER getBmiHeader();
}

